/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.emma;

import ca.pfv.spmf.algorithms.episodes.general.AbstractEpisode;
import java.util.ArrayList;
import java.util.List;

public class EpisodeEMMA
extends AbstractEpisode
implements Comparable<EpisodeEMMA> {
    EpisodeEMMA(int support) {
        super(support);
    }

    public EpisodeEMMA(List<int[]> events, int support) {
        super(events, support);
    }

    public EpisodeEMMA iExtension(int item, int support) {
        int[] finalEventSet = (int[])this.events.get(this.events.size() - 1);
        int len = finalEventSet.length;
        int[] newEventSet = new int[len + 1];
        System.arraycopy(finalEventSet, 0, newEventSet, 0, len);
        newEventSet[len] = item;
        ArrayList<int[]> newEvents = new ArrayList<int[]>(this.events);
        newEvents.set(this.events.size() - 1, newEventSet);
        return new EpisodeEMMA(newEvents, support);
    }

    public EpisodeEMMA sExtension(int[] fllowingEpisodeName, int support) {
        ArrayList<int[]> newEvents = new ArrayList<int[]>(this.events);
        newEvents.add(fllowingEpisodeName);
        return new EpisodeEMMA(newEvents, support);
    }

    @Override
    public int compareTo(EpisodeEMMA o) {
        if (o == this) {
            return 0;
        }
        long compare = this.support - o.support;
        if (compare > 0L) {
            return 1;
        }
        if (compare < 0L) {
            return -1;
        }
        return 0;
    }
}

