/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.general;

import ca.pfv.spmf.algorithms.episodes.general.AbstractEpisode;
import ca.pfv.spmf.algorithms.episodes.general.Level;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FrequentEpisodes {
    private final List<Level> levels = new ArrayList<Level>();
    private int episodeCount = 0;

    public FrequentEpisodes() {
        this.levels.add(new Level());
    }

    public List<Level> getLevels() {
        return this.levels;
    }

    public void addFrequentEpisode(AbstractEpisode episode, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new Level());
        }
        this.levels.get(k).addFreEpisode(episode);
        ++this.episodeCount;
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        StringBuilder buffer = new StringBuilder();
        for (Level l : this.levels) {
            for (AbstractEpisode episode : l.getKFrequentEpisodes()) {
                buffer.append(episode.toString());
                buffer.append(System.lineSeparator());
            }
        }
        writer.write(buffer.toString());
        writer.close();
    }

    public int getTotalLevelNum() {
        return this.levels.size();
    }

    public int getFrequentEpisodesCount() {
        return this.episodeCount;
    }

    public void printFrequentEpisodes() {
        for (Level l : this.levels) {
            for (AbstractEpisode episode : l.getKFrequentEpisodes()) {
                System.out.println(episode.toString());
            }
        }
    }
}

