/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.minepi;

import ca.pfv.spmf.algorithms.episodes.minepi.Event;
import ca.pfv.spmf.algorithms.episodes.minepi.FSA4MINEPI;
import ca.pfv.spmf.algorithms.episodes.minepi.FrequentEpisodes;
import ca.pfv.spmf.algorithms.episodes.minepi.SerialEpisode;
import java.util.ArrayList;
import java.util.List;

public class Candidates {
    List<Integer> blockStart;
    List<int[]> candidates = new ArrayList<int[]>();
    int candidateCount = 0;
    int k;

    Candidates(int k) {
        this.blockStart = new ArrayList<Integer>();
        this.k = k;
    }

    public void addCandidate(int[] candidate, int blockIndex) {
        this.candidates.add(candidate);
        this.blockStart.add(blockIndex);
        ++this.candidateCount;
    }

    public boolean isEmpty() {
        return this.candidates.size() <= 0;
    }

    public int getCandidateCount() {
        return this.candidateCount;
    }

    public void getFrequentKepisodes(List<Event> sequence, int minSupport, int maxWindow, FrequentEpisodes frequentEpisodes) {
        int lastBlockStart = -1;
        int currentBlockStart = -1;
        int k = -1;
        int i = 0;
        while (i < this.candidateCount) {
            ArrayList<FSA4MINEPI> fsaList = new ArrayList<FSA4MINEPI>();
            fsaList.add(new FSA4MINEPI(this.candidates.get(i)));
            int support = 0;
            for (Event eventSet : sequence) {
                int currentFSAsize = fsaList.size();
                int j = currentFSAsize - 1;
                while (j >= 0) {
                    if (eventSet.contains(((FSA4MINEPI)fsaList.get(j)).waiting4Event())) {
                        ((FSA4MINEPI)fsaList.get(j)).transit();
                        if (j == currentFSAsize - 1) {
                            ((FSA4MINEPI)fsaList.get(j)).setStartTime(eventSet.getTime());
                            fsaList.add(new FSA4MINEPI(this.candidates.get(i)));
                        }
                        if (((FSA4MINEPI)fsaList.get(j)).isEnd()) {
                            if (((FSA4MINEPI)fsaList.get(j)).getWinLength(eventSet.getTime()) <= maxWindow) {
                                ++support;
                            }
                            fsaList.remove(j);
                        }
                        if (j >= 1 && ((FSA4MINEPI)fsaList.get(j)).isSame((FSA4MINEPI)fsaList.get(j - 1)) && !eventSet.contains(((FSA4MINEPI)fsaList.get(j - 1)).waiting4Event())) {
                            fsaList.remove(j - 1);
                            --j;
                        }
                    }
                    --j;
                }
            }
            if (support >= minSupport) {
                ++k;
                if (this.blockStart.get(i) != lastBlockStart) {
                    lastBlockStart = this.blockStart.get(i);
                    currentBlockStart = k;
                }
                SerialEpisode episode = new SerialEpisode(this.candidates.get(i), support);
                frequentEpisodes.addFrequentFpisodeAndBlockStart(episode, this.k, currentBlockStart);
            }
            ++i;
        }
    }
}

