/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.minepi;

import ca.pfv.spmf.algorithms.episodes.minepi.Candidates;
import ca.pfv.spmf.algorithms.episodes.minepi.Level;
import ca.pfv.spmf.algorithms.episodes.minepi.SerialEpisode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FrequentEpisodes {
    private final List<Level> levels = new ArrayList<Level>();
    private int episodeCount = 0;

    public FrequentEpisodes() {
        this.levels.add(new Level());
    }

    public void addFrequentEpisode(SerialEpisode episode, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new Level());
        }
        this.levels.get(k).addFreEpisode(episode);
        ++this.episodeCount;
    }

    public void addFrequentFpisodeAndBlockStart(SerialEpisode episode, int k, int block_start) {
        while (this.levels.size() <= k) {
            this.levels.add(new Level());
        }
        this.levels.get(k).addFreEpisodeAndBlockStart(episode, block_start);
        ++this.episodeCount;
    }

    public void initFirstLevelBlockStart() {
        this.levels.get(1).init_firstLevel_block_start();
    }

    public void out2file(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        StringBuilder buffer = new StringBuilder();
        for (Level l : this.levels) {
            for (SerialEpisode episode : l.getK_freEpisodes()) {
                buffer.append(episode.toString());
                buffer.append("\r\n");
            }
        }
        writer.write(buffer.toString());
        writer.close();
    }

    public Candidates genCandidateByLevel(int k) {
        if (this.levels.size() > k) {
            return this.levels.get(k).genCandidateEpisode(k);
        }
        return null;
    }

    public int getFrequentEpisodesCount() {
        return this.episodeCount;
    }

    public void printFrequentEpisodes() {
        int numLevel = 0;
        for (Level l : this.levels) {
            System.out.println("  L" + numLevel + " +\r\n");
            for (SerialEpisode episode : l.getK_freEpisodes()) {
                System.out.println(String.valueOf(episode.toString()) + "\r\n");
            }
            System.out.println("\r\n");
            ++numLevel;
        }
    }
}

