/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.poerm;

import ca.pfv.spmf.algorithms.episodes.poerm.EventSetAppear;
import ca.pfv.spmf.algorithms.episodes.poerm.Interval;
import ca.pfv.spmf.algorithms.episodes.poerm.POERParas;
import ca.pfv.spmf.algorithms.episodes.poerm.POERRule;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoPOERMAll {
    private String inputFile;
    private long startTime;
    private long endTime;
    private long deltaTime;
    private POERParas parameter = null;
    private Map<Integer, List<Integer>> XFreS;
    private Map<Integer, List<Integer>> YFreS;
    private Map<Integer, List<Interval>> thisAppear;
    private List<EventSetAppear> XFreAppear;
    private List<EventSetAppear> YFreAppear;
    private List<POERRule> ruleAppear;
    private DecimalFormat formatter = new DecimalFormat("#.####");
    private double maxMemory;
    private int maxWindowNum;

    public long getDeltaTime() {
        return this.deltaTime;
    }

    public double getMaxMemory() {
        return this.maxMemory;
    }

    public int getMaxWindowNum() {
        return this.maxWindowNum;
    }

    public List<POERRule> runAlgorithm(String inputFile, int minSupport, int xSpan, int ySpan, double minConfidence, int xySpan, boolean selfIncrement) {
        this.XFreS = new HashMap<Integer, List<Integer>>();
        this.YFreS = new HashMap<Integer, List<Integer>>();
        this.thisAppear = new HashMap<Integer, List<Interval>>();
        this.XFreAppear = new ArrayList<EventSetAppear>();
        this.YFreAppear = new ArrayList<EventSetAppear>();
        this.ruleAppear = new ArrayList<POERRule>();
        this.inputFile = inputFile;
        this.parameter = new POERParas(minSupport, xSpan, ySpan, minConfidence, xySpan, selfIncrement);
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.preProcess(this.inputFile);
        this.miningXEventSet2();
        this.miningYEventSet();
        this.findRule();
        MemoryLogger.getInstance().checkMemory();
        this.maxMemory = MemoryLogger.getInstance().getMaxMemory();
        this.endTime = System.currentTimeMillis();
        this.deltaTime = this.endTime - this.startTime;
        return this.ruleAppear;
    }

    public void miningXEventSet2() {
        try {
            int index = 0;
            int end = this.XFreAppear.size();
            while (index < end) {
                this.thisAppear.clear();
                EventSetAppear episodeAppear = this.XFreAppear.get(index);
                ++index;
                List<Integer> episode = episodeAppear.getEventSet();
                Integer compareKey = episode.get(episode.size() - 1);
                List<Interval> appear = episodeAppear.getIntervals();
                for (Interval interval : appear) {
                    ArrayList<Interval> appearTime;
                    List<Integer> eventSet;
                    Integer intStart = interval.start;
                    Integer intEnd = interval.end;
                    int j = intEnd - this.parameter.getXSpan() + 1;
                    while (j < intStart) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(j, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList<Interval>();
                                appearTime.add(new Interval(j, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                    j = intEnd + 1;
                    while (j < intStart + this.parameter.getXSpan()) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(intStart, j));
                                    continue;
                                }
                                appearTime = new ArrayList();
                                appearTime.add(new Interval(intStart, j));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                    j = intStart;
                    while (j <= intEnd) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(intStart, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList();
                                appearTime.add(new Interval(intStart, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                }
                for (Map.Entry entry : this.thisAppear.entrySet()) {
                    Integer key = (Integer)entry.getKey();
                    List value = (List)entry.getValue();
                    value.sort(new myComparator());
                    ArrayList<Interval> newValue = new ArrayList<Interval>();
                    int i = 0;
                    while (i < value.size()) {
                        if (i == 0 || !((Interval)value.get(i)).equal((Interval)newValue.get(newValue.size() - 1)).booleanValue()) {
                            newValue.add((Interval)value.get(i));
                        }
                        ++i;
                    }
                    if (newValue.size() < this.parameter.getMinSupport()) continue;
                    ArrayList<Integer> newKey = new ArrayList<Integer>(episode);
                    newKey.add(key);
                    this.XFreAppear.add(new EventSetAppear(newKey, newValue));
                }
                end = this.XFreAppear.size();
                MemoryLogger.getInstance().checkMemory();
            }
            System.out.println("end: " + end);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void preProcess(String input) {
        try {
            block16: {
                eventSet = new HashMap<Integer, Integer>();
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
                line = null;
                timestamp = 1;
                preTimestamp = -1;
                maxWindow = this.parameter.getXSpan() + this.parameter.getYSpan() + this.parameter.getXYSpan() - 1;
                this.maxWindowNum = 0;
                if (!this.parameter.isSelfIncrement()) ** GOTO lbl94
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') {
                        ++timestamp;
                        continue;
                    }
                    array = line.split(" ");
                    eSet = new ArrayList<Integer>();
                    eSet2 = new ArrayList<Integer>();
                    var15_23 = array;
                    var14_21 = array.length;
                    var13_19 = 0;
                    while (var13_19 < var14_21) {
                        event = var15_23[var13_19];
                        num = Integer.parseInt(event);
                        support = (Integer)eventSet.get(num);
                        if (support != null) {
                            eventSet.put(num, support + 1);
                            this.thisAppear.get(num).add(new Interval(timestamp, timestamp));
                        } else {
                            eventSet.put(num, 1);
                            interval = new ArrayList<Interval>();
                            interval.add(new Interval(timestamp, timestamp));
                            this.thisAppear.put(num, interval);
                        }
                        eSet.add(num);
                        eSet2.add(num);
                        ++var13_19;
                    }
                    if (eSet.size() > 0) {
                        this.XFreS.put(timestamp, eSet2);
                    }
                    if (preTimestamp == -1) {
                        preTimestamp = timestamp;
                    }
                    if (timestamp - preTimestamp > maxWindow) {
                        preTimestamp = timestamp;
                        ++this.maxWindowNum;
                    }
                    ++timestamp;
                }
                break block16;
lbl-1000:
                // 1 sources

                {
                    if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                    lineSplited = line.split("\\:");
                    timestamp = Integer.parseInt(lineSplited[1]);
                    array = lineSplited[0].split(" ");
                    eSet = new ArrayList<Integer>();
                    eSet2 = new ArrayList<Integer>();
                    var16_26 = array;
                    var15_24 = array.length;
                    var14_22 = 0;
                    while (var14_22 < var15_24) {
                        event = var16_26[var14_22];
                        num = Integer.parseInt(event);
                        support = (Integer)eventSet.get(num);
                        if (support != null) {
                            eventSet.put(num, support + 1);
                            this.thisAppear.get(num).add(new Interval(timestamp, timestamp));
                        } else {
                            eventSet.put(num, 1);
                            interval = new ArrayList<Interval>();
                            interval.add(new Interval(timestamp, timestamp));
                            this.thisAppear.put(num, interval);
                        }
                        eSet.add(num);
                        eSet2.add(num);
                        ++var14_22;
                    }
                    if (eSet.size() > 0) {
                        this.XFreS.put(timestamp, eSet2);
                    }
                    if (preTimestamp == -1) {
                        preTimestamp = timestamp;
                    }
                    if (timestamp - preTimestamp <= maxWindow) continue;
                    preTimestamp = timestamp;
                    ++this.maxWindowNum;
lbl94:
                    // 4 sources

                    ** while ((line = reader.readLine()) != null)
                }
            }
            MemoryLogger.getInstance().checkMemory();
            this.loadFrequent(eventSet);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadFrequent(Map<Integer, Integer> eventSet) {
        for (Map.Entry<Integer, List<Integer>> entry : this.XFreS.entrySet()) {
            List<Integer> eSet = entry.getValue();
            ArrayList<Integer> XnewList = new ArrayList<Integer>();
            ArrayList<Integer> YnewList = new ArrayList<Integer>();
            for (Integer e : eSet) {
                int support = eventSet.get(e);
                if (!((double)support >= (double)this.parameter.getMinSupport() * this.parameter.getMinConfidence())) continue;
                YnewList.add(e);
                if (support < this.parameter.getMinSupport()) continue;
                XnewList.add(e);
            }
            this.XFreS.put(entry.getKey(), XnewList);
            this.YFreS.put(entry.getKey(), YnewList);
        }
        for (Map.Entry<Integer, Object> entry : eventSet.entrySet()) {
            Integer key = entry.getKey();
            Integer val = (Integer)entry.getValue();
            ArrayList<Integer> numKey = new ArrayList<Integer>();
            numKey.add(key);
            if (!((double)val.intValue() >= (double)this.parameter.getMinSupport() * this.parameter.getMinConfidence())) continue;
            List<Interval> value = this.thisAppear.get(key);
            this.YFreAppear.add(new EventSetAppear(numKey, value));
            if (val < this.parameter.getMinSupport()) continue;
            this.XFreAppear.add(new EventSetAppear(numKey, value));
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void miningXEventSet() {
        try {
            int index = 0;
            int end = this.XFreAppear.size();
            while (index < end) {
                this.thisAppear.clear();
                EventSetAppear episodeAppear = this.XFreAppear.get(index);
                ++index;
                List<Integer> episode = episodeAppear.getEventSet();
                Integer compareKey = episode.get(episode.size() - 1);
                List<Interval> appear = episodeAppear.getIntervals();
                for (Interval interval : appear) {
                    ArrayList<Interval> appearTime;
                    List<Integer> eventSet;
                    Integer intStart = interval.start;
                    Integer intEnd = interval.end;
                    int j = intEnd - this.parameter.getXSpan() + 1;
                    while (j < intStart) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(j, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList<Interval>();
                                appearTime.add(new Interval(j, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                    j = intEnd + 1;
                    while (j < intStart + this.parameter.getXSpan()) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(intStart, j));
                                    continue;
                                }
                                appearTime = new ArrayList();
                                appearTime.add(new Interval(intStart, j));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                    j = intStart;
                    while (j <= intEnd) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(intStart, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList();
                                appearTime.add(new Interval(intStart, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                }
                for (Map.Entry entry : this.thisAppear.entrySet()) {
                    Integer key = (Integer)entry.getKey();
                    List value = (List)entry.getValue();
                    value.sort(new myComparator());
                    ArrayList<Interval> newValue = new ArrayList<Interval>();
                    int i = 0;
                    while (i < value.size()) {
                        if (i == 0 || !((Interval)value.get(i)).equal((Interval)newValue.get(newValue.size() - 1)).booleanValue()) {
                            newValue.add((Interval)value.get(i));
                        }
                        ++i;
                    }
                    if (newValue.size() < this.parameter.getMinSupport()) continue;
                    ArrayList<Integer> newKey = new ArrayList<Integer>(episode);
                    newKey.add(key);
                    this.XFreAppear.add(new EventSetAppear(newKey, newValue));
                }
                end = this.XFreAppear.size();
                MemoryLogger.getInstance().checkMemory();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void miningYEventSet() {
        try {
            int index = 0;
            int end = this.YFreAppear.size();
            while (index < end) {
                this.thisAppear.clear();
                EventSetAppear episodeAppear = this.YFreAppear.get(index);
                ++index;
                List<Integer> episode = episodeAppear.getEventSet();
                Integer compareKey = episode.get(episode.size() - 1);
                List<Interval> appear = episodeAppear.getIntervals();
                for (Interval interval : appear) {
                    ArrayList<Interval> appearTime;
                    List<Integer> eventSet;
                    Integer intStart = interval.start;
                    Integer intEnd = interval.end;
                    int j = intEnd - this.parameter.getYSpan() + 1;
                    while (j < intStart) {
                        if (this.YFreS.containsKey(j)) {
                            eventSet = this.YFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(j, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList<Interval>();
                                appearTime.add(new Interval(j, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                    j = intEnd + 1;
                    while (j < intStart + this.parameter.getYSpan()) {
                        if (this.YFreS.containsKey(j)) {
                            eventSet = this.YFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                List<Interval> list = this.thisAppear.get(eventItem);
                                if (list != null) {
                                    list.add(new Interval(intStart, j));
                                    continue;
                                }
                                ArrayList<Interval> appearTime2 = new ArrayList<Interval>();
                                appearTime2.add(new Interval(intStart, j));
                                this.thisAppear.put(eventItem, appearTime2);
                            }
                        }
                        ++j;
                    }
                    j = intStart;
                    while (j <= intEnd) {
                        if (this.YFreS.containsKey(j)) {
                            eventSet = this.YFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(intStart, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList();
                                appearTime.add(new Interval(intStart, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                }
                for (Map.Entry entry : this.thisAppear.entrySet()) {
                    Integer key = (Integer)entry.getKey();
                    List value = (List)entry.getValue();
                    value.sort(new myComparator());
                    ArrayList<Interval> newValue = new ArrayList<Interval>();
                    int i = 0;
                    while (i < value.size()) {
                        if (i == 0 || !((Interval)value.get(i)).equal((Interval)newValue.get(newValue.size() - 1)).booleanValue()) {
                            newValue.add((Interval)value.get(i));
                        }
                        ++i;
                    }
                    if (!((double)newValue.size() >= (double)this.parameter.getMinSupport() * this.parameter.getMinConfidence())) continue;
                    ArrayList<Integer> newKey = new ArrayList<Integer>(episode);
                    newKey.add(key);
                    this.YFreAppear.add(new EventSetAppear(newKey, newValue));
                }
                end = this.YFreAppear.size();
                MemoryLogger.getInstance().checkMemory();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void findRule() {
        System.out.println("XFreAppear: " + this.XFreAppear.size() + " ");
        System.out.println("YFreAppear: " + this.YFreAppear.size() + " ");
        for (EventSetAppear anitemset : this.XFreAppear) {
            anitKey = anitemset.getEventSet();
            anitValues = anitemset.getIntervals();
            anitStart = 0;
            anitCount = 0;
            for (Interval anitValue : anitValues) {
                if (anitValue.start <= anitStart) continue;
                ++anitCount;
                anitStart = anitValue.end;
            }
            if (anitCount < this.parameter.getMinSupport()) continue;
            for (EventSetAppear conseset : this.YFreAppear) {
                start = 0;
                j = 0;
                conseKey = conseset.getEventSet();
                if (anitKey.size() > 1 && conseKey.get(0) == 3) {
                    System.out.println(" aaa ");
                }
                conseValue = conseset.getIntervals();
                intervalList = new ArrayList<Interval>();
                anitIndex = false;
                block3: for (Interval anitValue : anitValues) {
                    if (anitValue.start > start) ** GOTO lbl27
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        ++j;
lbl27:
                        // 2 sources

                        ** while (j < conseValue.size() && conseValue.get((int)j).end <= anitValue.end)
                    }
lbl28:
                    // 1 sources

                    k = j;
                    while (k < conseValue.size()) {
                        if (conseValue.get((int)k).end - this.parameter.getYSpan() + 1 - this.parameter.getXYSpan() > anitValue.end) continue block3;
                        if (conseValue.get((int)k).start > anitValue.end && conseValue.get((int)k).start <= anitValue.end + this.parameter.getXYSpan()) {
                            intervalList.add(anitValue);
                            intervalList.add(conseValue.get(k));
                            intervalList.add(new Interval(0, 0));
                            start = conseValue.get((int)k).end;
                            continue block3;
                        }
                        ++k;
                    }
                }
                confidence = intervalList.size() / 3;
                MemoryLogger.getInstance().checkMemory();
                if (!((double)confidence >= (double)anitCount * this.parameter.getMinConfidence())) continue;
                this.ruleAppear.add(new POERRule(anitKey, conseKey, null, anitCount, confidence));
            }
        }
    }

    public void printRule() {
        for (POERRule poerrule : this.ruleAppear) {
            String episodeRule = "";
            List<Integer> antiEpisode = poerrule.getAntiEpisode();
            List<Integer> conseEpisode = poerrule.getConseEpisode();
            for (Integer anti : antiEpisode) {
                episodeRule = String.valueOf(episodeRule) + anti + " ";
            }
            episodeRule = String.valueOf(episodeRule) + "==> ";
            for (Integer conse : conseEpisode) {
                episodeRule = String.valueOf(episodeRule) + conse + " ";
            }
            System.out.println("rule: " + episodeRule + "#SUP: " + poerrule.getRuleCount() + " #CONF: " + this.formatter.format((double)poerrule.getRuleCount() / (double)poerrule.getAntiCount()));
        }
    }

    public void writeRule2File(String filename) {
        try {
            MemoryLogger.getInstance().checkMemory();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, false)));
            StringBuilder buffer = new StringBuilder();
            for (POERRule poerrule : this.ruleAppear) {
                for (Integer anti : poerrule.getAntiEpisode()) {
                    buffer.append(anti);
                    buffer.append(' ');
                }
                buffer.append("==> ");
                for (Integer conse : poerrule.getConseEpisode()) {
                    buffer.append(conse);
                    buffer.append(' ');
                }
                buffer.append("#SUP: ");
                buffer.append(poerrule.getAntiCount());
                buffer.append(" #CONF: ");
                buffer.append(String.valueOf(this.formatter.format((double)poerrule.getRuleCount() / (double)poerrule.getAntiCount())) + System.lineSeparator());
            }
            bw.write(buffer.toString());
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printStats() {
        System.out.println("=============  POERM-ALL v.2.45 - STATS =============");
        System.out.println(" Rule count : " + this.ruleAppear.size());
        System.out.println(" Maximum memory usage : " + this.formatter.format(this.maxMemory) + " mb");
        System.out.println(" Total time ~ : " + this.deltaTime + " ms");
        System.out.println("===================================================");
    }

    public class myComparator
    implements Comparator<Interval> {
        @Override
        public int compare(Interval a, Interval b) {
            if (a.end == b.end) {
                return a.start - b.start;
            }
            return a.end - b.end;
        }
    }

    public class myComparator2
    implements Comparator<Interval> {
        @Override
        public int compare(Interval a, Interval b) {
            if (a.start == b.start) {
                return a.end - b.end;
            }
            return a.start - b.start;
        }
    }
}

