/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.standardepisoderules;

import ca.pfv.spmf.algorithms.episodes.emma.EpisodeEMMA;
import ca.pfv.spmf.algorithms.episodes.general.AbstractEpisode;
import ca.pfv.spmf.algorithms.episodes.general.FrequentEpisodes;
import ca.pfv.spmf.algorithms.episodes.general.Level;
import ca.pfv.spmf.algorithms.episodes.standardepisoderules.EpisodeRule;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class AlgoGenerateEpisodeRules {
    private List<EpisodeRule> ruleList = new ArrayList<EpisodeRule>();
    private double maxMemory = 0.0;
    private long runtime = 0L;

    public List<EpisodeRule> runAlgorithm(FrequentEpisodes frequentEpisodes, int support, double conf, int predictItemNum) {
        MemoryLogger.getInstance().reset();
        this.runtime = System.currentTimeMillis();
        List<Level> levelList = frequentEpisodes.getLevels();
        int numLevel = 2;
        while (numLevel < levelList.size()) {
            Level l = levelList.get(numLevel);
            for (AbstractEpisode episode : l.getKFrequentEpisodes()) {
                List<int[]> events = episode.getEvents();
                ArrayList<int[]> events2 = new ArrayList<int[]>();
                int totalCount = episode.getSupport();
                int antiItem = 1;
                while (antiItem < numLevel) {
                    events2.add(events.get(antiItem - 1));
                    if (numLevel - antiItem <= predictItemNum) {
                        Level pre = levelList.get(antiItem);
                        for (AbstractEpisode episode2 : pre.getKFrequentEpisodes()) {
                            if ((double)totalCount / (double)episode2.getSupport() <= conf || episode2.getSupport() <= support || !episode2.equal(events2)) continue;
                            ArrayList<int[]> antiEvents = new ArrayList<int[]>();
                            antiEvents.addAll(events2);
                            ArrayList<int[]> conseEvents = new ArrayList<int[]>();
                            int conseItem = antiItem;
                            while (conseItem < numLevel) {
                                conseEvents.add(events.get(conseItem));
                                ++conseItem;
                            }
                            EpisodeRule rule = new EpisodeRule(antiEvents, conseEvents, totalCount, episode2.getSupport());
                            this.ruleList.add(rule);
                        }
                    }
                    ++antiItem;
                }
            }
            ++numLevel;
        }
        MemoryLogger.getInstance().checkMemory();
        this.maxMemory = MemoryLogger.getInstance().getMaxMemory();
        this.runtime = System.currentTimeMillis() - this.runtime;
        return this.ruleList;
    }

    public List<EpisodeRule> runAlgorithm(PriorityQueue<EpisodeEMMA> frequentEpisodes, int support, double conf, int predictItemNum) {
        FrequentEpisodes episodesByLevel = new FrequentEpisodes();
        for (EpisodeEMMA episode : frequentEpisodes) {
            episodesByLevel.addFrequentEpisode(episode, episode.size());
        }
        return this.runAlgorithm(episodesByLevel, support, conf, predictItemNum);
    }

    public List<EpisodeRule> getRuleList() {
        return this.ruleList;
    }

    public void printStats() {
        System.out.println("=============  Episode Rule Mining v.2.46 - STATS =============");
        System.out.println(" Episode Rule count : " + this.ruleList.size());
        System.out.println(" Maximum memory usage : " + this.maxMemory + " mb");
        System.out.println(" Total time ~ : " + this.runtime + " ms");
        System.out.println("===================================================");
    }

    public void writeRulesToFileSPMFFormat(String outputPath) {
        try {
            PrintWriter writer = new PrintWriter(outputPath, "UTF-8");
            writer.write(this.rulesAsString());
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void printRules() {
        System.out.println(this.rulesAsString());
    }

    private String rulesAsString() {
        DecimalFormat formater = new DecimalFormat("#.###");
        StringBuilder buffer = new StringBuilder();
        int z = 0;
        while (z < this.ruleList.size()) {
            EpisodeRule rule = this.ruleList.get(z);
            List<int[]> antecedent = rule.getAntiEvents();
            int j = 0;
            while (j < antecedent.size()) {
                int[] eventSet = antecedent.get(j);
                buffer.append('{');
                int i = 0;
                while (i < eventSet.length) {
                    buffer.append(eventSet[i]);
                    if (i != eventSet.length - 1) {
                        buffer.append(',');
                    } else {
                        buffer.append('}');
                    }
                    ++i;
                }
                ++j;
            }
            buffer.append(" ==> ");
            List<int[]> consequent = rule.getConseEvents();
            int j2 = 0;
            while (j2 < consequent.size()) {
                int[] eventSet = consequent.get(j2);
                buffer.append('{');
                int i = 0;
                while (i < eventSet.length) {
                    buffer.append(eventSet[i]);
                    if (i != eventSet.length - 1) {
                        buffer.append(',');
                    } else {
                        buffer.append('}');
                    }
                    ++i;
                }
                ++j2;
            }
            buffer.append(" #SUP: ");
            buffer.append(rule.getTotalCount());
            buffer.append(" #CONF: ");
            double confidence = (double)rule.getTotalCount() / (double)rule.getAntiCount();
            buffer.append(formater.format(confidence));
            buffer.append(System.lineSeparator());
            ++z;
        }
        return buffer.toString();
    }
}

