/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.upspan;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class CalculateDatabaseInfo {
    private String inputPath;
    private long totalUtility = 0L;
    private int databaseSize = 0;
    private int maxID = 0;
    private int sumAllLength = 0;
    private double avgLength = 0.0;
    private int maxLength = 0;
    private Set<Integer> allItem = new HashSet<Integer>();

    public CalculateDatabaseInfo(String inputPath) {
        this.inputPath = inputPath;
    }

    public boolean runCalculate() {
        String line = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.inputPath));
            while ((line = br.readLine()) != null) {
                ++this.databaseSize;
                String[] tokens1 = line.split(":");
                String[] tokens2 = tokens1[0].split(" ");
                this.totalUtility += Long.parseLong(tokens1[1]);
                this.sumAllLength += tokens2.length;
                if (this.maxLength < tokens2.length) {
                    this.maxLength = tokens2.length;
                }
                int i = 0;
                while (i < tokens2.length) {
                    int num = Integer.parseInt(tokens2[i]);
                    if (num > this.maxID) {
                        this.maxID = num;
                    }
                    this.allItem.add(num);
                    ++i;
                }
            }
            this.avgLength = (double)((int)((double)this.sumAllLength / (double)this.databaseSize * 100.0)) / 100.0;
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    public void OutputResult(String outputPath) {
        PrintWriter output = null;
        try {
            output = new PrintWriter(outputPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("----------Database Information----------");
        System.out.println("Input file path : " + this.inputPath);
        System.out.println("Output file path : " + outputPath);
        System.out.println("Number of transations : " + String.valueOf(this.databaseSize));
        System.out.println("Total utility : " + String.valueOf(this.totalUtility));
        System.out.println("Number of distinct items : " + String.valueOf(this.allItem.size()));
        System.out.println("Maximum Id of item : " + String.valueOf(this.maxID));
        System.out.println("Average length of transaction : " + String.valueOf(this.avgLength));
        System.out.println("Maximum length of transaction : " + String.valueOf(this.maxLength));
        output.println("----------Database Information----------");
        output.println("Input file path : " + this.inputPath);
        output.println("Output file path : " + outputPath);
        output.println("Number of transations : " + String.valueOf(this.databaseSize));
        output.println("Total utility : " + String.valueOf(this.totalUtility));
        output.println("Number of distinct items : " + String.valueOf(this.allItem.size()));
        output.println("Maximum Id of item : " + String.valueOf(this.maxID));
        output.println("Average length of transaction : " + String.valueOf(this.avgLength));
        output.println("Maximum length of transaction : " + String.valueOf(this.maxLength));
        output.close();
    }

    public int getMaxID() {
        return this.maxID;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getDBSize() {
        return this.databaseSize;
    }
}

