/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.HUIM_SA_HC;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUIMHC {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int transactionCount = 0;
    final int pop_size = 30;
    final int max_iter = 10000;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    List<Double> percentHUIChroNode;
    List<ChroNode> huiBA = new ArrayList<ChroNode>();
    List<ChroNode> population = new ArrayList<ChroNode>();
    List<ChroNode> subPopulation = new ArrayList<ChroNode>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Double> percentage = new ArrayList<Double>();
    List<Item> Items;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        block32: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block30: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                this.mapItemToTWU0 = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                Integer twu0 = this.mapItemToTWU0.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                this.mapItemToTWU0.put(item, twu0);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        ArrayList<Integer> pattern = new ArrayList<Integer>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                pattern.add(pair.item);
                            } else {
                                this.mapItemToTWU0.remove(pair.item);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        int i = 0;
        while (i < this.database.size()) {
            int j = 0;
            while (j < this.Items.size()) {
                int k = 0;
                while (k < this.database.get(i).size()) {
                    if (this.Items.get((int)j).item == this.database.get((int)i).get((int)k).item) {
                        this.Items.get((int)j).TIDS.set(i);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            this.pop_Init(minUtility);
            int i2 = 0;
            while (i2 < 10000) {
                this.subPopulation = this.neighbor(minUtility);
                if (this.huiBA.size() != 0) {
                    this.percentHUIChroNode = this.roulettePercentHUIBA();
                    int num1 = this.rouletteSelectHUIBA(this.percentHUIChroNode);
                    int num2 = this.rouletteSelectHUIBA(this.percentHUIChroNode);
                    int tempA = (int)(Math.random() * 30.0);
                    int tempB = (int)(Math.random() * 30.0);
                    this.population.get(tempA).deepcopy(this.huiBA.get(num1));
                    this.population.get(tempB).deepcopy(this.huiBA.get(num2));
                    int num3 = this.rouletteSelectHUIBA(this.percentHUIChroNode);
                    int tempC = (int)(Math.random() * 30.0);
                    this.population.get(tempC).deepcopy(this.huiBA.get(num3));
                }
                this.calculateRfitness();
                this.subPopulation.addAll(this.population);
                this.rankData(this.subPopulation);
                int j = 0;
                while (j < this.population.size()) {
                    this.population.set(j, this.subPopulation.get(j));
                    ++j;
                }
                this.subPopulation.clear();
                ++i2;
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void pop_Init(int minUtility) {
        int i = 0;
        this.percentage = this.roulettePercent();
        while (i < 30) {
            ChroNode tempNode = new ChroNode(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = this.select(this.percentage);
                if (tempNode.chromosome.get(temp)) continue;
                ++j;
                tempNode.chromosome.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(tempNode, transList);
            tempNode.calculateFitness(k, transList);
            tempNode.rank = 0;
            this.population.add(tempNode);
            if (tempNode.fitness >= minUtility && tempNode.chromosome.cardinality() > 0) {
                this.insert(tempNode);
                this.addHuiBA(tempNode);
            }
            ++i;
        }
    }

    public boolean pev_Check(ChroNode tempBAIndividual, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        int i = 0;
        while (i < tempBAIndividual.chromosome.length()) {
            if (tempBAIndividual.chromosome.get(i)) {
                templist.add(i);
            }
            ++i;
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.database.size());
        BitSet midBitSet = new BitSet(this.database.size());
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        int i2 = 1;
        while (i2 < templist.size()) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i2)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
            } else {
                tempBitSet = (BitSet)midBitSet.clone();
                tempBAIndividual.chromosome.clear((Integer)templist.get(i2));
            }
            ++i2;
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        int m = 0;
        while (m < tempBitSet.length()) {
            if (tempBitSet.get(m)) {
                list.add(m);
            }
            ++m;
        }
        return true;
    }

    private void rankData(List<ChroNode> tempPop) {
        Collections.sort(tempPop);
        int i = 0;
        while (i < tempPop.size() - 1) {
            tempPop.get((int)i).rank = i + 1;
            ++i;
        }
    }

    private List<ChroNode> neighbor(int minUtility) {
        int i = 0;
        while (i < 30) {
            int temp = (int)(Math.random() * (double)this.twuPattern.size());
            if (this.population.get((int)i).chromosome.get(temp)) {
                this.population.get((int)i).chromosome.clear(temp);
            } else {
                this.population.get((int)i).chromosome.set(temp);
            }
            int k = this.population.get((int)i).chromosome.cardinality();
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(this.population.get(i), transList);
            this.population.get(i).calculateFitness(k, transList);
            if (this.population.get((int)i).fitness >= minUtility && this.population.get((int)i).chromosome.cardinality() > 0) {
                this.insert(this.population.get(i));
                this.addHuiBA(this.population.get(i));
            }
            ++i;
        }
        return this.subPopulation;
    }

    private List<Double> roulettePercentHUIBA() {
        double sum = 0.0;
        double tempsum = 0.0;
        double percent = 0.0;
        ArrayList<Double> percentHUIBA = new ArrayList<Double>();
        int i = 0;
        while (i < this.huiBA.size()) {
            sum += (double)this.huiBA.get((int)i).fitness;
            ++i;
        }
        i = 0;
        while (i < this.huiBA.size()) {
            percent = (tempsum += (double)this.huiBA.get((int)i).fitness) / sum;
            percentHUIBA.add(percent);
            ++i;
        }
        return percentHUIBA;
    }

    private int rouletteSelectHUIBA(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    public void calculateRfitness() {
        int sum = 0;
        int temp = 0;
        int i = 0;
        while (i < this.population.size()) {
            sum += this.population.get((int)i).fitness;
            ++i;
        }
        i = 0;
        while (i < this.population.size()) {
            this.population.get((int)i).rfitness = (double)(temp += this.population.get((int)i).fitness) / ((double)sum + 0.0);
            ++i;
        }
    }

    private List<Double> roulettePercent() {
        double sum = 0.0;
        double tempSum = 0.0;
        int i = 0;
        while (i < this.twuPattern.size()) {
            sum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue();
            ++i;
        }
        i = 0;
        while (i < this.twuPattern.size()) {
            double tempPercent = (tempSum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue()) / (sum + 0.0);
            this.percentage.add(tempPercent);
            ++i;
        }
        return this.percentage;
    }

    private int select(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void insert(ChroNode tempChroNode) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempChroNode.chromosome.get(i)) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
            }
        }
    }

    private void addHuiBA(ChroNode tempBAIndividual) {
        ChroNode tmpBAIndividual = new ChroNode();
        tmpBAIndividual.deepcopy(tempBAIndividual);
        if (this.huiBA.size() != 0) {
            int i = 0;
            while (i < this.huiBA.size()) {
                BitSet tmpBitSet = (BitSet)tmpBAIndividual.chromosome.clone();
                tmpBitSet.xor(this.huiBA.get((int)i).chromosome);
                if (tmpBitSet.cardinality() == 0) {
                    return;
                }
                ++i;
            }
        }
        this.huiBA.add(tmpBAIndividual);
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.huiSets.size()) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            if (i != this.huiSets.size() - 1) {
                buffer.append(System.lineSeparator());
            }
            ++i;
        }
        this.writer.write(buffer.toString());
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIM-HC ALGORITHM - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class ChroNode
    implements Comparable {
        BitSet chromosome;
        int fitness;
        double rfitness;
        int rank;

        public ChroNode() {
            this.chromosome = new BitSet();
        }

        public ChroNode(int length) {
            this.chromosome = new BitSet(length);
        }

        public void deepcopy(ChroNode tempChroNode) {
            this.chromosome = (BitSet)tempChroNode.chromosome.clone();
            this.fitness = tempChroNode.fitness;
            this.rfitness = tempChroNode.rfitness;
            this.rank = tempChroNode.rank;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            int m = 0;
            while (m < templist.size()) {
                int p = templist.get(m);
                int i = 0;
                boolean j = false;
                int q = 0;
                int temp = 0;
                int sum = 0;
                while (q < AlgoHUIMHC.this.database.get(p).size() && i < this.chromosome.length()) {
                    if (this.chromosome.get(i)) {
                        if (AlgoHUIMHC.this.database.get((int)p).get((int)q).item == AlgoHUIMHC.this.twuPattern.get(i)) {
                            sum += AlgoHUIMHC.this.database.get((int)p).get((int)q).utility;
                            ++i;
                            ++q;
                            ++temp;
                            continue;
                        }
                        ++q;
                        continue;
                    }
                    ++i;
                }
                if (temp == k) {
                    fitness += sum;
                }
                ++m;
            }
            this.fitness = fitness;
        }

        public int compareTo(Object o) {
            return -(this.fitness - ((ChroNode)o).fitness);
        }
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item() {
            this.TIDS = new BitSet(AlgoHUIMHC.this.database.size());
        }

        public Item(int item) {
            this.TIDS = new BitSet(AlgoHUIMHC.this.database.size());
            this.item = item;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

