/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.HUIM_SPSO;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUIM_SPSO {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 20;
    final int iterations = 10000;
    int transactionCount = 0;
    final double w = 0.9;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    Particle gBest;
    List<Particle> pBest = new ArrayList<Particle>();
    List<Particle> population = new ArrayList<Particle>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<Double> percentage = new ArrayList<Double>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Item> Items;
    List<Particle> huiBA = new ArrayList<Particle>();
    List<Double> percentHUIBA;
    List<VelocityR> V = new ArrayList<VelocityR>();
    List<Double> aveEd = new ArrayList<Double>();
    List<Integer> maxEd = new ArrayList<Integer>();

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        block34: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block32: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                this.mapItemToTWU0 = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            ++this.transactionCount;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                Integer twu0 = this.mapItemToTWU0.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                this.mapItemToTWU0.put(item, twu0);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        ArrayList<Integer> pattern = new ArrayList<Integer>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                pattern.add(pair.item);
                            } else {
                                this.mapItemToTWU0.remove(pair.item);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        int i = 0;
        while (i < this.database.size()) {
            int j = 0;
            while (j < this.Items.size()) {
                int k = 0;
                while (k < this.database.get(i).size()) {
                    if (this.Items.get((int)j).item == this.database.get((int)i).get((int)k).item) {
                        this.Items.get((int)j).TIDS.set(i);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.pBest.add(new Particle(this.twuPattern.size()));
            ++i;
        }
        this.gBest = new Particle(this.twuPattern.size());
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            this.generatePop(minUtility);
            i = 0;
            while (i <= 10000) {
                ArrayList<Integer> distance = new ArrayList<Integer>();
                double temp = 0.0;
                int t = 0;
                int p = 0;
                while (p < 20) {
                    int q = 1;
                    while (q < 20) {
                        distance.add(AlgoHUIM_SPSO.minEditDistance(this.population.get((int)p).X, this.population.get((int)q).X, this.twuPattern));
                        temp += (double)((Integer)distance.get(t)).intValue();
                        ++t;
                        ++q;
                    }
                    ++p;
                }
                Collections.sort(distance);
                this.maxEd.add((Integer)distance.get(t - 1));
                this.aveEd.add(temp / (double)t);
                this.update(minUtility);
                if (this.huiBA.size() != 0) {
                    this.percentHUIBA = this.roulettePercentHUIBA();
                    int num = this.rouletteSelectHUIBA(this.percentHUIBA);
                    this.gBest.copyParticle(this.huiBA.get(num));
                }
                ++i;
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void generatePop(int minUtility) {
        this.percentage = this.roulettePercent();
        int i = 0;
        while (i < 20) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = this.rouletteSelect(this.percentage);
                if (tempParticle.X.get(temp)) continue;
                ++j;
                tempParticle.X.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(tempParticle, transList);
            tempParticle.calculateFitness(k, transList);
            this.population.add(i, tempParticle);
            this.pBest.get(i).copyParticle(tempParticle);
            if (this.population.get((int)i).fitness >= minUtility) {
                this.insert(this.population.get(i));
                this.addHuiBA(this.population.get(i));
            }
            if (i == 0) {
                this.gBest.copyParticle(this.pBest.get(i));
            } else if (this.pBest.get((int)i).fitness > this.gBest.fitness) {
                this.gBest.copyParticle(this.pBest.get(i));
            }
            VelocityR tempV = new VelocityR(this.twuPattern.size());
            tempV.XtoFitness.copyParticle(tempParticle);
            int m = 0;
            while (m < this.twuPattern.size()) {
                if (tempV.XtoFitness.X.get(m)) {
                    tempV.rand.set(m, 0.9 * Math.random());
                }
                ++m;
            }
            this.V.add(i, tempV);
            ++i;
        }
    }

    public static int minEditDistance(BitSet particle1, BitSet particle2, List<Integer> lit) {
        if (particle1.length() == 0 || particle2.length() == 0) {
            return particle1.length() == 0 ? particle2.length() : particle1.length();
        }
        int[][] arr = new int[lit.size() + 1][lit.size() + 1];
        int i = 0;
        while (i <= lit.size()) {
            arr[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= lit.size()) {
            arr[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= lit.size()) {
            int j2 = 1;
            while (j2 <= lit.size()) {
                if (particle1.get(i - 1) == particle2.get(j2 - 1)) {
                    arr[i][j2] = arr[i - 1][j2 - 1];
                } else {
                    int replace = arr[i - 1][j2 - 1] + 1;
                    int insert = arr[i - 1][j2] + 1;
                    int delete = arr[i][j2 - 1] + 1;
                    int min = Math.min(replace, insert);
                    arr[i][j2] = min = Math.min(min, delete);
                }
                ++j2;
            }
            ++i;
        }
        return arr[lit.size()][lit.size()];
    }

    public boolean isRBAIndividual(Particle tempBAIndividual, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        int i = 0;
        while (i < tempBAIndividual.X.length()) {
            if (tempBAIndividual.X.get(i)) {
                templist.add(i);
            }
            ++i;
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.transactionCount);
        BitSet midBitSet = new BitSet(this.transactionCount);
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        int i2 = 1;
        while (i2 < templist.size()) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i2)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
            } else {
                tempBitSet = (BitSet)midBitSet.clone();
                tempBAIndividual.X.clear((Integer)templist.get(i2));
            }
            ++i2;
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        int m = 0;
        while (m < tempBitSet.length()) {
            if (tempBitSet.get(m)) {
                list.add(m);
            }
            ++m;
        }
        return true;
    }

    private void update(int minUtility) {
        Particle tempP = new Particle();
        Particle tempP1 = new Particle();
        Particle tempP3 = new Particle();
        Particle tempP2 = new Particle();
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        double r1 = Math.random();
        double r2 = Math.random();
        int i = 0;
        while (i < 20) {
            int l;
            int changeBit;
            tempP1 = this.difSet(this.pBest.get(i), this.population.get(i));
            int j = 0;
            while (j < this.twuPattern.size()) {
                if (tempP1.X.get(j)) {
                    this.V.get((int)i).XtoFitness.X.set(j);
                    if (r1 > this.V.get((int)i).rand.get(j)) {
                        this.V.get((int)i).rand.set(j, r1);
                    }
                }
                ++j;
            }
            tempP3 = this.difSet(this.gBest, this.population.get(i));
            j = 0;
            while (j < this.twuPattern.size()) {
                if (tempP3.X.get(j)) {
                    this.V.get((int)i).XtoFitness.X.set(j);
                    if (r2 > this.V.get((int)i).rand.get(j)) {
                        this.V.get((int)i).rand.set(j, r2);
                    }
                }
                ++j;
            }
            double r3 = Math.random();
            tempP2.copyParticle(this.population.get(i));
            j = 0;
            while (j < this.twuPattern.size()) {
                if (this.V.get((int)i).rand.get(j) < r3) {
                    this.V.get((int)i).XtoFitness.X.clear(j);
                    this.V.get((int)i).rand.set(j, 0.0);
                }
                if (this.V.get((int)i).XtoFitness.X.get(j)) {
                    list.add(j);
                }
                ++j;
            }
            int num = (int)((double)this.twuPattern.size() * Math.random()) + 1;
            tempP.copyParticle(this.population.get(i));
            tempP.X.or(this.V.get((int)i).XtoFitness.X);
            j = 0;
            while (j < this.twuPattern.size()) {
                if (tempP.X.get(j)) {
                    list1.add(j);
                }
                ++j;
            }
            this.population.get((int)i).X.clear();
            if (num <= list.size()) {
                j = 0;
                while (j < num) {
                    changeBit = (int)((double)list.size() * Math.random());
                    if (this.population.get((int)i).X.get((Integer)list.get(changeBit))) continue;
                    this.population.get((int)i).X.set((Integer)list.get(changeBit));
                    ++j;
                }
            } else if (num <= list1.size()) {
                this.population.get(i).copyParticle(this.V.get((int)i).XtoFitness);
                l = 0;
                while (l < num - list.size()) {
                    changeBit = (int)((double)this.twuPattern.size() * Math.random());
                    if (!tempP2.X.get(changeBit) || this.V.get((int)i).XtoFitness.X.get(changeBit)) continue;
                    this.population.get((int)i).X.set(changeBit);
                    tempP2.X.set(changeBit, false);
                    ++l;
                }
            } else {
                this.population.get(i).copyParticle(tempP);
                l = 0;
                while (l < num - list1.size()) {
                    changeBit = (int)((double)this.twuPattern.size() * Math.random());
                    if (this.population.get((int)i).X.get(changeBit)) continue;
                    this.population.get((int)i).X.set(changeBit);
                    ++l;
                }
            }
            int k = this.population.get((int)i).X.cardinality();
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(this.population.get(i), transList);
            this.population.get(i).calculateFitness(k, transList);
            if (this.population.get((int)i).fitness > this.pBest.get((int)i).fitness) {
                this.pBest.get(i).copyParticle(this.population.get(i));
                if (this.pBest.get((int)i).fitness > this.gBest.fitness) {
                    this.gBest.copyParticle(this.pBest.get(i));
                }
            }
            if (this.population.get((int)i).fitness >= minUtility) {
                this.insert(this.population.get(i));
                this.addHuiBA(this.population.get(i));
            }
            list.clear();
            list1.clear();
            ++i;
        }
    }

    private Particle difSet(Particle temp0, Particle temp1) {
        Particle tempBitSet = new Particle();
        Particle tmpBitSet = new Particle();
        tempBitSet.copyParticle(temp0);
        tmpBitSet.copyParticle(temp0);
        tempBitSet.X.and(temp1.X);
        int i = 0;
        while (i < tempBitSet.X.length()) {
            if (tempBitSet.X.get(i)) {
                tmpBitSet.X.clear(i);
            }
            ++i;
        }
        return tmpBitSet;
    }

    private void addHuiBA(Particle tempBAIndividual) {
        Particle tmpBAIndividual = new Particle();
        tmpBAIndividual.copyParticle(tempBAIndividual);
        if (this.huiBA.size() != 0) {
            int i = 0;
            while (i < this.huiBA.size()) {
                BitSet tmpBitSet = (BitSet)tmpBAIndividual.X.clone();
                tmpBitSet.xor(this.huiBA.get((int)i).X);
                if (tmpBitSet.cardinality() == 0) {
                    return;
                }
                ++i;
            }
        }
        this.huiBA.add(tmpBAIndividual);
    }

    private List<Double> roulettePercentHUIBA() {
        double sum = 0.0;
        double tempsum = 0.0;
        double percent = 0.0;
        ArrayList<Double> percentHUIBA = new ArrayList<Double>();
        int i = 0;
        while (i < this.huiBA.size()) {
            sum += (double)this.huiBA.get((int)i).fitness;
            ++i;
        }
        i = 0;
        while (i < this.huiBA.size()) {
            percent = (tempsum += (double)this.huiBA.get((int)i).fitness) / sum;
            percentHUIBA.add(percent);
            ++i;
        }
        return percentHUIBA;
    }

    private int rouletteSelectHUIBA(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void insert(Particle tempParticle) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.X.get(i)) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
            }
        }
    }

    private List<Double> roulettePercent() {
        double sum = 0.0;
        double tempSum = 0.0;
        int i = 0;
        while (i < this.twuPattern.size()) {
            sum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue();
            ++i;
        }
        i = 0;
        while (i < this.twuPattern.size()) {
            double tempPercent = (tempSum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue()) / (sum + 0.0);
            this.percentage.add(tempPercent);
            ++i;
        }
        return this.percentage;
    }

    private int rouletteSelect(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.huiSets.size()) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            buffer.append(System.lineSeparator());
            ++i;
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIM-SPSO ALGORITHM v.2.48 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item() {
            this.TIDS = new BitSet(AlgoHUIM_SPSO.this.transactionCount);
        }

        public Item(int item) {
            this.TIDS = new BitSet(AlgoHUIM_SPSO.this.transactionCount);
            this.item = item;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class Particle {
        BitSet X;
        int fitness;

        public Particle() {
            this.X = new BitSet(AlgoHUIM_SPSO.this.twuPattern.size());
        }

        public Particle(int length) {
            this.X = new BitSet(length);
        }

        public void copyParticle(Particle particle1) {
            this.X = (BitSet)particle1.X.clone();
            this.fitness = particle1.fitness;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            int m = 0;
            while (m < templist.size()) {
                int p = templist.get(m);
                int i = 0;
                int q = 0;
                int temp = 0;
                int sum = 0;
                while (q < AlgoHUIM_SPSO.this.database.get(p).size() && i < this.X.length()) {
                    if (this.X.get(i)) {
                        if (AlgoHUIM_SPSO.this.database.get((int)p).get((int)q).item == AlgoHUIM_SPSO.this.twuPattern.get(i)) {
                            sum += AlgoHUIM_SPSO.this.database.get((int)p).get((int)q).utility;
                            ++i;
                            ++q;
                            ++temp;
                            continue;
                        }
                        ++q;
                        continue;
                    }
                    ++i;
                }
                if (temp == k) {
                    fitness += sum;
                }
                ++m;
            }
            this.fitness = fitness;
        }
    }

    class VelocityR {
        Particle XtoFitness;
        List<Double> rand = new ArrayList<Double>();

        public VelocityR() {
            this.XtoFitness = new Particle();
        }

        public VelocityR(int length) {
            this.XtoFitness = new Particle();
            int i = 0;
            while (i < length) {
                this.rand.add(i, 0.0);
                ++i;
            }
        }
    }
}

