/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.MSAprioriSrinivas;

import ca.pfv.spmf.algorithms.frequentpatterns.MSAprioriSrinivas.CombinationGenerator;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMSAprioriSrinivas {
    protected int k;
    int[] MIS;
    protected long startTimestamp;
    protected long endTimestamp;
    private int itemsetCount;
    private int LSRelative;
    private List<Integer[]> database = null;
    final Comparator<Integer> itemComparator;
    BufferedWriter writer = null;
    int maxItemsetSize = Integer.MAX_VALUE;

    public AlgoMSAprioriSrinivas() {
        this.itemComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int compare = AlgoMSAprioriSrinivas.this.MIS[o1] - AlgoMSAprioriSrinivas.this.MIS[o2];
                if (compare == 0) {
                    return o1 - o2;
                }
                return compare;
            }
        };
    }

    public void runAlgorithm(String input, String output, double beta, double LS, int hashUpto) throws IOException, Exception {
        Integer item;
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.itemsetCount = 0;
        MemoryLogger.getInstance().reset();
        int maxItemID = -1;
        int transactionCount = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        HashMap[] mapHashCounts = new HashMap[hashUpto + 1];
        int i = 2;
        while (i < mapHashCounts.length) {
            mapHashCounts[i] = new HashMap();
            ++i;
        }
        this.database = new ArrayList<Integer[]>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            Integer[] transaction = new Integer[lineSplited.length];
            int i2 = 0;
            while (i2 < lineSplited.length) {
                Integer item2;
                transaction[i2] = item2 = Integer.valueOf(Integer.parseInt(lineSplited[i2]));
                Integer count = (Integer)mapItemCount.get(item2);
                if (count == null) {
                    mapItemCount.put(item2, 1);
                    if (item2 > maxItemID) {
                        maxItemID = item2;
                    }
                } else {
                    count = count + 1;
                    mapItemCount.put(item2, count);
                }
                ++i2;
            }
            this.computeHashedSupport(transaction, hashUpto, mapHashCounts, maxItemID);
            this.database.add(transaction);
            ++transactionCount;
        }
        reader.close();
        this.MIS = new int[maxItemID + 1];
        this.LSRelative = (int)Math.ceil(LS * (double)transactionCount);
        this.k = 1;
        ArrayList<Integer> M = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            M.add((Integer)entry.getKey());
            this.MIS[((Integer)entry.getKey()).intValue()] = (int)(beta * (double)((Integer)entry.getValue()).intValue());
            if (this.MIS[(Integer)entry.getKey()] < this.LSRelative) {
                this.MIS[((Integer)entry.getKey()).intValue()] = this.LSRelative;
            }
            if ((Integer)entry.getValue() < this.MIS[(Integer)entry.getKey()] || this.maxItemsetSize < 1) continue;
            this.saveItemsetToFile((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        Collections.sort(M, this.itemComparator);
        if (this.itemsetCount == 0) {
            return;
        }
        ArrayList<Integer> F = new ArrayList<Integer>();
        double minMIS = -1.0;
        int i3 = 0;
        while (i3 < M.size()) {
            item = (Integer)M.get(i3);
            if ((Integer)mapItemCount.get(item) >= this.MIS[item]) {
                F.add(item);
                minMIS = this.MIS[item];
                break;
            }
            ++i3;
        }
        ++i3;
        while (i3 < M.size()) {
            item = (Integer)M.get(i3);
            if ((double)((Integer)mapItemCount.get(item)).intValue() >= minMIS) {
                F.add(item);
            }
            ++i3;
        }
        for (Integer[] transaction : this.database) {
            Arrays.sort(transaction, this.itemComparator);
        }
        if (this.maxItemsetSize > 1) {
            List<Itemset> level = null;
            this.k = 2;
            do {
                MemoryLogger.getInstance().checkMemory();
                if (this.k == 2) {
                    level = this.generateCandidate2(F, mapHashCounts[this.k], maxItemID);
                    mapHashCounts[this.k] = null;
                } else if (this.k <= hashUpto && this.k != 2) {
                    level = this.generateCandidateSizeK(level, transactionCount, mapHashCounts[this.k], maxItemID);
                    mapHashCounts[this.k] = null;
                } else {
                    List<Itemset> candidatesK = this.generateCandidateSizeK(level);
                    for (Integer[] transaction : this.database) {
                        block9: for (Itemset candidate : candidatesK) {
                            int pos = 0;
                            Integer[] integerArray = transaction;
                            int n = transaction.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int item3 = integerArray[n2];
                                if (item3 == candidate.get(pos)) {
                                    if (++pos == candidate.size()) {
                                        candidate.increaseTransactionCount();
                                        continue block9;
                                    }
                                } else if (this.itemComparator.compare(item3, candidate.get(pos)) > 0) continue block9;
                                ++n2;
                            }
                        }
                    }
                    level = new ArrayList<Itemset>();
                    for (Itemset candidate : candidatesK) {
                        if (candidate.getAbsoluteSupport() < this.MIS[candidate.get(0)]) continue;
                        level.add(candidate);
                        this.saveItemsetToFile(candidate);
                    }
                }
                ++this.k;
            } while (!level.isEmpty() && this.k <= this.maxItemsetSize);
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
    }

    private List<Itemset> generateCandidate2(List<Integer> frequent1, Map<BitSet, Integer> mapCkCount, int maxItemId) throws IOException {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < frequent1.size()) {
            Integer item1 = frequent1.get(i);
            int j = i + 1;
            while (j < frequent1.size()) {
                Integer item2 = frequent1.get(j);
                BitSet ckhash = new BitSet(maxItemId);
                ckhash.set(item1);
                ckhash.set(item2);
                int support = 0;
                if (mapCkCount.containsKey(ckhash) && (support = mapCkCount.get(ckhash).intValue()) != 0 && support >= this.MIS[item1]) {
                    Itemset candidate = new Itemset(new int[]{item1, item2});
                    candidate.setAbsoluteSupport(support);
                    candidates.add(candidate);
                    this.saveItemsetToFile(candidate);
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < levelK_1.size()) {
            int[] itemset1 = levelK_1.get(i).getItems();
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block9: {
                    int[] itemset2 = levelK_1.get(j).getItems();
                    int k = 0;
                    while (k < itemset1.length) {
                        if (k == itemset1.length - 1) {
                            if (this.itemComparator.compare(itemset1[k], itemset2[k]) > 0) {
                                break block1;
                            }
                        } else if (itemset1[k] != itemset2[k]) {
                            if (this.itemComparator.compare(itemset1[k], itemset2[k]) >= 0) {
                                if (this.itemComparator.compare(itemset1[k], itemset2[k]) > 0) break block1;
                            }
                            break block9;
                        }
                        ++k;
                    }
                    int[] newItemset = new int[itemset1.length + 1];
                    System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                    newItemset[itemset1.length] = itemset2[itemset2.length - 1];
                    if (this.allSubsetsOfSizeK_1AreFrequent(newItemset, levelK_1)) {
                        candidates.add(new Itemset(newItemset));
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(int[] c, List<Itemset> levelK_1) {
        int posRemoved = 0;
        while (posRemoved < c.length) {
            if (posRemoved != 0 || this.MIS[c[0]] == this.MIS[c[1]]) {
                int first = 0;
                int last = levelK_1.size() - 1;
                boolean found = false;
                while (first <= last) {
                    int middle = first + last >>> 1;
                    if (this.sameAs(levelK_1.get(middle), c, posRemoved) < 0) {
                        first = middle + 1;
                        continue;
                    }
                    if (this.sameAs(levelK_1.get(middle), c, posRemoved) > 0) {
                        last = middle - 1;
                        continue;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            ++posRemoved;
        }
        return true;
    }

    private int sameAs(Itemset itemset2, int[] candidate, int posRemoved) {
        int j = 0;
        int i = 0;
        while (i < itemset2.size()) {
            if (j == posRemoved) {
                ++j;
            }
            if (itemset2.get(i) == candidate[j]) {
                ++j;
            } else {
                return this.itemComparator.compare(itemset2.get(i), candidate[j]);
            }
            ++i;
        }
        return 0;
    }

    private void saveItemsetToFile(Itemset itemset2) throws IOException {
        this.writer.write(String.valueOf(itemset2.toString()) + " #SUP: " + itemset2.getAbsoluteSupport());
        this.writer.newLine();
        ++this.itemsetCount;
    }

    private void saveItemsetToFile(Integer item, Integer support) throws IOException {
        this.writer.write(item + " #SUP: " + support);
        this.writer.newLine();
        ++this.itemsetCount;
    }

    public void printStats() {
        System.out.println("=============  MSAPRIORI(Srinivas) - STATS =============");
        System.out.println(" The algorithm stopped at level " + (this.k - 1) + ", because there is no candidate");
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxItemsetSize = length;
    }

    private void computeHashedSupport(Integer[] transaction, int hashUptoSize, Map<BitSet, Integer>[] mapHashCounts, int maxItemId) throws Exception {
        int k = 2;
        while (k < hashUptoSize + 1 && k < transaction.length + 1) {
            Integer[][] CkItemsets = new CombinationGenerator().generateCombinations(transaction, k);
            int i = 0;
            while (i < CkItemsets.length) {
                Integer[] CkItemset = CkItemsets[i];
                BitSet ckhash = new BitSet(maxItemId);
                int j = 0;
                while (j < CkItemset.length) {
                    ckhash.set(CkItemset[j]);
                    ++j;
                }
                Integer ckcount = mapHashCounts[k].get(ckhash);
                if (ckcount == null) {
                    ckcount = 1;
                    mapHashCounts[k].put(ckhash, 1);
                } else {
                    ckcount = ckcount + 1;
                    mapHashCounts[k].put(ckhash, ckcount);
                }
                ++i;
            }
            ++k;
        }
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1, int n, Map<BitSet, Integer> mapCkCount, int maxItemId) throws IOException, Exception {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < levelK_1.size()) {
            int[] itemset1 = levelK_1.get(i).getItems();
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block9: {
                    int[] itemset2 = levelK_1.get(j).getItems();
                    int k = 0;
                    while (k < itemset1.length) {
                        if (k == itemset1.length - 1) {
                            if (this.itemComparator.compare(itemset1[k], itemset2[k]) > 0) {
                                break block1;
                            }
                        } else if (itemset1[k] != itemset2[k]) {
                            if (this.itemComparator.compare(itemset1[k], itemset2[k]) >= 0) break block1;
                            break block9;
                        }
                        ++k;
                    }
                    int[] newItemset = new int[itemset1.length + 1];
                    System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                    newItemset[itemset1.length] = itemset2[itemset2.length - 1];
                    BitSet ckhash = new BitSet(maxItemId);
                    int k2 = 0;
                    while (k2 < newItemset.length) {
                        ckhash.set(newItemset[k2]);
                        ++k2;
                    }
                    int support = 0;
                    if (mapCkCount.containsKey(ckhash) && (support = mapCkCount.get(ckhash).intValue()) != 0 && support >= this.MIS[newItemset[0]] && this.allSubsetsOfSizeK_1AreFrequent(newItemset, levelK_1)) {
                        Itemset candidate = new Itemset(newItemset);
                        candidate.setAbsoluteSupport(support);
                        candidates.add(candidate);
                        this.saveItemsetToFile(candidate);
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }
}

