/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.SFUPMinerUemax;

import ca.pfv.spmf.algorithms.frequentpatterns.SFUPMinerUemax.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.SFUPMinerUemax.Skyline;
import ca.pfv.spmf.algorithms.frequentpatterns.SFUPMinerUemax.SkylineList;
import ca.pfv.spmf.algorithms.frequentpatterns.SFUPMinerUemax.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoSFUPMinerUemax {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int psfupCount = 0;
    int sfupCount = 0;
    int searchCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output) throws IOException {
        int tid;
        ArrayList<UtilityList> listOfUtilityLists;
        block23: {
            String thisLine;
            BufferedReader myInput;
            block21: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfUtilityLists = new ArrayList<UtilityList>();
            HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                UtilityList uList = new UtilityList(item);
                mapItemToUtilityList.put(item, uList);
                listOfUtilityLists.add(uList);
            }
            Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

                @Override
                public int compare(UtilityList o1, UtilityList o2) {
                    return AlgoSFUPMinerUemax.this.compareItems(o1.item, o2.item);
                }
            });
            tid = 0;
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            revisedTransaction.add(pair);
                            remainingUtility += pair.utility;
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoSFUPMinerUemax.this.compareItems(o1.item, o2.item);
                            }
                        });
                        for (Pair pair : revisedTransaction) {
                            UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                            Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                            utilityListOfItem.addElement(element);
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        int[] uEmax = new int[tid + 1];
        SkylineList[] psfupList = new SkylineList[tid + 1];
        ArrayList<Skyline> skylineList = new ArrayList<Skyline>();
        this.SFUPMiner(new int[0], null, listOfUtilityLists, psfupList, skylineList, uEmax);
        this.judgeSkyline(skylineList, psfupList, uEmax);
        this.writeOut(skylineList);
        this.psfupCount = this.getpsfupCount(psfupList);
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void SFUPMiner(int[] prefix, UtilityList pUL, List<UtilityList> ULs, SkylineList[] psfupList, List<Skyline> skylineList, int[] uEmax) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityList X = ULs.get(i);
            ++this.searchCount;
            int temp = X.elements.size();
            if (X.sumIutils == uEmax[temp] && uEmax[temp] != 0) {
                Skyline tempPoint = new Skyline();
                tempPoint.itemSet = this.itemSetString(prefix, X.item);
                tempPoint.frequent = temp;
                tempPoint.utility = X.sumIutils;
                psfupList[temp].add(tempPoint);
            }
            if (X.sumIutils > uEmax[temp]) {
                uEmax[temp] = X.sumIutils;
                if (psfupList[temp] == null) {
                    SkylineList tempList = new SkylineList();
                    Skyline tempPoint = new Skyline();
                    tempPoint.itemSet = this.itemSetString(prefix, X.item);
                    tempPoint.frequent = temp;
                    tempPoint.utility = X.sumIutils;
                    tempList.add(tempPoint);
                    psfupList[temp] = tempList;
                } else {
                    int templength = psfupList[temp].size();
                    if (templength == 1) {
                        psfupList[temp].get((int)0).itemSet = this.itemSetString(prefix, X.item);
                        psfupList[temp].get((int)0).utility = X.sumIutils;
                    } else {
                        int j = templength - 1;
                        while (j > 0) {
                            psfupList[temp].remove(j);
                            --j;
                        }
                        psfupList[temp].get((int)0).itemSet = this.itemSetString(prefix, X.item);
                        psfupList[temp].get((int)0).utility = X.sumIutils;
                    }
                }
            }
            if (X.sumIutils + X.sumRutils >= uEmax[temp] && uEmax[temp] != 0) {
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                int j = i + 1;
                while (j < ULs.size()) {
                    UtilityList Y = ULs.get(j);
                    exULs.add(this.construct(pUL, X, Y));
                    ++j;
                }
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = X.item;
                this.SFUPMiner(newPrefix, X, exULs, psfupList, skylineList, uEmax);
            }
            ++i;
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private String itemSetString(int[] prefix, int item) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefix.length) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        return buffer.toString();
    }

    private void writeOut(List<Skyline> skylineList) throws IOException {
        this.sfupCount = skylineList.size();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.sfupCount) {
            buffer.append(skylineList.get((int)i).itemSet);
            buffer.append(" #SUP:");
            buffer.append(skylineList.get((int)i).frequent);
            buffer.append(" #UTILITY:");
            buffer.append(skylineList.get((int)i).utility);
            buffer.append(System.lineSeparator());
            ++i;
        }
        this.writer.write(buffer.toString());
    }

    private void judgeSkyline(List<Skyline> skylineList, SkylineList[] psfupList, int[] uEmax) {
        int i = 1;
        while (i < psfupList.length) {
            boolean temp = false;
            if (psfupList[i] != null) {
                int j = i + 1;
                while (j < psfupList.length) {
                    if (psfupList[j] == null) {
                        ++j;
                        continue;
                    }
                    if (psfupList[i].get((int)0).utility <= psfupList[j].get((int)0).utility) {
                        temp = true;
                        break;
                    }
                    ++j;
                }
                if (!temp) {
                    int k = 0;
                    while (k < psfupList[i].size()) {
                        skylineList.add(psfupList[i].get(k));
                        ++k;
                    }
                }
            }
            ++i;
        }
    }

    private int getpsfupCount(SkylineList[] psfupList) {
        int i = 1;
        while (i < psfupList.length) {
            if (psfupList[i] != null) {
                this.psfupCount += psfupList[i].size();
            }
            ++i;
        }
        return this.psfupCount;
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  uEmax skyline ALGORITHM v 2.11 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" Skyline itemsets count : " + this.sfupCount);
        System.out.println(" Search itemsets count : " + this.searchCount);
        System.out.println(" Candidate itemsets count : " + this.psfupCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

