/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.apriori_close;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoAprioriClose {
    protected int k;
    protected int totalCandidateCount = 0;
    protected long startTimestamp;
    protected long endTimestamp;
    private int itemsetCount;
    private int databaseSize;
    private int minsupRelative;
    private List<int[]> database = null;
    protected Itemsets patterns = null;
    BufferedWriter writer = null;

    public Itemsets runAlgorithm(double minsup, String input, String output) throws IOException {
        String line;
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.totalCandidateCount = 0;
        MemoryLogger.getInstance().reset();
        this.databaseSize = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        this.database = new ArrayList<int[]>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int[] transaction = new int[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                Integer item = Integer.parseInt(lineSplited[i]);
                transaction[i] = item;
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                } else {
                    count = count + 1;
                    mapItemCount.put(item, count);
                }
                ++i;
            }
            this.database.add(transaction);
            ++this.databaseSize;
        }
        reader.close();
        this.minsupRelative = (int)Math.ceil(minsup * (double)this.databaseSize);
        this.k = 1;
        ArrayList<Integer> frequent1 = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minsupRelative) continue;
            frequent1.add((Integer)entry.getKey());
        }
        Collections.sort(frequent1, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        });
        if (frequent1.size() == 0) {
            if (this.writer != null) {
                this.writer.close();
            }
            return this.patterns;
        }
        this.totalCandidateCount += frequent1.size();
        ArrayList<Itemset> level = null;
        ArrayList<Itemset> previousLevel = null;
        this.k = 2;
        do {
            MemoryLogger.getInstance().checkMemory();
            List<Itemset> candidatesK = this.k == 2 ? this.generateCandidate2(frequent1) : this.generateCandidateSizeK(level);
            this.totalCandidateCount += candidatesK.size();
            for (int[] transaction : this.database) {
                block5: for (Itemset candidate : candidatesK) {
                    int pos = 0;
                    int[] nArray = transaction;
                    int n = transaction.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int item = nArray[n2];
                        if (item == candidate.itemset[pos]) {
                            if (++pos == candidate.itemset.length) {
                                ++candidate.support;
                                continue block5;
                            }
                        } else if (item > candidate.itemset[pos]) continue block5;
                        ++n2;
                    }
                }
            }
            previousLevel = level;
            level = new ArrayList<Itemset>();
            for (Itemset candidate : candidatesK) {
                if (candidate.getAbsoluteSupport() < this.minsupRelative) continue;
                level.add(candidate);
            }
            if (previousLevel == null) {
                this.checkIfItemsetsK_1AreClosed(frequent1, level, mapItemCount);
            } else {
                this.checkIfItemsetsK_1AreClosed(previousLevel, level);
            }
            ++this.k;
        } while (!level.isEmpty());
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    private void checkIfItemsetsK_1AreClosed(Collection<Itemset> levelKm1, List<Itemset> levelK) throws IOException {
        for (Itemset itemset2 : levelKm1) {
            boolean isClosed = true;
            for (Itemset itemsetK : levelK) {
                if (itemsetK.getAbsoluteSupport() != itemset2.getAbsoluteSupport() || !itemsetK.containsAll(itemset2)) continue;
                isClosed = false;
                break;
            }
            if (!isClosed) continue;
            this.saveItemset(itemset2);
        }
    }

    private void checkIfItemsetsK_1AreClosed(List<Integer> levelKm1, List<Itemset> levelK, Map<Integer, Integer> mapItemCount) throws IOException {
        for (Integer itemset2 : levelKm1) {
            boolean isClosed = true;
            int support = mapItemCount.get(itemset2);
            for (Itemset itemsetK : levelK) {
                if (itemsetK.getAbsoluteSupport() != support || !itemsetK.contains(itemset2)) continue;
                isClosed = false;
                break;
            }
            if (!isClosed) continue;
            this.saveItemset(itemset2, support);
        }
    }

    public int getDatabaseSize() {
        return this.databaseSize;
    }

    private List<Itemset> generateCandidate2(List<Integer> frequent1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < frequent1.size()) {
            Integer item1 = frequent1.get(i);
            int j = i + 1;
            while (j < frequent1.size()) {
                Integer item2 = frequent1.get(j);
                candidates.add(new Itemset(new int[]{item1, item2}));
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < levelK_1.size()) {
            int[] itemset1 = levelK_1.get((int)i).itemset;
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block8: {
                    int[] itemset2 = levelK_1.get((int)j).itemset;
                    int k = 0;
                    while (k < itemset1.length) {
                        if (k == itemset1.length - 1) {
                            if (itemset1[k] >= itemset2[k]) {
                                break block1;
                            }
                        } else {
                            if (itemset1[k] >= itemset2[k]) {
                                if (itemset1[k] > itemset2[k]) break block1;
                            }
                            break block8;
                        }
                        ++k;
                    }
                    int[] newItemset = new int[itemset1.length + 1];
                    System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                    newItemset[itemset1.length] = itemset2[itemset2.length - 1];
                    if (this.allSubsetsOfSizeK_1AreFrequent(newItemset, levelK_1)) {
                        candidates.add(new Itemset(newItemset));
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(int[] candidate, List<Itemset> levelK_1) {
        int posRemoved = 0;
        while (posRemoved < candidate.length) {
            int first = 0;
            int last = levelK_1.size() - 1;
            boolean found = false;
            while (first <= last) {
                int middle = first + last >>> 1;
                int comparison = ArraysAlgos.sameAs(levelK_1.get(middle).getItems(), candidate, posRemoved);
                if (comparison < 0) {
                    first = middle + 1;
                    continue;
                }
                if (comparison > 0) {
                    last = middle - 1;
                    continue;
                }
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            ++posRemoved;
        }
        return true;
    }

    void saveItemset(Itemset itemset2) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            this.writer.write(String.valueOf(itemset2.toString()) + " #SUP: " + itemset2.getAbsoluteSupport());
            this.writer.newLine();
        } else {
            this.patterns.addItemset(itemset2, itemset2.size());
        }
    }

    void saveItemset(Integer item, Integer support) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            this.writer.write(item + " #SUP: " + support);
            this.writer.newLine();
        } else {
            Itemset itemset2 = new Itemset(item);
            itemset2.setAbsoluteSupport(support);
            this.patterns.addItemset(itemset2, 1);
        }
    }

    public void printStats() {
        System.out.println("=============  APRIORI - STATS =============");
        System.out.println(" Candidates count : " + this.totalCandidateCount);
        System.out.println(" The algorithm stopped at size " + (this.k - 1) + ", because there is no candidate");
        System.out.println(" Frequent closed itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

