/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.charm;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.charm.AlgoCharm_Bitset;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;

public class AlgoDCharm_Bitset
extends AlgoCharm_Bitset {
    @Override
    public void printStats() {
        System.out.println("=============  dCharm vALTERNATE-Bitset v96r6 - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    @Override
    int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, AlgoCharm_Bitset.BitSetSupport> mapItemTIDS) {
        int maxItemId = 0;
        int i = 0;
        while (i < database.size()) {
            for (Integer item : database.getTransactions().get(i)) {
                AlgoCharm_Bitset.BitSetSupport tids = mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new AlgoCharm_Bitset.BitSetSupport(this);
                    tids.bitset.set(0, database.size(), true);
                    mapItemTIDS.put(item, tids);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                tids.bitset.set(i, false);
                ++tids.support;
            }
            ++i;
        }
        return maxItemId;
    }

    @Override
    AlgoCharm_Bitset.BitSetSupport performAND(AlgoCharm_Bitset.BitSetSupport tidsetI, AlgoCharm_Bitset.BitSetSupport tidsetJ) {
        AlgoCharm_Bitset.BitSetSupport bitsetSupportIJ = new AlgoCharm_Bitset.BitSetSupport(this);
        bitsetSupportIJ.bitset = (BitSet)tidsetJ.bitset.clone();
        bitsetSupportIJ.bitset.andNot(tidsetI.bitset);
        bitsetSupportIJ.support = tidsetI.support - bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    @Override
    AlgoCharm_Bitset.BitSetSupport performANDFirstTime(AlgoCharm_Bitset.BitSetSupport tidsetI, AlgoCharm_Bitset.BitSetSupport tidsetJ, int supportIJ) {
        AlgoCharm_Bitset.BitSetSupport bitsetSupportIJ = new AlgoCharm_Bitset.BitSetSupport(this);
        bitsetSupportIJ.bitset = (BitSet)tidsetJ.bitset.clone();
        bitsetSupportIJ.bitset.andNot(tidsetI.bitset);
        bitsetSupportIJ.support = tidsetI.support - bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    @Override
    void save(int[] prefix, int[] suffix, AlgoCharm_Bitset.BitSetSupport tidset2) throws IOException {
        int[] prefixSuffix = prefix == null ? suffix : ArraysAlgos.concatenate(prefix, suffix);
        Arrays.sort(prefixSuffix);
        Itemset itemset2 = new Itemset(prefixSuffix);
        itemset2.setAbsoluteSupport(tidset2.support);
        int hashcode = this.hash.hashCode(tidset2.bitset);
        if (!this.hash.containsSupersetOf(itemset2, hashcode)) {
            ++this.itemsetCount;
            if (this.writer == null) {
                ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset itemsetWithTidset = new ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset(prefixSuffix, null, tidset2.support);
                this.closedItemsets.addItemset(itemsetWithTidset, itemset2.size());
            } else {
                this.writer.write(String.valueOf(itemset2.toString()) + " #SUP: " + itemset2.support);
                if (this.showTransactionIdentifiers) {
                    BitSet bitset = tidset2.bitset;
                    this.writer.append(" #TID:");
                    int tid = bitset.nextSetBit(0);
                    while (tid != -1) {
                        this.writer.append(" " + tid);
                        tid = bitset.nextSetBit(tid + 1);
                    }
                }
                this.writer.newLine();
            }
            this.hash.put(itemset2, hashcode);
        }
    }
}

