/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.chud;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AlgoCHUD_Phase1 {
    protected int tidCount = 0;
    protected int maxItem = 0;
    protected int itemCount = 0;
    Map<Integer, Set<Integer>> database = null;
    BufferedWriter writer = null;
    private int minUtility;
    protected int closedCount = 0;
    protected long totaltime = 0L;
    protected double maxMemory = 0.0;
    boolean useStrategy1 = true;
    boolean useStrategy2 = true;
    boolean useStrategy3 = true;
    boolean useStrategy4 = true;
    String filePathInput1;

    public void runAlgorithm(int minUtility, String filePathInput1, String filePathInput2, String filePathInput3, String output1) throws IOException {
        String line2;
        String line;
        this.filePathInput1 = filePathInput1;
        this.minUtility = minUtility;
        this.totaltime = System.currentTimeMillis();
        this.maxMemory = 0.0;
        this.database = new HashMap<Integer, Set<Integer>>();
        BufferedReader readerFile3 = new BufferedReader(new FileReader(filePathInput3));
        String line3 = readerFile3.readLine();
        this.tidCount = Integer.parseInt(line3);
        line3 = readerFile3.readLine();
        this.maxItem = Integer.parseInt(line3);
        line3 = readerFile3.readLine();
        this.itemCount = Integer.parseInt(line3);
        readerFile3.close();
        int[] tableTU = new int[this.tidCount];
        BufferedReader readerFile2 = new BufferedReader(new FileReader(filePathInput2));
        while ((line = readerFile2.readLine()) != null) {
            String[] lineSplited = line.split(":");
            tableTU[Integer.parseInt((String)lineSplited[0])] = Integer.parseInt(lineSplited[1]);
        }
        readerFile2.close();
        HashSet<Integer> allItems = new HashSet<Integer>(this.itemCount);
        HashSet<Integer> promisingItems = new HashSet<Integer>(this.itemCount);
        int[] tableMax = new int[this.maxItem + 1];
        int[] tableMin = new int[this.maxItem + 1];
        BufferedReader readerFile1 = new BufferedReader(new FileReader(filePathInput1));
        while ((line2 = readerFile1.readLine()) != null) {
            String[] lineSplited = line2.split(":");
            int item = Integer.parseInt(lineSplited[0]);
            allItems.add(item);
            String[] tidsList = lineSplited[1].split(" ");
            String[] itemTidsUtilities = lineSplited[2].split(" ");
            int itemExactUtility = 0;
            int max = 0;
            int min = Integer.MAX_VALUE;
            String[] stringArray = itemTidsUtilities;
            int n = itemTidsUtilities.length;
            int n2 = 0;
            while (n2 < n) {
                String utilityString = stringArray[n2];
                int utility = Integer.parseInt(utilityString);
                itemExactUtility += utility;
                if (utility > max) {
                    max = utility;
                }
                if (utility < min) {
                    min = utility;
                }
                ++n2;
            }
            tableMax[item] = max;
            tableMin[item] = min;
            int itemEstimatedUtility = 0;
            String[] stringArray2 = tidsList;
            int n3 = tidsList.length;
            n = 0;
            while (n < n3) {
                String tidString = stringArray2[n];
                int tid = Integer.parseInt(tidString);
                itemEstimatedUtility += tableTU[tid];
                ++n;
            }
            if (this.useStrategy1 && itemEstimatedUtility < minUtility) continue;
            HashSet<Integer> tidset2 = new HashSet<Integer>();
            String[] stringArray3 = tidsList;
            int n4 = tidsList.length;
            n3 = 0;
            while (n3 < n4) {
                String tid = stringArray3[n3];
                tidset2.add(Integer.parseInt(tid));
                ++n3;
            }
            this.database.put(item, tidset2);
            promisingItems.add(item);
        }
        readerFile1.close();
        this.recalculateTU(allItems, promisingItems, filePathInput1, tableTU);
        this.writer = new BufferedWriter(new FileWriter(output1));
        ArrayList<Integer> closedset = new ArrayList<Integer>();
        HashSet<Integer> closedsetTIDs = new HashSet<Integer>();
        ArrayList<Integer> preset = new ArrayList<Integer>();
        ArrayList<Integer> postset = new ArrayList<Integer>(promisingItems.size());
        for (Integer item : promisingItems) {
            postset.add(item);
        }
        Collections.sort(postset, new Comparator<Integer>(){

            @Override
            public int compare(Integer item1, Integer item2) {
                int size2;
                int size1 = AlgoCHUD_Phase1.this.database.get(item1).size();
                if (size1 == (size2 = AlgoCHUD_Phase1.this.database.get(item2).size())) {
                    return item1 < item2 ? -1 : 1;
                }
                return size1 - size2;
            }
        });
        this.chud_phase1(true, closedset, closedsetTIDs, postset, preset, tableTU, tableMin, tableMax, 0);
        this.writer.close();
    }

    private void printStatistics() {
        this.totaltime = System.currentTimeMillis() - this.totaltime;
        System.out.println("========== PHASE 1 - STATS ============");
        System.out.println(" Number of transactions: " + this.tidCount);
        System.out.println(" Number of frequent closed itemsets: " + this.closedCount);
        System.out.println(" Total time ~: " + this.totaltime + " ms");
    }

    private void recalculateTU(Set<Integer> itemsK1, Set<Integer> itemsK2, String filePathInput1, int[] tableTU) throws NumberFormatException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(filePathInput1));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited = line.split(":");
            int item = Integer.parseInt(lineSplited[0]);
            if (!itemsK1.contains(item) || itemsK2.contains(item)) continue;
            String[] tidsList = lineSplited[1].split(" ");
            String[] itemTidsUtilities = lineSplited[2].split(" ");
            int i = 0;
            while (i < tidsList.length) {
                int tid = Integer.parseInt(tidsList[i]);
                tableTU[tid] = tableTU[tid] - Integer.parseInt(itemTidsUtilities[i]);
                ++i;
            }
        }
        reader.close();
    }

    private void chud_phase1(boolean firstTime, List<Integer> closedset, Set<Integer> closedsetTIDs, List<Integer> postset, List<Integer> preset, int[] tableTU, int[] tableMin, int[] tableMax, int level) throws IOException {
        for (Integer i : postset) {
            Set<Integer> newgenTIDs = firstTime ? this.database.get(i) : this.intersectTIDset(closedsetTIDs, this.database.get(i));
            int twu = 0;
            for (Integer tid : newgenTIDs) {
                twu += tableTU[tid];
            }
            if (twu >= this.minUtility) {
                ArrayList<Integer> newgen = new ArrayList<Integer>(closedset.size() + 1);
                newgen.addAll(closedset);
                newgen.add(i);
                if (!this.is_dup(newgenTIDs, preset)) {
                    ArrayList<Integer> closedsetNew = new ArrayList<Integer>();
                    closedsetNew.addAll(newgen);
                    HashSet<Integer> closedsetNewTIDs = new HashSet<Integer>();
                    if (firstTime) {
                        closedsetNewTIDs = this.database.get(i);
                    } else {
                        closedsetNewTIDs.addAll(newgenTIDs);
                    }
                    ArrayList<Integer> postsetNew = new ArrayList<Integer>();
                    for (Integer j : postset) {
                        if (!this.smallerAccordingToTotalOrder(i, j)) continue;
                        if (this.database.get(j).containsAll(newgenTIDs)) {
                            closedsetNew.add(j);
                            Set<Integer> jTIDs = this.database.get(j);
                            Iterator<Object> iter = closedsetNewTIDs.iterator();
                            while (iter.hasNext()) {
                                Integer tid = (Integer)iter.next();
                                if (jTIDs.contains(tid)) continue;
                                iter.remove();
                            }
                            continue;
                        }
                        postsetNew.add(j);
                    }
                    ArrayList<Integer> presetNew = new ArrayList<Integer>(preset);
                    int[] tableTUnew = new int[this.tidCount];
                    System.arraycopy(tableTU, 0, tableTUnew, 0, tableTU.length);
                    this.chud_phase1(false, closedsetNew, closedsetNewTIDs, postsetNew, presetNew, tableTUnew, tableMin, tableMax, level + 1);
                    twu = 0;
                    for (Integer tid : newgenTIDs) {
                        twu += tableTU[tid];
                    }
                    if (twu >= this.minUtility) {
                        int maxUtility = 0;
                        for (Integer item : closedsetNew) {
                            maxUtility += tableMax[item];
                        }
                        if (!this.useStrategy4 || maxUtility * closedsetNewTIDs.size() >= this.minUtility) {
                            this.writeOut(closedsetNew, closedsetNewTIDs);
                        }
                    }
                    preset.add(i);
                }
            }
            if (firstTime && this.useStrategy3) {
                String line2;
                BufferedReader readerFile1 = new BufferedReader(new FileReader(this.filePathInput1));
                while ((line2 = readerFile1.readLine()) != null) {
                    String[] lineSplited = line2.split(":");
                    int item = Integer.parseInt(lineSplited[0]);
                    if (item != i) continue;
                    String[] tids = lineSplited[1].split(" ");
                    String[] utilities = lineSplited[2].split(" ");
                    int k = 0;
                    while (k < tids.length) {
                        Integer tidInt = Integer.valueOf(tids[k]);
                        Integer utility = Integer.valueOf(utilities[k]);
                        tableTU[tidInt.intValue()] = tableTU[tidInt] - utility;
                        ++k;
                    }
                    break block6;
                }
                readerFile1.close();
                continue;
            }
            if (!this.useStrategy4) continue;
            for (Integer tid : newgenTIDs) {
                tableTU[tid.intValue()] = tableTU[tid] - tableMin[i];
            }
        }
    }

    private boolean smallerAccordingToTotalOrder(Integer i, Integer j) {
        int size2;
        int size1 = this.database.get(i).size();
        if (size1 == (size2 = this.database.get(j).size())) {
            return i < j;
        }
        return size2 - size1 > 0;
    }

    private void writeOut(List<Integer> closedset, Set<Integer> tids) throws IOException {
        ++this.closedCount;
        StringBuilder buffer = new StringBuilder();
        Iterator<Integer> iterItem = closedset.iterator();
        while (iterItem.hasNext()) {
            buffer.append(iterItem.next());
            if (!iterItem.hasNext()) break;
            buffer.append(' ');
        }
        buffer.append(':');
        Iterator<Integer> iterTID = tids.iterator();
        while (iterTID.hasNext()) {
            buffer.append(iterTID.next());
            if (!iterTID.hasNext()) break;
            buffer.append(' ');
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private boolean is_dup(Set<Integer> newgenTIDs, List<Integer> preset) {
        for (Integer j : preset) {
            if (!this.database.get(j).containsAll(newgenTIDs)) continue;
            return true;
        }
        return false;
    }

    private Set<Integer> intersectTIDset(Set<Integer> tidset1, Set<Integer> tidset2) {
        HashSet<Integer> tidset3 = new HashSet<Integer>();
        if (tidset1.size() > tidset2.size()) {
            for (Integer tid : tidset2) {
                if (!tidset1.contains(tid)) continue;
                tidset3.add(tid);
            }
        } else {
            for (Integer tid : tidset1) {
                if (!tidset2.contains(tid)) continue;
                tidset3.add(tid);
            }
        }
        return tidset3;
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }
}

