/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.cori;

import ca.pfv.spmf.algorithms.frequentpatterns.cori.ItemsetCORI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ItemsetsCORI {
    private final List<List<ItemsetCORI>> levels = new ArrayList<List<ItemsetCORI>>();
    private int itemsetsCount = 0;
    private String name;

    public ItemsetsCORI(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printItemsets(int nbObject) {
        System.out.println(" ------- " + this.name + " -------");
        int patternCount = 0;
        int levelCount = 0;
        for (List<ItemsetCORI> level : this.levels) {
            System.out.println("  L" + levelCount + " ");
            for (ItemsetCORI itemset2 : level) {
                Arrays.sort(itemset2.getItems());
                System.out.print("  pattern " + patternCount + ":  ");
                itemset2.print();
                System.out.print("support :  " + itemset2.getAbsoluteSupport());
                System.out.print(" bond :  " + itemset2.getBond());
                ++patternCount;
                System.out.println("");
            }
            ++levelCount;
        }
        System.out.println(" --------------------------------");
    }

    public void addItemset(ItemsetCORI itemset2, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(itemset2);
        ++this.itemsetsCount;
    }

    public List<List<ItemsetCORI>> getLevels() {
        return this.levels;
    }

    public int getItemsetsCount() {
        return this.itemsetsCount;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void decreaseItemsetCount() {
        --this.itemsetsCount;
    }
}

