/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.dci_closed;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoDCI_Closed {
    int closedCount = 0;
    int tidCount = 0;
    int maxItemId = 1;
    private int minSuppRelative;
    BufferedWriter writer = null;
    Map<Integer, Set<Integer>> database = null;

    public void runAlgorithm(String input, String output, int minsup) throws IOException {
        long startTimestamp = System.currentTimeMillis();
        this.closedCount = 0;
        System.out.println("Running the DCI-Closed algorithm");
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minSuppRelative = minsup;
        this.createVerticalDatabase(input);
        ArrayList<Integer> closedset = new ArrayList<Integer>();
        HashSet<Integer> closedsetTIDs = new HashSet<Integer>();
        ArrayList<Integer> preset = new ArrayList<Integer>();
        ArrayList<Integer> postset = new ArrayList<Integer>(this.maxItemId);
        int i = 1;
        while (i <= this.maxItemId) {
            Set<Integer> tidset2 = this.database.get(i);
            if (tidset2 != null && tidset2.size() >= this.minSuppRelative) {
                postset.add(i);
            }
            ++i;
        }
        Collections.sort(postset, new Comparator<Integer>(){

            @Override
            public int compare(Integer item1, Integer item2) {
                int size2;
                int size1 = AlgoDCI_Closed.this.database.get(item1).size();
                if (size1 == (size2 = AlgoDCI_Closed.this.database.get(item2).size())) {
                    return item1 < item2 ? -1 : 1;
                }
                return size1 - size2;
            }
        });
        this.dci_closed(true, closedset, closedsetTIDs, postset, preset);
        System.out.println("========== DCI_CLOSED - STATS ============");
        System.out.println(" Number of transactions: " + this.tidCount);
        System.out.println(" Number of frequent closed itemsets: " + this.closedCount);
        System.out.println(" Total time ~: " + (System.currentTimeMillis() - startTimestamp) + " ms");
        this.writer.close();
    }

    private void dci_closed(boolean firstTime, List<Integer> closedset, Set<Integer> closedsetTIDs, List<Integer> postset, List<Integer> preset) throws IOException {
        for (Integer i : postset) {
            Set<Integer> newgenTIDs = firstTime ? this.database.get(i) : this.intersectTIDset(closedsetTIDs, this.database.get(i));
            if (newgenTIDs.size() < this.minSuppRelative) continue;
            ArrayList<Integer> newgen = new ArrayList<Integer>(closedset.size() + 1);
            newgen.addAll(closedset);
            newgen.add(i);
            if (this.is_dup(newgenTIDs, preset)) continue;
            ArrayList<Integer> closedsetNew = new ArrayList<Integer>();
            closedsetNew.addAll(newgen);
            Set<Object> closedsetNewTIDs = new HashSet<Integer>();
            if (firstTime) {
                closedsetNewTIDs = this.database.get(i);
            } else {
                closedsetNewTIDs.addAll(newgenTIDs);
            }
            ArrayList<Integer> postsetNew = new ArrayList<Integer>();
            for (Integer j : postset) {
                if (!this.smallerAccordingToTotalOrder(i, j)) continue;
                if (this.database.get(j).containsAll(newgenTIDs)) {
                    closedsetNew.add(j);
                    Set<Integer> jTIDs = this.database.get(j);
                    Iterator<Object> iter = closedsetNewTIDs.iterator();
                    while (iter.hasNext()) {
                        Integer tid = (Integer)iter.next();
                        if (jTIDs.contains(tid)) continue;
                        iter.remove();
                    }
                    continue;
                }
                postsetNew.add(j);
            }
            this.writeOut(closedsetNew, closedsetNewTIDs.size());
            ArrayList<Integer> presetNew = new ArrayList<Integer>(preset);
            this.dci_closed(false, closedsetNew, closedsetNewTIDs, postsetNew, presetNew);
            preset.add(i);
        }
    }

    private boolean smallerAccordingToTotalOrder(Integer i, Integer j) {
        int size2;
        int size1 = this.database.get(i).size();
        if (size1 == (size2 = this.database.get(j).size())) {
            return i < j;
        }
        return size2 - size1 > 0;
    }

    private void writeOut(List<Integer> closedset, int support) throws IOException {
        ++this.closedCount;
        StringBuilder buffer = new StringBuilder();
        Iterator<Integer> iterItem = closedset.iterator();
        while (iterItem.hasNext()) {
            buffer.append(iterItem.next());
            if (!iterItem.hasNext()) break;
            buffer.append(' ');
        }
        buffer.append(" #SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private boolean is_dup(Set<Integer> newgenTIDs, List<Integer> preset) {
        for (Integer j : preset) {
            if (!this.database.get(j).containsAll(newgenTIDs)) continue;
            return true;
        }
        return false;
    }

    private Set<Integer> intersectTIDset(Set<Integer> tidset1, Set<Integer> tidset2) {
        HashSet<Integer> tidset3 = new HashSet<Integer>();
        if (tidset1.size() > tidset2.size()) {
            for (Integer tid : tidset2) {
                if (!tidset1.contains(tid)) continue;
                tidset3.add(tid);
            }
        } else {
            for (Integer tid : tidset1) {
                if (!tidset2.contains(tid)) continue;
                tidset3.add(tid);
            }
        }
        return tidset3;
    }

    private void createVerticalDatabase(String input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.tidCount = 0;
        this.maxItemId = 0;
        this.database = new HashMap<Integer, Set<Integer>>();
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                Set<Integer> tidset2 = this.database.get(item);
                if (tidset2 == null) {
                    tidset2 = new HashSet<Integer>();
                    this.database.put(item, tidset2);
                }
                tidset2.add(this.tidCount);
                if (item > this.maxItemId) {
                    this.maxItemId = item;
                }
                ++n2;
            }
            ++this.tidCount;
        }
        reader.close();
    }
}

