/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.dci_closed_optimized;

import ca.pfv.spmf.algorithms.frequentpatterns.dci_closed_optimized.BitMatrix;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class AlgoDCI_Closed_Optimized {
    int closedCount = 0;
    int tidsCount = 0;
    int maxItemId = 1;
    private int minSuppRelative;
    BufferedWriter writer = null;
    boolean showTransactionIdentifiers = false;

    public void runAlgorithm(String input, String output, int minsup) throws IOException {
        long startTimestamp = System.currentTimeMillis();
        this.closedCount = 0;
        MemoryLogger.getInstance().reset();
        System.out.println("Running the DCI-Closed algorithm");
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minSuppRelative = minsup;
        this.firstScan(input);
        MemoryLogger.getInstance().checkMemory();
        final BitMatrix matrix = new BitMatrix(this.maxItemId, this.tidsCount);
        this.createVerticalDatabase(input, matrix);
        ArrayList<Integer> closedset = new ArrayList<Integer>();
        BitSet closedsetTIDs = null;
        ArrayList<Integer> preset = new ArrayList<Integer>();
        ArrayList<Integer> postset = new ArrayList<Integer>(this.maxItemId);
        int i = 1;
        while (i <= this.maxItemId) {
            if (matrix.getSupportOfItemFirstTime(i) >= this.minSuppRelative) {
                postset.add(i);
            }
            ++i;
        }
        Collections.sort(postset, new Comparator<Integer>(){

            @Override
            public int compare(Integer item1, Integer item2) {
                if (matrix.getSupportOfItem(item1) == matrix.getSupportOfItem(item2)) {
                    return item1 < item2 ? -1 : 1;
                }
                return matrix.getSupportOfItem(item1) - matrix.getSupportOfItem(item2);
            }
        });
        MemoryLogger.getInstance().checkMemory();
        this.dci_closed(true, closedset, closedsetTIDs, postset, preset, matrix, matrix);
        System.out.println("========== DCI_CLOSED - STATS ============");
        System.out.println(" Number of transactions: " + this.tidsCount);
        System.out.println(" Number of frequent closed itemsets: " + this.closedCount);
        System.out.println(" Total time ~: " + (System.currentTimeMillis() - startTimestamp) + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("==========================================");
        this.writer.close();
    }

    public void setShowTransactionIdentifiers(boolean showTransactionIdentifiers) {
        this.showTransactionIdentifiers = showTransactionIdentifiers;
    }

    private void firstScan(String input) throws NumberFormatException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.maxItemId = 0;
        this.tidsCount = 0;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                if (item > this.maxItemId) {
                    this.maxItemId = item;
                }
                ++n2;
            }
            ++this.tidsCount;
        }
        reader.close();
    }

    private void dci_closed(boolean firstTime, List<Integer> closedset, BitSet bitset, List<Integer> postset, List<Integer> preset, BitMatrix matrix, BitMatrix originalMatrix) throws IOException {
        for (Integer i : postset) {
            BitSet newgenTIDs;
            if (firstTime) {
                newgenTIDs = matrix.getBitSetOf(i);
            } else {
                newgenTIDs = (BitSet)bitset.clone();
                newgenTIDs.and(matrix.getBitSetOf(i));
            }
            if (newgenTIDs.cardinality() < this.minSuppRelative) continue;
            ArrayList<Integer> newgen = new ArrayList<Integer>(closedset.size() + 1);
            newgen.addAll(closedset);
            newgen.add(i);
            if (this.isDuplicate(newgenTIDs, preset, matrix)) continue;
            ArrayList<Integer> closedsetNew = new ArrayList<Integer>();
            closedsetNew.addAll(newgen);
            BitSet closedsetNewTIDs = null;
            closedsetNewTIDs = firstTime ? (BitSet)matrix.getBitSetOf(i).clone() : (BitSet)newgenTIDs.clone();
            ArrayList<Integer> postsetNew = new ArrayList<Integer>();
            for (Integer j : postset) {
                if (!this.smallerAccordingToTotalOrder(i, j, originalMatrix)) continue;
                if (this.isAllContainedIn(newgenTIDs, matrix.getBitSetOf(j))) {
                    closedsetNew.add(j);
                    closedsetNewTIDs.and(matrix.getBitSetOf(j));
                    continue;
                }
                postsetNew.add(j);
            }
            int support = closedsetNewTIDs.cardinality();
            this.writeOut(closedsetNew, support, closedsetNewTIDs);
            ArrayList<Integer> presetNew = new ArrayList<Integer>(preset);
            if (firstTime) {
                BitMatrix projectedMatrix = this.projectMatrix(matrix, closedsetNewTIDs, support);
                BitSet replacement = new BitSet(support);
                replacement.set(0, support, true);
                this.dci_closed(false, closedsetNew, replacement, postsetNew, presetNew, projectedMatrix, matrix);
            } else {
                this.dci_closed(false, closedsetNew, closedsetNewTIDs, postsetNew, presetNew, matrix, originalMatrix);
            }
            preset.add(i);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean smallerAccordingToTotalOrder(Integer i, Integer j, BitMatrix matrix) {
        if (matrix.getSupportOfItem(i) == matrix.getSupportOfItem(j)) {
            return i < j;
        }
        return matrix.getSupportOfItem(j) - matrix.getSupportOfItem(i) > 0;
    }

    private void writeOut(List<Integer> closedset, int support, BitSet closedsetNewTIDs) throws IOException {
        ++this.closedCount;
        StringBuilder buffer = new StringBuilder();
        Iterator<Integer> iterItem = closedset.iterator();
        while (iterItem.hasNext()) {
            buffer.append(iterItem.next());
            if (!iterItem.hasNext()) break;
            buffer.append(' ');
        }
        buffer.append(" #SUP: ");
        buffer.append(support);
        if (this.showTransactionIdentifiers) {
            buffer.append(" #TID:");
            BitSet transactionIDs = closedsetNewTIDs;
            int tid = transactionIDs.nextSetBit(0);
            while (tid != -1) {
                buffer.append(" " + tid);
                tid = transactionIDs.nextSetBit(tid + 1);
            }
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private boolean isDuplicate(BitSet newgenTIDs, List<Integer> preset, BitMatrix matrix) {
        for (Integer j : preset) {
            if (!this.isAllContainedIn(newgenTIDs, matrix.getBitSetOf(j))) continue;
            return true;
        }
        return false;
    }

    private BitMatrix projectMatrix(BitMatrix matrix, BitSet bitset, int projectedsize) {
        BitMatrix newMatrix = new BitMatrix(this.maxItemId, projectedsize);
        int newBit = 0;
        int bit = bitset.nextSetBit(0);
        while (bit >= 0) {
            int item = 1;
            while (item <= this.maxItemId) {
                if (matrix.getBitSetOf(item).get(bit)) {
                    newMatrix.addTidForItem(item, newBit);
                }
                ++item;
            }
            ++newBit;
            bit = bitset.nextSetBit(bit + 1);
        }
        return newMatrix;
    }

    private void createVerticalDatabase(String input, BitMatrix matrix) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        int tidCount = 0;
        while ((line = reader.readLine()) != null) {
            String[] stringArray = line.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                matrix.addTidForItem(Integer.parseInt(itemString), tidCount);
                ++n2;
            }
            ++tidCount;
        }
        reader.close();
    }

    private boolean isAllContainedIn(BitSet bs1, BitSet bs2) {
        int i = bs1.nextSetBit(0);
        while (i >= 0) {
            if (!bs2.get(i)) {
                return false;
            }
            i = bs1.nextSetBit(i + 1);
        }
        return true;
    }
}

