/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat;

import ca.pfv.spmf.algorithms.frequentpatterns.eclat.AlgoEclat;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.HashSet;
import java.util.Set;

public class AlgoDEclat
extends AlgoEclat {
    @Override
    public void printStats() {
        System.out.println("=============  dECLAT v0.96r18 - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    @Override
    Set<Integer> performANDFirstTime(Set<Integer> tidsetI, int supportI, Set<Integer> tidsetJ, int supportJ) {
        HashSet<Integer> diffsetIJ = new HashSet<Integer>();
        for (Integer tid : tidsetI) {
            if (tidsetJ.contains(tid)) continue;
            diffsetIJ.add(tid);
        }
        return diffsetIJ;
    }

    @Override
    Set<Integer> performAND(Set<Integer> tidsetI, int supportI, Set<Integer> tidsetJ, int supportJ) {
        HashSet<Integer> diffsetIJ = new HashSet<Integer>();
        for (Integer tid : tidsetJ) {
            if (tidsetI.contains(tid)) continue;
            diffsetIJ.add(tid);
        }
        return diffsetIJ;
    }

    @Override
    int calculateSupport(int lengthOfX, int supportPrefix, Set<Integer> tidsetX) {
        if (lengthOfX == 1) {
            return tidsetX.size();
        }
        return supportPrefix - tidsetX.size();
    }
}

