/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.feacp;

import ca.pfv.spmf.algorithms.frequentpatterns.feacp.Dataset;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.TaxonomyNode;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.TaxonomyTree;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.Transaction;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AlgoFEACP {
    BufferedWriter writer = null;
    private int patternCount;
    int countHUI = 0;
    long startTimestamp;
    long endTimestamp;
    long minUtil;
    final boolean DEBUG = false;
    private float[] utilityBinArraySU;
    private float[] utilityBinArrayLU;
    private int[] temp = new int[500];
    long timeIntersections;
    long timeDatabaseReduction;
    long timeIdentifyPromisingItems;
    long timeSort;
    long timeBinarySearch;
    int[] oldNameToNewNames;
    int[] newNamesToOldNames;
    int newItemCount;
    boolean activateTransactionMerging;
    final int MAXIMUM_SIZE_MERGING = 1000;
    long transactionReadingCount;
    long mergeCount;
    private long candidateCount;
    private boolean activateSubtreeUtilityPruning;
    TaxonomyTree taxonomy;
    public static long timeProject = 0L;

    public void runAlgorithm(int minUtil, String inputPath, String outputPath, String TaxonomyPath, int maximumTransactionCount) throws IOException {
        this.mergeCount = 0L;
        this.transactionReadingCount = 0L;
        this.timeIntersections = 0L;
        this.timeDatabaseReduction = 0L;
        Dataset dataset = new Dataset(inputPath, maximumTransactionCount, TaxonomyPath);
        this.taxonomy = dataset.taxonomy;
        this.startTimestamp = System.currentTimeMillis();
        this.minUtil = minUtil;
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(outputPath));
        this.useUtilityBinArrayToCalculateLocalUtilityFirstTime(dataset);
        ArrayList<Integer> itemsToKeep = new ArrayList<Integer>();
        int j = 1;
        while (j < this.utilityBinArrayLU.length) {
            if (this.utilityBinArrayLU[j] >= (float)minUtil) {
                itemsToKeep.add(j);
            }
            ++j;
        }
        AlgoFEACP.insertionSort(itemsToKeep, this.utilityBinArrayLU, this.taxonomy);
        this.oldNameToNewNames = new int[dataset.getMaxItem() + 1];
        this.newNamesToOldNames = new int[dataset.getMaxItem() + 1];
        int currentName = 1;
        int j2 = 0;
        while (j2 < itemsToKeep.size()) {
            int item = (Integer)itemsToKeep.get(j2);
            this.oldNameToNewNames[item] = currentName;
            this.newNamesToOldNames[currentName] = item;
            itemsToKeep.set(j2, currentName);
            ++currentName;
            ++j2;
        }
        this.newItemCount = itemsToKeep.size();
        this.utilityBinArraySU = new float[this.newItemCount + 1];
        int i = 0;
        while (i < dataset.getTransactions().size()) {
            Transaction transaction = dataset.getTransactions().get(i);
            transaction.removeUnpromisingItems(this.oldNameToNewNames, this.taxonomy);
            ++i;
        }
        long timeStartSorting = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < dataset.getTransactions().size()) {
            Transaction transaction = dataset.getTransactions().get(i2);
            if (transaction.items.length == 0 && transaction.parentsInTransaction.size() == 0) {
                dataset.transactions.remove(transaction);
            }
            ++i2;
        }
        this.timeSort = System.currentTimeMillis() - timeStartSorting;
        this.useUtilityBinArrayToCalculateSubtreeUtilityFirstTime(dataset);
        ArrayList<Integer> itemsToExplore = new ArrayList<Integer>();
        for (Integer item : itemsToKeep) {
            if (!(this.utilityBinArraySU[item] >= (float)minUtil)) continue;
            itemsToExplore.add(item);
        }
        this.backtrackingEFIM(dataset.getTransactions(), itemsToKeep, itemsToExplore, 0);
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public static void insertionSort(List<Integer> items, float[] utilityBinArrayTWU, TaxonomyTree taxonomy) {
        int j = 1;
        while (j < items.size()) {
            Integer itemJ = items.get(j);
            int i = j - 1;
            Integer itemI = items.get(i);
            float comparison = taxonomy.getMapItemToTaxonomyNode().get(itemI).getLevel() - taxonomy.getMapItemToTaxonomyNode().get(itemJ).getLevel();
            if (comparison == 0.0f) {
                comparison = utilityBinArrayTWU[itemI] - utilityBinArrayTWU[itemJ];
            }
            while (comparison > 0.0f) {
                items.set(i + 1, itemI);
                if (--i < 0) break;
                itemI = items.get(i);
                comparison = taxonomy.getMapItemToTaxonomyNode().get(itemI).getLevel() - taxonomy.getMapItemToTaxonomyNode().get(itemJ).getLevel();
                if (comparison != 0.0f) continue;
                comparison = utilityBinArrayTWU[itemI] - utilityBinArrayTWU[itemJ];
            }
            items.set(i + 1, itemJ);
            ++j;
        }
    }

    private void backtrackingEFIM(List<Transaction> transactionsOfP, List<Integer> itemsToKeep, List<Integer> itemsToExplore, int prefixLength) throws IOException {
        int x = 0;
        while (x < itemsToExplore.size()) {
            ++this.candidateCount;
            Integer e = itemsToExplore.get(x);
            ArrayList<Transaction> transactionsPe = new ArrayList<Transaction>();
            float utilityPe = 0.0f;
            long timeFirstIntersection = System.currentTimeMillis();
            if (this.taxonomy.getMapItemToTaxonomyNode().get(this.newNamesToOldNames[e]).getChildren().size() == 0) {
                for (Transaction transaction : transactionsOfP) {
                    ++this.transactionReadingCount;
                    int positionE = -1;
                    int low = 0;
                    int high = transaction.items.length - 1;
                    while (high >= low) {
                        int middle = low + high >>> 1;
                        if (transaction.items[middle] < e) {
                            low = middle + 1;
                            continue;
                        }
                        if (transaction.items[middle] == e) {
                            positionE = middle;
                            break;
                        }
                        high = middle - 1;
                    }
                    if (positionE <= -1) continue;
                    Transaction projectedTransaction = new Transaction(transaction, (int)e, this.newNamesToOldNames, this.taxonomy);
                    utilityPe = (float)((double)utilityPe + projectedTransaction.prefixUtility);
                    transactionsPe.add(projectedTransaction);
                }
            } else {
                for (Transaction transaction : transactionsOfP) {
                    ++this.transactionReadingCount;
                    if (transaction.parentsInTransaction.get(e) == null) continue;
                    Transaction projectedTransaction = new Transaction(transaction, (int)e, this.taxonomy, this.newNamesToOldNames);
                    utilityPe = (float)((double)utilityPe + projectedTransaction.prefixUtility);
                    transactionsPe.add(projectedTransaction);
                }
            }
            this.timeIntersections += System.currentTimeMillis() - timeFirstIntersection;
            this.temp[prefixLength] = this.newNamesToOldNames[e];
            this.useUtilityBinArraysToCalculateUpperBounds(transactionsPe, x, itemsToKeep);
            ArrayList<Integer> newItemsToKeep = new ArrayList<Integer>();
            ArrayList<Integer> newItemsToExplore = new ArrayList<Integer>();
            int k = x + 1;
            while (k < itemsToKeep.size()) {
                Integer itemk = itemsToKeep.get(k);
                if (this.utilityBinArraySU[itemk] >= (float)this.minUtil && itemk > e) {
                    newItemsToExplore.add(itemk);
                    newItemsToKeep.add(itemk);
                } else if (this.utilityBinArrayLU[itemk] >= (float)this.minUtil && itemk > e) {
                    newItemsToKeep.add(itemk);
                }
                ++k;
            }
            if (utilityPe >= (float)this.minUtil) {
                this.output(prefixLength, utilityPe);
            }
            this.backtrackingEFIM(transactionsPe, newItemsToKeep, newItemsToExplore, prefixLength + 1);
            ++x;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void useUtilityBinArrayToCalculateLocalUtilityFirstTime(Dataset dataset) {
        this.utilityBinArrayLU = new float[dataset.getMaxItem() + 1];
        for (Transaction transaction : dataset.getTransactions()) {
            HashSet<Integer> SetParent = new HashSet<Integer>();
            int[] nArray = transaction.getItems();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer item = nArray[n2];
                int n3 = item;
                this.utilityBinArrayLU[n3] = (float)((double)this.utilityBinArrayLU[n3] + transaction.transactionUtility);
                TaxonomyNode itemIParent = this.taxonomy.mapItemToTaxonomyNode.get(item).getParent();
                while (itemIParent.getData() != -1) {
                    int dataOfParent = itemIParent.getData();
                    SetParent.add(dataOfParent);
                    itemIParent = itemIParent.getParent();
                }
                ++n2;
            }
            for (Integer item : SetParent) {
                int n4 = item;
                this.utilityBinArrayLU[n4] = (float)((double)this.utilityBinArrayLU[n4] + transaction.transactionUtility);
            }
        }
    }

    public void useUtilityBinArrayToCalculateSubtreeUtilityFirstTime(Dataset dataset) {
        for (Transaction transaction : dataset.getTransactions()) {
            double sumSU = transaction.transactionUtility;
            int i = 0;
            while (i < transaction.getItems().length) {
                Integer item = transaction.getItems()[i];
                int n = item;
                this.utilityBinArraySU[n] = (float)((double)this.utilityBinArraySU[n] + sumSU);
                sumSU -= transaction.getUtilities()[i];
                ++i;
            }
            for (int itemParent : transaction.parentsInTransaction.keySet()) {
                sumSU = transaction.transactionUtility;
                int i2 = 0;
                while (i2 < transaction.items.length) {
                    Integer item = transaction.getItems()[i2];
                    if (!this.checkParent(this.newNamesToOldNames[itemParent], this.newNamesToOldNames[item]) && itemParent > item) {
                        sumSU -= transaction.getUtilities()[i2];
                    }
                    ++i2;
                }
                int n = itemParent;
                this.utilityBinArraySU[n] = (float)((double)this.utilityBinArraySU[n] + sumSU);
            }
        }
    }

    private void useUtilityBinArraysToCalculateUpperBounds(List<Transaction> transactionsPe, int j, List<Integer> itemsToKeep) {
        long initialTime = System.currentTimeMillis();
        int i = j + 1;
        while (i < itemsToKeep.size()) {
            Integer item = itemsToKeep.get(i);
            this.utilityBinArraySU[item.intValue()] = 0.0f;
            this.utilityBinArrayLU[item.intValue()] = 0.0f;
            ++i;
        }
        for (Transaction transaction : transactionsPe) {
            ++this.transactionReadingCount;
            double sumRemainingUtility = transaction.transactionUtility;
            int i2 = 0;
            while (i2 < transaction.getItems().length) {
                int item;
                int n = item = transaction.getItems()[i2];
                this.utilityBinArraySU[n] = (float)((double)this.utilityBinArraySU[n] + (sumRemainingUtility + transaction.prefixUtility));
                int n2 = item;
                this.utilityBinArrayLU[n2] = (float)((double)this.utilityBinArrayLU[n2] + (transaction.prefixUtility + transaction.transactionUtility));
                sumRemainingUtility -= transaction.getUtilities()[i2];
                ++i2;
            }
            for (Integer itemParent : transaction.parentsInTransaction.keySet()) {
                double sumU = transaction.transactionUtility;
                int i3 = 0;
                while (i3 < transaction.getItems().length) {
                    int item = transaction.getItems()[i3];
                    if (!this.checkParent(this.newNamesToOldNames[itemParent], this.newNamesToOldNames[item]) && itemParent > item) {
                        sumU -= transaction.getUtilities()[i3];
                    }
                    ++i3;
                }
                int n = itemParent;
                this.utilityBinArraySU[n] = (float)((double)this.utilityBinArraySU[n] + (transaction.prefixUtility + sumU));
                int n3 = itemParent;
                this.utilityBinArrayLU[n3] = (float)((double)this.utilityBinArrayLU[n3] + (transaction.prefixUtility + transaction.transactionUtility));
            }
        }
        this.timeDatabaseReduction += System.currentTimeMillis() - initialTime;
    }

    private void output(int tempPosition, float utility) throws IOException {
        ++this.patternCount;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i <= tempPosition) {
            buffer.append(this.temp[i]);
            if (i != tempPosition) {
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("========== FEACP v2.53 - STATS ============");
        System.out.println(" minUtil = " + this.minUtil);
        System.out.println(" High utility itemsets count: " + this.patternCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Transaction merge count ~: " + this.mergeCount);
        System.out.println(" Transaction read count ~: " + this.transactionReadingCount + "/" + timeProject);
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println("=====================================");
    }

    private boolean checkParent(int item1, int item2) {
        int levelOfItem2;
        TaxonomyNode nodeItem1 = this.taxonomy.getMapItemToTaxonomyNode().get(item1);
        TaxonomyNode nodeItem2 = this.taxonomy.getMapItemToTaxonomyNode().get(item2);
        int levelOfItem1 = nodeItem1.getLevel();
        if (levelOfItem1 == (levelOfItem2 = nodeItem2.getLevel())) {
            return false;
        }
        if (levelOfItem1 > levelOfItem2) {
            TaxonomyNode parentItem1 = nodeItem1.getParent();
            while (parentItem1.getLevel() != levelOfItem2) {
                parentItem1 = parentItem1.getParent();
            }
            return parentItem1.getData() == nodeItem2.getData();
        }
        TaxonomyNode parentItem2 = nodeItem2.getParent();
        while (parentItem2.getLevel() != levelOfItem1) {
            parentItem2 = parentItem2.getParent();
        }
        return parentItem2.getData() == nodeItem1.getData();
    }
}

