/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds;

import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds.Batch;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds.Batch_wise_TWU;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds.FMAP_TWU;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.ds.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoFHM_DS {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long startTimestamp2 = 0L;
    public long endTimestamp2 = 0L;
    public long endTimestamp = 0L;
    public long construct_time = 0L;
    public long fhm_time = 0L;
    public int huiCount = 0;
    long total = 0L;
    public long min_supp = 0L;
    public long max_supp = 0L;
    public long avg_supp = 0L;
    public int candidateCount = 0;
    public int construct_calls = 0;
    static Map<Integer, Float> mapItemToTWU = new HashMap<Integer, Float>();
    static Map<Integer, Batch_wise_TWU> mapItemToUpdatedTWU = new HashMap<Integer, Batch_wise_TWU>();
    BufferedWriter writer = null;
    BufferedWriter tempwriter = null;
    int processedBatchCount;
    static Map<Integer, Map<Integer, FMAP_TWU>> mapFMAP = new HashMap<Integer, Map<Integer, FMAP_TWU>>();
    public int k;
    public int win_size;
    public int number_of_transactions_batch;
    public int win_number;
    static float min_top_k_utility_current_window = 0.0f;
    static ArrayList<ArrayList<String>> window = new ArrayList();
    static List<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
    static Map<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
    private static List<Itemset> top_k_hui = new ArrayList<Itemset>();
    boolean debug = false;

    public void runAlgorithm(String transactionFile, int k, int win_size, int number_of_transactions_batch, String resultFile) throws IOException {
        block13: {
            String thisLine;
            this.processedBatchCount = 0;
            this.k = k;
            this.win_size = win_size;
            this.number_of_transactions_batch = number_of_transactions_batch;
            this.startTimestamp = System.currentTimeMillis();
            BufferedReader myInput = null;
            int iterateBatch = 0;
            int iterateWindow = 0;
            int windowCount = 0;
            int batchNumber = 0;
            ArrayList<String> batchTransaction = new ArrayList<String>();
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(transactionFile))));
                    boolean flag = true;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        if (flag) {
                            if (++iterateBatch <= this.number_of_transactions_batch) {
                                batchTransaction.add(thisLine);
                            }
                            if (iterateBatch != this.number_of_transactions_batch) continue;
                            iterateBatch = 0;
                            ++batchNumber;
                            window.add(new ArrayList<String>(batchTransaction));
                            batchTransaction.clear();
                            if (++iterateWindow < this.win_size) continue;
                            this.initial_call_FHM(window, ++windowCount, resultFile);
                            this.writeResultTofile(resultFile, false);
                            window.remove(0);
                            flag = false;
                            continue;
                        }
                        if (++iterateBatch <= this.number_of_transactions_batch) {
                            batchTransaction.add(String.valueOf(thisLine) + "\n");
                        }
                        if (iterateBatch != this.number_of_transactions_batch) continue;
                        iterateBatch = 0;
                        ++windowCount;
                        ++this.win_number;
                        this.update_FHM(batchTransaction, ++batchNumber, resultFile);
                        this.writeResultTofile(resultFile, true);
                        batchTransaction.clear();
                    }
                    if (iterateBatch > 0 && iterateBatch < this.number_of_transactions_batch) {
                        ++windowCount;
                        ++this.win_number;
                        this.update_FHM(batchTransaction, ++batchNumber, resultFile);
                        this.writeResultTofile(resultFile, true);
                        batchTransaction.clear();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    batchTransaction.clear();
                    window.clear();
                    String thisLine2 = "";
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                batchTransaction.clear();
                window.clear();
                String thisLine3 = "";
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
            batchTransaction.clear();
            window.clear();
            thisLine = "";
        }
        this.endTimestamp = System.currentTimeMillis();
    }

    void remove_batch_utility_list(int batch_number) {
        Set<Integer> keyset = mapItemToUtilityList.keySet();
        for (int key : keyset) {
            UtilityList uList = mapItemToUtilityList.get(key);
            int first_batch = Collections.min(uList.batches.keySet());
            uList.sumIutils -= uList.batches.get((Object)Integer.valueOf((int)first_batch)).sum_batch_iutils;
            uList.sumRutils -= uList.batches.get((Object)Integer.valueOf((int)first_batch)).sum_batch_rutils;
            uList.batches.get((Object)Integer.valueOf((int)first_batch)).elements.clear();
            uList.batches.remove(first_batch);
            Batch b = new Batch(batch_number, 0.0f, 0.0f);
            uList.batches.put(batch_number, b);
            mapItemToUtilityList.put(key, uList);
            listOfUtilityLists.add(uList);
        }
    }

    void update_FHM(ArrayList<String> batchTransaction, int batch_number, String resultFile) {
        top_k_hui.clear();
        this.startTimestamp2 = System.currentTimeMillis();
        listOfUtilityLists.clear();
        if (this.debug) {
            System.out.println("Computation on Window: " + this.win_number);
        }
        this.remove_batch_utility_list(batch_number);
        Iterator<Object> iterator = mapItemToUpdatedTWU.keySet().iterator();
        while (iterator.hasNext()) {
            int key = iterator.next();
            mapItemToUpdatedTWU.get(key).updateTWU(this.win_size, this.win_number);
        }
        iterator = mapFMAP.keySet().iterator();
        while (iterator.hasNext()) {
            int item = iterator.next();
            for (int pair_item : mapFMAP.get(item).keySet()) {
                FMAP_TWU map = mapFMAP.get(item).get(pair_item);
                map.updateTWU(this.win_size, this.win_number, batch_number);
            }
        }
        for (String thisLine : batchTransaction) {
            String[] split = thisLine.split(":");
            String[] items = split[0].split(" ");
            int transactionUtility = Integer.parseInt(split[1]);
            int i = 0;
            while (i < items.length) {
                Integer item = Integer.parseInt(items[i]);
                if (mapItemToUpdatedTWU.containsKey(item)) {
                    mapItemToUpdatedTWU.get(item).addTWU(batch_number, transactionUtility);
                } else {
                    mapItemToUpdatedTWU.put(item, new Batch_wise_TWU(this.win_size, this.win_number));
                    mapItemToUpdatedTWU.get(item).addTWU(batch_number, transactionUtility);
                }
                ++i;
            }
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoFHM_DS.this.compareItems(o1.item, o2.item);
            }
        });
        int tid = (batch_number - 1) * this.number_of_transactions_batch;
        for (String thisLine : batchTransaction) {
            Pair pair;
            ++tid;
            float remainingUtility = 0.0f;
            float newTWU = 0.0f;
            String[] split = thisLine.split(":");
            String[] items = split[0].split(" ");
            ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
            int i = 0;
            while (i < items.length) {
                pair = new Pair();
                pair.item = Integer.parseInt(items[i]);
                if (AlgoFHM_DS.mapItemToUpdatedTWU.get((Object)Integer.valueOf((int)pair.item)).sumTWU >= min_top_k_utility_current_window) {
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                    newTWU += pair.utility;
                }
                ++i;
            }
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            Collections.sort(revisedTransaction, new Comparator<Pair>(){

                @Override
                public int compare(Pair o1, Pair o2) {
                    return AlgoFHM_DS.this.compareItems(o1.item, o2.item);
                }
            });
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "false");
            i = 0;
            while (i < revisedTransaction.size()) {
                pair = (Pair)revisedTransaction.get(i);
                remainingUtility -= pair.utility;
                if (mapItemToUtilityList.get(pair.item) == null) {
                    UtilityList uList = new UtilityList(pair.item, this.win_size, this.win_number);
                    listOfUtilityLists.add(uList);
                    mapItemToUtilityList.put(pair.item, uList);
                    Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

                        @Override
                        public int compare(UtilityList o1, UtilityList o2) {
                            return AlgoFHM_DS.this.compareItems(o1.item, o2.item);
                        }
                    });
                }
                UtilityList utilityListOfItem = mapItemToUtilityList.get(pair.item);
                Element element = new Element(tid, pair.utility, remainingUtility);
                utilityListOfItem.addElement(element, this.win_size, this.number_of_transactions_batch);
                Map<Integer, FMAP_TWU> mapFMAPItem = mapFMAP.get(pair.item);
                if (mapFMAPItem == null) {
                    mapFMAPItem = new HashMap<Integer, FMAP_TWU>();
                    mapFMAP.put(pair.item, mapFMAPItem);
                }
                int j = i + 1;
                while (j < revisedTransaction.size()) {
                    Pair pairAfter = (Pair)revisedTransaction.get(j);
                    FMAP_TWU map = mapFMAPItem.get(pairAfter.item);
                    if (map == null) {
                        map = new FMAP_TWU(this.win_size, this.win_number);
                        map.addTWU(batch_number, newTWU);
                        mapFMAPItem.put(pairAfter.item, map);
                    } else {
                        map.addTWU(batch_number, newTWU);
                        mapFMAPItem.put(pairAfter.item, map);
                    }
                    mapFMAP.put(pair.item, mapFMAPItem);
                    ++j;
                }
                ++i;
            }
        }
        top_k_hui.clear();
        for (UtilityList temp : listOfUtilityLists) {
            int[] itemset2 = new int[]{temp.item};
            Itemset i = new Itemset(itemset2, Float.valueOf(temp.sumIutils));
            i.last_batch_utility = temp.batches.containsKey(this.win_number) ? Float.valueOf(temp.sumIutils - temp.batches.get((Object)Collections.min(temp.batches.keySet())).sum_batch_iutils) : Float.valueOf(temp.sumIutils);
            top_k_hui.add(i);
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            Collections.sort(top_k_hui, new Comparator<Itemset>(){

                @Override
                public int compare(Itemset o1, Itemset o2) {
                    return (int)(o2.getExactUtility().floatValue() - o1.getExactUtility().floatValue());
                }
            });
            if (top_k_hui.size() <= this.k) continue;
            int lastindex = top_k_hui.size() - 1;
            Itemset set = top_k_hui.get(lastindex);
            top_k_hui.remove(lastindex);
            if (!(set.getExactUtility().floatValue() > min_top_k_utility_current_window)) continue;
            min_top_k_utility_current_window = set.getExactUtility().floatValue();
        }
        if (top_k_hui.size() >= this.k) {
            min_top_k_utility_current_window = top_k_hui.get(top_k_hui.size() - 1).getExactUtility().floatValue();
        }
        long temp = System.currentTimeMillis();
        try {
            this.fhmUpdateCall(new int[0], null, listOfUtilityLists);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fhm_time = System.currentTimeMillis() - temp;
        if (this.debug) {
            System.out.println("Top k utility: " + top_k_hui.get(top_k_hui.size() - 1).getExactUtility());
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Collections.sort(top_k_hui, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return (int)(o2.last_batch_utility.floatValue() - o1.last_batch_utility.floatValue());
            }
        });
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "false");
        min_top_k_utility_current_window = top_k_hui.size() >= this.k ? AlgoFHM_DS.top_k_hui.get((int)(AlgoFHM_DS.top_k_hui.size() - 1)).last_batch_utility.floatValue() : 0.0f;
        this.endTimestamp2 = System.currentTimeMillis();
    }

    void initial_call_FHM(ArrayList<ArrayList<String>> window, int windowNumber, String resultFile) {
        top_k_hui.clear();
        if (this.debug) {
            System.out.println("Computation on Window: " + windowNumber);
        }
        this.startTimestamp2 = System.currentTimeMillis();
        this.win_number = windowNumber;
        int tid = (windowNumber - 1) * this.number_of_transactions_batch;
        for (ArrayList<String> arrayList : window) {
            for (String thisLine : arrayList) {
                ++tid;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                float transactionUtility = Integer.parseInt(split[1]);
                int i = 0;
                while (i < items.length) {
                    Integer item = Integer.parseInt(items[i]);
                    Float twu = mapItemToTWU.get(item);
                    twu = Float.valueOf(twu == null ? transactionUtility : twu.floatValue() + transactionUtility);
                    mapItemToTWU.put(item, twu);
                    if (mapItemToUpdatedTWU.containsKey(item)) {
                        mapItemToUpdatedTWU.get(item).addTWU(Float.valueOf(transactionUtility), tid, this.win_size, this.number_of_transactions_batch);
                    } else {
                        mapItemToUpdatedTWU.put(item, new Batch_wise_TWU(this.win_size, this.win_number));
                        mapItemToUpdatedTWU.get(item).addTWU(Float.valueOf(transactionUtility), tid, this.win_size, this.number_of_transactions_batch);
                    }
                    ++i;
                }
            }
        }
        for (Integer n : mapItemToTWU.keySet()) {
            if (!(mapItemToTWU.get(n).floatValue() >= min_top_k_utility_current_window)) continue;
            UtilityList uList = new UtilityList(n, this.win_size, windowNumber);
            mapItemToUtilityList.put(n, uList);
            listOfUtilityLists.add(uList);
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoFHM_DS.this.compareItems(o1.item, o2.item);
            }
        });
        tid = (windowNumber - 1) * this.number_of_transactions_batch;
        for (ArrayList arrayList : window) {
            for (String thisLine : arrayList) {
                Pair pair;
                ++tid;
                float remainingUtility = 0.0f;
                float newTWU = 0.0f;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                int i = 0;
                while (i < items.length) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (mapItemToTWU.get(pair.item).floatValue() >= min_top_k_utility_current_window) {
                        revisedTransaction.add(pair);
                        remainingUtility += pair.utility;
                        newTWU += pair.utility;
                    }
                    ++i;
                }
                System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoFHM_DS.this.compareItems(o1.item, o2.item);
                    }
                });
                i = 0;
                while (i < revisedTransaction.size()) {
                    pair = (Pair)revisedTransaction.get(i);
                    UtilityList utilityListOfItem = mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element, this.win_size, this.number_of_transactions_batch);
                    Map<Integer, FMAP_TWU> mapFMAPItem = mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, FMAP_TWU>();
                        mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    int j = i + 1;
                    while (j < revisedTransaction.size()) {
                        Pair pairAfter = (Pair)revisedTransaction.get(j);
                        FMAP_TWU map = mapFMAPItem.get(pairAfter.item);
                        if (map == null) {
                            map = new FMAP_TWU(this.win_size, this.win_number);
                            map.addTWU(Float.valueOf(newTWU), tid, this.win_size, this.number_of_transactions_batch);
                            mapFMAPItem.put(pairAfter.item, map);
                        } else {
                            map.addTWU(Float.valueOf(newTWU), tid, this.win_size, this.number_of_transactions_batch);
                            mapFMAPItem.put(pairAfter.item, map);
                        }
                        mapFMAP.put(pair.item, mapFMAPItem);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        for (UtilityList utilityList : listOfUtilityLists) {
            int[] itemset2 = new int[]{utilityList.item};
            Itemset i = new Itemset(itemset2, Float.valueOf(utilityList.sumIutils));
            i.last_batch_utility = utilityList.batches.containsKey(this.win_number) ? Float.valueOf(utilityList.sumIutils - utilityList.batches.get((Object)Collections.min(utilityList.batches.keySet())).sum_batch_iutils) : Float.valueOf(utilityList.sumIutils);
            top_k_hui.add(i);
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            Collections.sort(top_k_hui, new Comparator<Itemset>(){

                @Override
                public int compare(Itemset o1, Itemset o2) {
                    return (int)(o2.getExactUtility().floatValue() - o1.getExactUtility().floatValue());
                }
            });
            if (top_k_hui.size() <= this.k) continue;
            int lastindex = top_k_hui.size() - 1;
            Itemset set = top_k_hui.get(lastindex);
            top_k_hui.remove(lastindex);
            if (!(set.getExactUtility().floatValue() > min_top_k_utility_current_window)) continue;
            min_top_k_utility_current_window = set.getExactUtility().floatValue();
        }
        if (top_k_hui.size() >= this.k) {
            min_top_k_utility_current_window = top_k_hui.get(top_k_hui.size() - 1).getExactUtility().floatValue();
        }
        long l = System.currentTimeMillis();
        try {
            this.fhmInitialCall(new int[0], null, listOfUtilityLists);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fhm_time = System.currentTimeMillis() - l;
        if (this.debug) {
            System.out.println("Top k utility: " + top_k_hui.get(top_k_hui.size() - 1).getExactUtility());
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Collections.sort(top_k_hui, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return (int)(o2.last_batch_utility.floatValue() - o1.last_batch_utility.floatValue());
            }
        });
        min_top_k_utility_current_window = top_k_hui.size() >= this.k ? AlgoFHM_DS.top_k_hui.get((int)(AlgoFHM_DS.top_k_hui.size() - 1)).last_batch_utility.floatValue() : 0.0f;
        this.endTimestamp2 = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        if (mapItemToTWU.containsKey(item1) && mapItemToTWU.containsKey(item2)) {
            if (mapItemToTWU.get(item1).floatValue() > mapItemToTWU.get(item2).floatValue()) {
                return 1;
            }
            if (mapItemToTWU.get(item1).floatValue() < mapItemToTWU.get(item2).floatValue()) {
                return -1;
            }
            if (item1 > item2) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private void fhmUpdateCall(int[] prefix, UtilityList pUL, List<UtilityList> ULs) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            block10: {
                UtilityList X = ULs.get(i);
                if (X.sumIutils >= min_top_k_utility_current_window && prefix.length > 0 && X.sumIutils != 0.0f) {
                    ++this.huiCount;
                    int[] itemset2 = new int[prefix.length + 1];
                    System.arraycopy(prefix, 0, itemset2, 0, prefix.length);
                    itemset2[prefix.length] = X.item;
                    Itemset item_set = new Itemset(itemset2, Float.valueOf(X.sumIutils));
                    item_set.last_batch_utility = X.batches.containsKey(this.win_number) ? Float.valueOf(X.sumIutils - X.batches.get((Object)Collections.min(X.batches.keySet())).sum_batch_iutils) : Float.valueOf(X.sumIutils);
                    top_k_hui.add(item_set);
                    System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
                    Collections.sort(top_k_hui, new Comparator<Itemset>(){

                        @Override
                        public int compare(Itemset o1, Itemset o2) {
                            return (int)(o2.getExactUtility().floatValue() - o1.getExactUtility().floatValue());
                        }
                    });
                    System.setProperty("java.util.Arrays.useLegacyMergeSort", "false");
                    if (top_k_hui.size() > this.k) {
                        int lastindex = top_k_hui.size() - 1;
                        Itemset set = top_k_hui.get(lastindex);
                        top_k_hui.remove(lastindex);
                        if (set.getExactUtility().floatValue() > min_top_k_utility_current_window) {
                            min_top_k_utility_current_window = set.getExactUtility().floatValue();
                        }
                    }
                    if (top_k_hui.size() >= this.k) {
                        min_top_k_utility_current_window = top_k_hui.get(top_k_hui.size() - 1).getExactUtility().floatValue();
                    }
                }
                if (!(X.sumIutils + X.sumRutils >= min_top_k_utility_current_window) || X.sumIutils + X.sumRutils == 0.0f) break block10;
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                int j = i + 1;
                while (j < ULs.size()) {
                    block12: {
                        UtilityList Y;
                        block11: {
                            Y = ULs.get(j);
                            Map<Integer, FMAP_TWU> mapTWUF = mapFMAP.get(X.item);
                            if (mapTWUF == null) break block11;
                            Float twuF = null;
                            if (mapTWUF.containsKey(Y.item)) {
                                twuF = Float.valueOf(mapTWUF.get((Object)Integer.valueOf((int)Y.item)).sumTWU);
                            }
                            if (twuF != null && twuF.floatValue() < min_top_k_utility_current_window) break block12;
                        }
                        ++this.candidateCount;
                        ++this.total;
                        UtilityList temp = this.construct(pUL, X, Y);
                        exULs.add(temp);
                    }
                    ++j;
                }
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = X.item;
                this.fhmUpdateCall(newPrefix, X, exULs);
            }
            ++i;
        }
    }

    private void fhmInitialCall(int[] prefix, UtilityList pUL, List<UtilityList> ULs) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            block10: {
                UtilityList X = ULs.get(i);
                if (X.sumIutils >= min_top_k_utility_current_window && prefix.length > 0 && X.sumIutils != 0.0f) {
                    ++this.huiCount;
                    int[] itemset2 = new int[prefix.length + 1];
                    System.arraycopy(prefix, 0, itemset2, 0, prefix.length);
                    itemset2[prefix.length] = X.item;
                    Itemset item_set = new Itemset(itemset2, Float.valueOf(X.sumIutils));
                    item_set.last_batch_utility = X.batches.containsKey(this.win_number) ? Float.valueOf(X.sumIutils - X.batches.get((Object)Collections.min(X.batches.keySet())).sum_batch_iutils) : Float.valueOf(X.sumIutils);
                    top_k_hui.add(item_set);
                    System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
                    Collections.sort(top_k_hui, new Comparator<Itemset>(){

                        @Override
                        public int compare(Itemset o1, Itemset o2) {
                            return (int)(o2.getExactUtility().floatValue() - o1.getExactUtility().floatValue());
                        }
                    });
                    System.setProperty("java.util.Arrays.useLegacyMergeSort", "false");
                    if (top_k_hui.size() > this.k) {
                        int lastindex = top_k_hui.size() - 1;
                        Itemset set = top_k_hui.get(lastindex);
                        top_k_hui.remove(lastindex);
                        if (set.getExactUtility().floatValue() > min_top_k_utility_current_window) {
                            min_top_k_utility_current_window = set.getExactUtility().floatValue();
                        }
                    }
                    if (top_k_hui.size() >= this.k) {
                        min_top_k_utility_current_window = top_k_hui.get(top_k_hui.size() - 1).getExactUtility().floatValue();
                    }
                }
                if (!(X.sumIutils + X.sumRutils >= min_top_k_utility_current_window) || X.sumIutils + X.sumRutils == 0.0f) break block10;
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                int j = i + 1;
                while (j < ULs.size()) {
                    block12: {
                        UtilityList Y;
                        block11: {
                            Y = ULs.get(j);
                            Map<Integer, FMAP_TWU> mapTWUF = mapFMAP.get(X.item);
                            if (mapTWUF == null) break block11;
                            Float twuF = null;
                            if (mapTWUF.containsKey(Y.item)) {
                                twuF = Float.valueOf(mapTWUF.get((Object)Integer.valueOf((int)Y.item)).sumTWU);
                            }
                            if (twuF != null && twuF.floatValue() < min_top_k_utility_current_window) break block12;
                        }
                        ++this.candidateCount;
                        ++this.total;
                        UtilityList temp = this.construct(pUL, X, Y);
                        exULs.add(temp);
                    }
                    ++j;
                }
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = X.item;
                this.fhmInitialCall(newPrefix, X, exULs);
            }
            ++i;
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        ++this.construct_calls;
        long temp = System.currentTimeMillis();
        UtilityList pxyUL = new UtilityList(py.item, this.win_size, this.win_number);
        HashSet<Integer> common_batches = new HashSet<Integer>();
        common_batches.addAll(px.batches.keySet());
        common_batches.retainAll(py.batches.keySet());
        Iterator iterator = common_batches.iterator();
        while (iterator.hasNext()) {
            int batch = (Integer)iterator.next();
            for (Element ex : px.batches.get((Object)Integer.valueOf((int)batch)).elements) {
                Element ey = this.findElementWithTID(py.batches.get((Object)Integer.valueOf((int)batch)).elements, ex.tid);
                if (ey == null) continue;
                if (P == null) {
                    Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                    pxyUL.addElement(eXY, this.win_size, this.number_of_transactions_batch);
                    continue;
                }
                Element e = this.findElementWithTID(P.batches.get((Object)Integer.valueOf((int)batch)).elements, ex.tid);
                if (e == null) continue;
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
                pxyUL.addElement(eXY, this.win_size, this.number_of_transactions_batch);
            }
        }
        this.construct_time += System.currentTimeMillis() - temp;
        return pxyUL;
    }

    private Element findElementWithTID(List<Element> elements, int tid) {
        List<Element> list = elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    public void writeResultTofile(String path, boolean appendToFile) throws IOException {
        ++this.processedBatchCount;
        BufferedWriter writer = new BufferedWriter(new FileWriter(path, appendToFile));
        if (appendToFile) {
            writer.newLine();
            writer.write("@NEXT_BATCH");
            writer.newLine();
        }
        Iterator<Itemset> iter = top_k_hui.iterator();
        while (iter.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            Itemset itemset2 = iter.next();
            int i = 0;
            while (i < itemset2.itemset.length) {
                buffer.append(itemset2.itemset[i]);
                buffer.append(' ');
                ++i;
            }
            buffer.append(" #UTIL: ");
            buffer.append(itemset2.utility);
            writer.write(buffer.toString());
            if (!iter.hasNext()) continue;
            writer.newLine();
        }
        writer.close();
    }

    public void printStats() throws IOException {
        System.out.println("=============  FHMDS ALGORITHM v.2.34 Stats =============");
        if (this.debug) {
            System.out.println("k " + this.k + " Transaction count per batch:" + this.number_of_transactions_batch + " win size: " + this.win_size);
        }
        System.out.println(" Processed batch count: " + this.processedBatchCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Candidate count: " + this.total);
        System.out.println("======================================================");
    }

    class Pair {
        int item = 0;
        float utility = 0.0f;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

