/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.tkq;

import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.EnumCombination;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.QItemTrans;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.Qitem;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.tkq.InfoTKQ;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.tkq.Qitemset;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.tkq.UtilityListTKQ;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;

public class AlgoTKQ {
    public String outputFile;
    public String inputDatabase;
    private BufferedWriter writer_hqui = null;
    private Hashtable<Qitem, Integer> mapItemToTwu;
    private Hashtable<Integer, Integer> mapItemToProfit;
    private Hashtable<Integer, Integer> mapTransactionToUtility;
    private Map<Qitem, Map<Qitem, InfoTKQ>> mapFMAP;
    private Map<Qitem, Long> realUtility = new HashMap<Qitem, Long>();
    private Map<String, Long> CUD = new HashMap<String, Long>();
    public long minUtil;
    private int coefficient;
    private EnumCombination combiningMethod;
    private PriorityQueue<Qitemset> kPatterns = new PriorityQueue();
    private int k;
    public long maxMemory = 0L;
    private long startTime;
    private long endTime;
    private int HUQIcount = 0;
    private int countConstruct = 0;
    private Qitem currentQitem;
    private final int BUFFERS_SIZE = 200;
    private Qitem[] itemsetBuffer = null;
    private final boolean DEBUG_MODE = true;

    public void runAlgorithm(int topk, String inputData, String inputProfit, int coef, EnumCombination combinationmethod, String output) throws IOException {
        System.gc();
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.k = topk;
        this.writer_hqui = new BufferedWriter(new FileWriter(output));
        this.coefficient = coef;
        this.combiningMethod = combinationmethod;
        this.itemsetBuffer = new Qitem[200];
        this.mapItemToProfit = new Hashtable();
        this.mapTransactionToUtility = new Hashtable();
        ArrayList<Qitem> qitemNameList = new ArrayList<Qitem>();
        Hashtable<Qitem, UtilityListTKQ> mapItemToUtilityList = new Hashtable<Qitem, UtilityListTKQ>();
        System.out.println("1. Build Initial Q-Utility Lists");
        this.buildInitialQUtilityLists(inputData, inputProfit, qitemNameList, mapItemToUtilityList);
        MemoryLogger.getInstance().checkMemory();
        System.out.println("2. Find Initial High Utility Range Q-items");
        ArrayList<Qitem> candidateList = new ArrayList<Qitem>();
        ArrayList<Qitem> hwQUI = new ArrayList<Qitem>();
        this.findInitialRHUQIs(qitemNameList, mapItemToUtilityList, candidateList, hwQUI);
        MemoryLogger.getInstance().checkMemory();
        System.out.println("3. Recursive Mining Procedure");
        this.miner(this.itemsetBuffer, 0, null, mapItemToUtilityList, qitemNameList, this.writer_hqui, hwQUI);
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        System.out.println("4. Finished mining. The final internal minUtil value is: " + this.minUtil);
        this.writeResultTofile();
        this.writer_hqui.close();
    }

    private void insert(Qitem[] prefix, int length, Qitem item, long utility) {
        Qitemset temp = new Qitemset(prefix, length, item, utility);
        this.kPatterns.add(temp);
        if (this.kPatterns.size() > this.k) {
            if (utility >= this.minUtil) {
                do {
                    this.kPatterns.poll();
                } while (this.kPatterns.size() > this.k);
            }
            this.minUtil = this.kPatterns.peek().utility;
        }
    }

    private void insert(Qitem[] prefix, int length, Qitem item1, Qitem item2, long utility) {
        Qitemset temp = new Qitemset(prefix, length, item1, item2, utility);
        System.out.println("ADDHERE1" + temp);
        this.kPatterns.add(temp);
        if (this.kPatterns.size() > this.k) {
            if (utility >= this.minUtil) {
                do {
                    this.kPatterns.poll();
                } while (this.kPatterns.size() > this.k);
            }
            this.minUtil = this.kPatterns.peek().utility;
        }
    }

    private void insert(Qitem item, long utility) {
        Qitemset temp = new Qitemset(item, utility);
        System.out.println("ADDHERE2" + temp);
        this.kPatterns.add(temp);
        if (this.kPatterns.size() > this.k) {
            if (utility >= this.minUtil) {
                do {
                    this.kPatterns.poll();
                } while (this.kPatterns.size() > this.k);
            }
            this.minUtil = this.kPatterns.peek().utility;
        }
    }

    private void insertCUD(Qitem item1, Qitem item2, long utility) {
        Qitemset temp = new Qitemset(item1, item2, utility);
        System.out.println("ADDHERE3" + temp);
        this.kPatterns.add(temp);
        if (this.kPatterns.size() > this.k) {
            if (utility >= this.minUtil) {
                do {
                    this.kPatterns.poll();
                } while (this.kPatterns.size() > this.k);
            }
            this.minUtil = this.kPatterns.peek().utility;
        }
    }

    private void insertIn(PriorityQueue<Long> ktopls, long value) {
        if (ktopls.size() < this.k) {
            ktopls.add(value);
        } else if (value > ktopls.peek()) {
            ktopls.add(value);
            do {
                ktopls.poll();
            } while (ktopls.size() > this.k);
        }
    }

    private void writeResultTofile() throws IOException {
        for (Qitemset pattern : this.kPatterns) {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < pattern.itemset.size()) {
                buffer.append(pattern.itemset.get(i).toString());
                buffer.append(' ');
                ++i;
            }
            buffer.append("#UTIL: ");
            buffer.append(pattern.utility);
            this.writer_hqui.write(buffer.toString());
            this.writer_hqui.newLine();
        }
        this.writer_hqui.close();
    }

    private void buildInitialQUtilityLists(String inputData, String inputProfit, ArrayList<Qitem> qitemNameList, Hashtable<Qitem, UtilityListTKQ> mapItemToUtilityList) throws IOException {
        String str;
        BufferedReader br_profitTable = new BufferedReader(new FileReader(inputProfit));
        BufferedReader br_inputDatabase = new BufferedReader(new FileReader(inputData));
        while ((str = br_profitTable.readLine()) != null) {
            String[] itemProfit = str.split(", ");
            if (itemProfit.length < 2) continue;
            int profit = Integer.parseInt(itemProfit[1]);
            if (profit == 0) {
                profit = 1;
            }
            int item = Integer.parseInt(itemProfit[0]);
            this.mapItemToProfit.put(item, profit);
        }
        br_profitTable.close();
        this.mapItemToTwu = new Hashtable();
        int tid = 0;
        this.currentQitem = new Qitem(0, 0);
        while ((str = br_inputDatabase.readLine()) != null) {
            ++tid;
            String[] itemInfo = str.split(" ");
            int transactionU = 0;
            int i = 0;
            while (i < itemInfo.length) {
                this.currentQitem.setItem(Integer.valueOf(new String(itemInfo[i].substring(0, itemInfo[i].indexOf(44)))));
                this.currentQitem.setQteMin(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                this.currentQitem.setQteMax(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                transactionU += this.currentQitem.getQteMin() * this.mapItemToProfit.get(this.currentQitem.getItem());
                ++i;
            }
            i = 0;
            while (i < itemInfo.length) {
                this.currentQitem.setItem(Integer.valueOf(new String(itemInfo[i].substring(0, itemInfo[i].indexOf(44)))));
                this.currentQitem.setQteMin(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                this.currentQitem.setQteMax(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                Qitem Q = new Qitem();
                Q.copy(this.currentQitem);
                if (!this.mapItemToTwu.containsKey(Q)) {
                    this.mapItemToTwu.put(Q, transactionU);
                } else {
                    this.mapItemToTwu.put(Q, this.mapItemToTwu.get(Q) + transactionU);
                }
                long utility = Q.getQteMin() * this.mapItemToProfit.get(Q.getItem());
                Long real = this.realUtility.get(Q);
                real = real == null ? utility : utility + real;
                this.realUtility.put(Q, real);
                ++i;
            }
        }
        System.out.println("===============================================");
        System.out.println(" minutil is " + this.minUtil);
        this.raisingThresholdRIU(this.realUtility, this.k);
        System.out.println("after RIU minUtil is " + this.minUtil);
        for (Qitem item : this.mapItemToTwu.keySet()) {
            if (!((double)this.mapItemToTwu.get(item).intValue() >= Math.floor(this.minUtil / (long)this.coefficient))) continue;
            UtilityListTKQ ul = new UtilityListTKQ(item, 0L);
            mapItemToUtilityList.put(item, ul);
            qitemNameList.add(item);
        }
        br_inputDatabase.close();
        MemoryLogger.getInstance().checkMemory();
        br_inputDatabase = new BufferedReader(new FileReader(inputData));
        str = "";
        tid = 0;
        PriorityQueue<Long> ktopls = new PriorityQueue<Long>();
        this.mapFMAP = new HashMap<Qitem, Map<Qitem, InfoTKQ>>();
        while ((str = br_inputDatabase.readLine()) != null) {
            ++tid;
            String[] itemInfo = str.split(" ");
            int remainingUtility = 0;
            Integer newTWU = 0;
            ArrayList<Qitem> revisedTransaction = new ArrayList<Qitem>();
            int i = 0;
            while (i < itemInfo.length) {
                Qitem Q = new Qitem();
                Q.setItem(Integer.valueOf(new String(itemInfo[i].substring(0, itemInfo[i].indexOf(44)))));
                Q.setQteMin(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                Q.setQteMax(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                if (mapItemToUtilityList.containsKey(Q)) {
                    revisedTransaction.add(Q);
                    remainingUtility += Q.getQteMin() * this.mapItemToProfit.get(Q.getItem());
                    newTWU = newTWU + Q.getQteMin() * this.mapItemToProfit.get(Q.getItem());
                }
                this.mapTransactionToUtility.put(tid, newTWU);
                ++i;
            }
            Collections.sort(revisedTransaction, new Comparator<Qitem>(){

                @Override
                public int compare(Qitem o1, Qitem o2) {
                    return AlgoTKQ.this.compareQItems(o1, o2);
                }
            });
            this.insertIn(ktopls, remainingUtility);
            i = 0;
            while (i < revisedTransaction.size()) {
                Qitem current_q = (Qitem)revisedTransaction.get(i);
                UtilityListTKQ utilityListOfItem = mapItemToUtilityList.get(current_q);
                QItemTrans element = new QItemTrans(tid, current_q.getQteMin() * this.mapItemToProfit.get(current_q.getItem()), remainingUtility -= current_q.getQteMin() * this.mapItemToProfit.get(current_q.getItem()));
                utilityListOfItem.addTrans(element);
                utilityListOfItem.addTWU(this.mapTransactionToUtility.get(tid));
                Map<Qitem, InfoTKQ> mapFMAPItem = this.mapFMAP.get(current_q);
                if (mapFMAPItem == null) {
                    mapFMAPItem = new HashMap<Qitem, InfoTKQ>();
                    this.mapFMAP.put(current_q, mapFMAPItem);
                }
                int j = i + 1;
                while (j < revisedTransaction.size()) {
                    Qitem qAfter = (Qitem)revisedTransaction.get(j);
                    InfoTKQ infoItem = mapFMAPItem.get(qAfter);
                    if (infoItem == null) {
                        infoItem = new InfoTKQ();
                    }
                    infoItem.twu += (long)newTWU.intValue();
                    infoItem.utility = (int)((long)infoItem.utility + ((long)current_q.getQteMin() * (long)this.mapItemToProfit.get(current_q.getItem()).intValue() + (long)(qAfter.getQteMin() * this.mapItemToProfit.get(qAfter.getItem()))));
                    mapFMAPItem.put(qAfter, infoItem);
                    ++j;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        System.out.println("===================================================");
        System.out.println(" before CUD kpattertns is ... minutil is " + this.minUtil);
        this.raisingThresholdCUDOptimize2();
        System.out.println("after CUD minUtil is " + this.minUtil);
        Collections.sort(qitemNameList, new Comparator<Qitem>(){

            @Override
            public int compare(Qitem o1, Qitem o2) {
                return AlgoTKQ.this.compareQItems(o1, o2);
            }
        });
        MemoryLogger.getInstance().checkMemory();
    }

    private void raisingThresholdCUDOptimize2() {
        long value = 0L;
        for (Map.Entry<Qitem, Map<Qitem, InfoTKQ>> entry : this.mapFMAP.entrySet()) {
            for (Map.Entry<Qitem, InfoTKQ> entry2 : entry.getValue().entrySet()) {
                value = entry2.getValue().utility;
                if (value < this.minUtil) continue;
                this.CUD.put(entry.getKey() + "_" + entry2.getKey(), Long.valueOf(entry2.getValue().utility));
                this.insertCUD(entry.getKey(), entry2.getKey(), entry2.getValue().utility);
            }
        }
    }

    private void raisingThresholdRIU(Map<Qitem, Long> map, int k) {
        LinkedList<Map.Entry<Qitem, Long>> list = new LinkedList<Map.Entry<Qitem, Long>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Qitem, Long>>(){

            @Override
            public int compare(Map.Entry<Qitem, Long> value1, Map.Entry<Qitem, Long> value2) {
                return value2.getValue().compareTo(value1.getValue());
            }
        });
        if (list.size() >= k && k > 0) {
            this.minUtil = (Long)((Map.Entry)list.get(k - 1)).getValue();
        }
        int i = 0;
        while (i < list.size()) {
            this.insert((Qitem)((Map.Entry)list.get(i)).getKey(), (Long)((Map.Entry)list.get(i)).getValue());
            ++i;
        }
        list = null;
    }

    private void findInitialRHUQIs(ArrayList<Qitem> qitemNameList, Hashtable<Qitem, UtilityListTKQ> mapItemToUtilityList, ArrayList<Qitem> candidateList, ArrayList<Qitem> hwQUI) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < qitemNameList.size()) {
            long utility = mapItemToUtilityList.get(qitemNameList.get(i)).getSumIutils();
            if (utility >= this.minUtil) {
                sb.delete(0, sb.length());
                sb.append(qitemNameList.get(i));
                sb.append(":");
                sb.append(utility);
                sb.append("\r\n");
                hwQUI.add(qitemNameList.get(i));
                ++this.HUQIcount;
            } else {
                if (this.combiningMethod != EnumCombination.COMBINEMAX && (double)utility >= Math.floor(this.minUtil / (long)this.coefficient) || this.combiningMethod == EnumCombination.COMBINEMAX && (double)utility >= Math.floor(this.minUtil / 2L)) {
                    candidateList.add(qitemNameList.get(i));
                }
                if (utility + mapItemToUtilityList.get(qitemNameList.get(i)).getSumRutils() >= this.minUtil) {
                    hwQUI.add(qitemNameList.get(i));
                }
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        this.combineMethod(null, 0, candidateList, qitemNameList, mapItemToUtilityList, hwQUI);
    }

    ArrayList<Qitem> combineMethod(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListTKQ> mapItemToUtilityList, ArrayList<Qitem> hwQUI) {
        if (candidateList.size() > 2) {
            Collections.sort(candidateList, new Comparator<Qitem>(){

                @Override
                public int compare(Qitem o1, Qitem o2) {
                    return AlgoTKQ.this.compareCandidateItems(o1, o2);
                }
            });
            if (EnumCombination.COMBINEALL.equals((Object)this.combiningMethod)) {
                this.combineAll(prefix, prefixLength, candidateList, qItemNameList, mapItemToUtilityList, hwQUI);
            } else if (EnumCombination.COMBINEMIN.equals((Object)this.combiningMethod)) {
                this.combineMin(prefix, prefixLength, candidateList, qItemNameList, mapItemToUtilityList, hwQUI);
            } else if (EnumCombination.COMBINEMAX.equals((Object)this.combiningMethod)) {
                this.combineMax(prefix, prefixLength, candidateList, qItemNameList, mapItemToUtilityList, hwQUI);
            }
            MemoryLogger.getInstance().checkMemory();
        }
        return qItemNameList;
    }

    private void combineAll(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListTKQ> mapItemToUtilityList, ArrayList<Qitem> hwQUI) {
        int s = 1;
        while (s < candidateList.size() - 1) {
            if (candidateList.get(s).getQteMin() == candidateList.get(s - 1).getQteMax() + 1 && candidateList.get(s).getItem() == candidateList.get(s - 1).getItem() || candidateList.get(s).getQteMax() == candidateList.get(s + 1).getQteMin() - 1 && candidateList.get(s).getItem() == candidateList.get(s + 1).getItem()) {
                ++s;
                continue;
            }
            candidateList.remove(s);
        }
        if (candidateList.size() > 2 && (candidateList.get(candidateList.size() - 1).getQteMin() != candidateList.get(candidateList.size() - 2).getQteMax() + 1 || candidateList.get(candidateList.size() - 2).getItem() != candidateList.get(candidateList.size() - 1).getItem())) {
            candidateList.remove(candidateList.size() - 1);
        }
        HashMap<Qitem, UtilityListTKQ> mapRangeToUtilityList = new HashMap<Qitem, UtilityListTKQ>();
        int i = 0;
        while (i < candidateList.size()) {
            int currentItem = candidateList.get(i).getItem();
            mapRangeToUtilityList.clear();
            int count = 1;
            int j = i + 1;
            while (j < candidateList.size()) {
                UtilityListTKQ res;
                int nextItem = candidateList.get(j).getItem();
                if (currentItem != nextItem) break;
                if (j == i + 1) {
                    if (candidateList.get(j).getQteMin() != candidateList.get(i).getQteMax() + 1) break;
                    res = this.constructForCombine(mapItemToUtilityList.get(candidateList.get(i)), mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        ++this.HUQIcount;
                        if (prefixLength == 0) {
                            this.insert(res.getSingleItemsetName(), res.getSumIutils());
                        } else {
                            this.insert(prefix, prefixLength, res.getSingleItemsetName(), res.getSumIutils());
                        }
                        hwQUI.add(res.getSingleItemsetName());
                        mapItemToUtilityList.put(res.getSingleItemsetName(), res);
                        int site = qItemNameList.indexOf(candidateList.get(j));
                        qItemNameList.add(site, res.getSingleItemsetName());
                    }
                } else {
                    if (candidateList.get(j).getQteMin() != candidateList.get(j - 1).getQteMax() + 1) break;
                    Qitem qItem1 = new Qitem(currentItem, candidateList.get(i).getQteMin(), candidateList.get(j - 1).getQteMax());
                    UtilityListTKQ ulQitem1 = (UtilityListTKQ)mapRangeToUtilityList.get(qItem1);
                    res = this.constructForCombine(ulQitem1, mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        ++this.HUQIcount;
                        if (prefixLength == 0) {
                            this.insert(res.getSingleItemsetName(), res.getSumIutils());
                        } else {
                            this.insert(prefix, prefixLength, res.getSingleItemsetName(), res.getSumIutils());
                        }
                        hwQUI.add(res.getSingleItemsetName());
                        mapItemToUtilityList.put(res.getSingleItemsetName(), res);
                        int site = qItemNameList.indexOf(candidateList.get(j));
                        qItemNameList.add(site, res.getSingleItemsetName());
                    }
                }
                ++j;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void combineMin(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListTKQ> mapItemToUtilityList, ArrayList<Qitem> hwQUI) {
        int s = 1;
        while (s < candidateList.size() - 1) {
            if (candidateList.get(s).getQteMin() == candidateList.get(s - 1).getQteMax() + 1 && candidateList.get(s).getItem() == candidateList.get(s - 1).getItem() || candidateList.get(s).getQteMax() == candidateList.get(s + 1).getQteMin() - 1 && candidateList.get(s).getItem() == candidateList.get(s + 1).getItem()) {
                ++s;
                continue;
            }
            candidateList.remove(s);
        }
        if (candidateList.size() > 2 && (candidateList.get(candidateList.size() - 1).getQteMin() != candidateList.get(candidateList.size() - 2).getQteMax() + 1 || candidateList.get(candidateList.size() - 2).getItem() != candidateList.get(candidateList.size() - 1).getItem())) {
            candidateList.remove(candidateList.size() - 1);
        }
        ArrayList<Qitem> temporaryArrayList = new ArrayList<Qitem>();
        HashMap<Qitem, UtilityListTKQ> temporaryMap = new HashMap<Qitem, UtilityListTKQ>();
        HashMap<Qitem, UtilityListTKQ> mapRangeToUtilityList = new HashMap<Qitem, UtilityListTKQ>();
        int i = 0;
        while (i < candidateList.size()) {
            int currentItem = candidateList.get(i).getItem();
            mapRangeToUtilityList.clear();
            int count = 1;
            int j = i + 1;
            while (j < candidateList.size()) {
                UtilityListTKQ res;
                int nextItem = candidateList.get(j).getItem();
                if (currentItem != nextItem) break;
                if (j == i + 1) {
                    if (candidateList.get(j).getQteMin() != candidateList.get(i).getQteMax() + 1) break;
                    res = this.constructForCombine(mapItemToUtilityList.get(candidateList.get(i)), mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        if (temporaryArrayList.isEmpty() || res.getSingleItemsetName().getItem() != ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getItem() || res.getSingleItemsetName().getQteMax() > ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getQteMax()) {
                            temporaryArrayList.add(res.getSingleItemsetName());
                            temporaryMap.put(res.getSingleItemsetName(), res);
                            break;
                        }
                        temporaryMap.remove(temporaryArrayList.get(temporaryArrayList.size() - 1));
                        temporaryArrayList.remove(temporaryArrayList.size() - 1);
                        temporaryArrayList.add(res.getSingleItemsetName());
                        temporaryMap.put(res.getSingleItemsetName(), res);
                        break;
                    }
                } else {
                    if (candidateList.get(j).getQteMin() != candidateList.get(j - 1).getQteMax() + 1) break;
                    Qitem qItem1 = new Qitem(currentItem, candidateList.get(i).getQteMin(), candidateList.get(j - 1).getQteMax());
                    UtilityListTKQ ulQitem1 = (UtilityListTKQ)mapRangeToUtilityList.get(qItem1);
                    res = this.constructForCombine(ulQitem1, mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        if (temporaryArrayList.isEmpty() || res.getSingleItemsetName().getItem() != ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getItem() || res.getSingleItemsetName().getQteMax() > ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getQteMax()) {
                            temporaryArrayList.add(res.getSingleItemsetName());
                            temporaryMap.put(res.getSingleItemsetName(), res);
                            break;
                        }
                        temporaryMap.remove(temporaryArrayList.get(temporaryArrayList.size() - 1));
                        temporaryArrayList.remove(temporaryArrayList.size() - 1);
                        temporaryArrayList.add(res.getSingleItemsetName());
                        temporaryMap.put(res.getSingleItemsetName(), res);
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < temporaryArrayList.size()) {
            Qitem currentQitem = (Qitem)temporaryArrayList.get(k);
            mapItemToUtilityList.put(currentQitem, (UtilityListTKQ)temporaryMap.get(currentQitem));
            this.insert(prefix, prefixLength, currentQitem, ((UtilityListTKQ)temporaryMap.get(currentQitem)).getSumIutils());
            ++this.HUQIcount;
            hwQUI.add(currentQitem);
            Qitem q = new Qitem(currentQitem.getItem(), currentQitem.getQteMax());
            int site = qItemNameList.indexOf(q);
            qItemNameList.add(site, currentQitem);
            ++k;
        }
        temporaryArrayList.clear();
        temporaryMap.clear();
        MemoryLogger.getInstance().checkMemory();
    }

    private void combineMax(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListTKQ> mapItemToUtilityList, ArrayList<Qitem> hwQUI) {
        int s = 1;
        while (s < candidateList.size() - 1) {
            if (candidateList.get(s).getQteMin() == candidateList.get(s - 1).getQteMax() + 1 && candidateList.get(s).getItem() == candidateList.get(s - 1).getItem() || candidateList.get(s).getQteMax() == candidateList.get(s + 1).getQteMin() - 1 && candidateList.get(s).getItem() == candidateList.get(s + 1).getItem()) {
                ++s;
                continue;
            }
            candidateList.remove(s);
        }
        if (candidateList.size() > 2 && (candidateList.get(candidateList.size() - 1).getQteMin() != candidateList.get(candidateList.size() - 2).getQteMax() + 1 || candidateList.get(candidateList.size() - 2).getItem() != candidateList.get(candidateList.size() - 1).getItem())) {
            candidateList.remove(candidateList.size() - 1);
        }
        ArrayList<Qitem> temporaryArrayList = new ArrayList<Qitem>();
        HashMap<Qitem, UtilityListTKQ> temporaryMap = new HashMap<Qitem, UtilityListTKQ>();
        HashMap<Qitem, UtilityListTKQ> mapRangeToUtilityList = new HashMap<Qitem, UtilityListTKQ>();
        int i = 0;
        while (i < candidateList.size()) {
            UtilityListTKQ res = new UtilityListTKQ();
            int currentItem = candidateList.get(i).getItem();
            mapRangeToUtilityList.clear();
            int count = 1;
            int j = i + 1;
            while (j < candidateList.size()) {
                int nextItem = candidateList.get(j).getItem();
                if (currentItem != nextItem) break;
                if (j == i + 1) {
                    if (candidateList.get(j).getQteMin() != candidateList.get(i).getQteMax() + 1) break;
                    res = this.constructForCombine(mapItemToUtilityList.get(candidateList.get(i)), mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient - 1) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                } else {
                    if (candidateList.get(j).getQteMin() != candidateList.get(j - 1).getQteMax() + 1) break;
                    Qitem qItem1 = new Qitem(currentItem, candidateList.get(i).getQteMin(), candidateList.get(j - 1).getQteMax());
                    UtilityListTKQ ulQitem1 = (UtilityListTKQ)mapRangeToUtilityList.get(qItem1);
                    res = this.constructForCombine(ulQitem1, mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count >= this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                }
                ++j;
            }
            if (res.getSumIutils() > this.minUtil && (temporaryMap.isEmpty() || res.getSingleItemsetName().getItem() != ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getItem() || res.getSingleItemsetName().getQteMax() > ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getQteMax())) {
                temporaryMap.put(res.getSingleItemsetName(), res);
                temporaryArrayList.add(res.getSingleItemsetName());
            }
            ++i;
        }
        int k = 0;
        while (k < temporaryArrayList.size()) {
            Qitem currentQitem = (Qitem)temporaryArrayList.get(k);
            mapItemToUtilityList.put(currentQitem, (UtilityListTKQ)temporaryMap.get(currentQitem));
            this.insert(prefix, prefixLength, currentQitem, ((UtilityListTKQ)temporaryMap.get(currentQitem)).getSumIutils());
            ++this.HUQIcount;
            hwQUI.add(currentQitem);
            Qitem q = new Qitem(currentQitem.getItem(), currentQitem.getQteMax());
            int site = qItemNameList.indexOf(q);
            qItemNameList.add(site, currentQitem);
            ++k;
        }
        temporaryArrayList.clear();
        temporaryMap.clear();
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityListTKQ constructForCombine(UtilityListTKQ ulQitem1, UtilityListTKQ ulQitem2) {
        UtilityListTKQ result = new UtilityListTKQ(new Qitem(ulQitem1.getSingleItemsetName().getItem(), ulQitem1.getSingleItemsetName().getQteMin(), ulQitem2.getSingleItemsetName().getQteMax()));
        ArrayList<QItemTrans> temp1 = ulQitem1.getQItemTrans();
        ArrayList<QItemTrans> temp2 = ulQitem2.getQItemTrans();
        ArrayList<QItemTrans> mainlist = new ArrayList<QItemTrans>();
        result.setSumIutils(ulQitem1.getSumIutils() + ulQitem2.getSumIutils());
        result.setSumRutils(ulQitem1.getSumRutils() + ulQitem2.getSumRutils());
        result.setTwu(ulQitem1.getTwu() + ulQitem2.getTwu());
        int i = 0;
        int j = 0;
        while (i < temp1.size() && j < temp2.size()) {
            int t2;
            int t1 = temp1.get(i).getTid();
            if (t1 > (t2 = temp2.get(j).getTid())) {
                mainlist.add(temp2.get(j));
                ++j;
                continue;
            }
            mainlist.add(temp1.get(i));
            ++i;
        }
        if (i == temp1.size()) {
            while (j < temp2.size()) {
                mainlist.add(temp2.get(j++));
            }
        } else if (j == temp2.size()) {
            while (i < temp1.size()) {
                mainlist.add(temp1.get(i++));
            }
        }
        result.setQItemTrans(mainlist);
        MemoryLogger.getInstance().checkMemory();
        return result;
    }

    private UtilityListTKQ constructForJoin(UtilityListTKQ ul1, UtilityListTKQ ul2, UtilityListTKQ ul0) {
        if (ul1.getSingleItemsetName().getItem() == ul2.getSingleItemsetName().getItem()) {
            return null;
        }
        ArrayList<QItemTrans> qT1 = ul1.getQItemTrans();
        ArrayList<QItemTrans> qT2 = ul2.getQItemTrans();
        UtilityListTKQ res = new UtilityListTKQ(ul2.getItemsetName());
        if (ul0 == null) {
            int i = 0;
            int j = 0;
            while (i < qT1.size() && j < qT2.size()) {
                int tid2;
                int tid1 = qT1.get(i).getTid();
                if (tid1 == (tid2 = qT2.get(j).getTid())) {
                    int eu1 = qT1.get(i).getEu();
                    int eu2 = qT2.get(j).getEu();
                    if (qT1.get(i).getRu() >= qT2.get(j).getRu()) {
                        QItemTrans temp = new QItemTrans(tid1, eu1 + eu2, qT2.get(j).getRu());
                        res.addTrans(temp, this.mapTransactionToUtility.get(tid1).intValue());
                    }
                    ++i;
                    ++j;
                    continue;
                }
                if (tid1 > tid2) {
                    ++j;
                    continue;
                }
                ++i;
            }
        } else {
            ArrayList<QItemTrans> preQT = ul0.getQItemTrans();
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < qT1.size() && j < qT2.size()) {
                int tid2;
                int tid1 = qT1.get(i).getTid();
                if (tid1 == (tid2 = qT2.get(j).getTid())) {
                    int eu1 = qT1.get(i).getEu();
                    int eu2 = qT2.get(j).getEu();
                    while (preQT.get(k).getTid() != tid1) {
                        ++k;
                    }
                    int preEU = preQT.get(k).getEu();
                    if (qT1.get(i).getRu() >= qT2.get(j).getRu()) {
                        QItemTrans temp = new QItemTrans(tid1, eu1 + eu2 - preEU, qT2.get(j).getRu());
                        res.addTrans(temp, this.mapTransactionToUtility.get(tid1).intValue());
                    }
                    ++i;
                    ++j;
                    continue;
                }
                if (tid1 > tid2) {
                    ++j;
                    continue;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        if (!res.getQItemTrans().isEmpty()) {
            return res;
        }
        return null;
    }

    private void miner(Qitem[] prefix, int prefixLength, UtilityListTKQ prefixUL, Hashtable<Qitem, UtilityListTKQ> ULs, ArrayList<Qitem> qItemNameList, BufferedWriter br_writer_hqui, ArrayList<Qitem> hwQUI) throws IOException {
        int[] t2 = new int[this.coefficient];
        ArrayList<Qitem> nextNameList = new ArrayList<Qitem>();
        int i = 0;
        while (i < qItemNameList.size()) {
            block17: {
                nextNameList.clear();
                ArrayList<Qitem> nextHWQUI = new ArrayList<Qitem>();
                ArrayList<Qitem> candidateList = new ArrayList<Qitem>();
                Hashtable<Qitem, UtilityListTKQ> nextHUL = new Hashtable<Qitem, UtilityListTKQ>();
                Hashtable<Qitem, UtilityListTKQ> candidateHUL = new Hashtable<Qitem, UtilityListTKQ>();
                if (!hwQUI.contains(qItemNameList.get(i))) break block17;
                if (qItemNameList.get(i).isRange()) {
                    int ii = qItemNameList.get(i).getQteMin();
                    while (ii <= qItemNameList.get(i).getQteMax()) {
                        t2[ii - qItemNameList.get((int)i).getQteMin()] = qItemNameList.indexOf(new Qitem(qItemNameList.get(i).getItem(), ii));
                        ++ii;
                    }
                }
                int j = i + 1;
                while (j < qItemNameList.size()) {
                    block18: {
                        UtilityListTKQ afterUL;
                        block20: {
                            block19: {
                                if (qItemNameList.get(j).isRange() || qItemNameList.get(i).isRange() && j == i + 1) break block18;
                                afterUL = null;
                                Map<Qitem, InfoTKQ> mapTWUF = this.mapFMAP.get(qItemNameList.get(i));
                                if (mapTWUF == null) break block19;
                                InfoTKQ twuF = mapTWUF.get(qItemNameList.get(j));
                                if (twuF == null || (double)twuF.twu < Math.floor(this.minUtil / (long)this.coefficient)) break block18;
                                afterUL = this.constructForJoin(ULs.get(qItemNameList.get(i)), ULs.get(qItemNameList.get(j)), prefixUL);
                                ++this.countConstruct;
                                if (afterUL != null && !((double)afterUL.getTwu() < Math.floor(this.minUtil / (long)this.coefficient))) break block20;
                                break block18;
                            }
                            long sumtwu = 0L;
                            long sum = 0L;
                            int ii = qItemNameList.get(i).getQteMin();
                            while (ii <= qItemNameList.get(i).getQteMax()) {
                                if (this.mapFMAP.get(qItemNameList.get(Math.min(t2[ii - qItemNameList.get(i).getQteMin()], j))).get(qItemNameList.get(Math.max(t2[ii - qItemNameList.get(i).getQteMin()], j))) != null) {
                                    sum = this.mapFMAP.get((Object)qItemNameList.get((int)Math.min((int)t2[ii - qItemNameList.get((int)i).getQteMin()], (int)j))).get((Object)qItemNameList.get((int)Math.max((int)t2[ii - qItemNameList.get((int)i).getQteMin()], (int)j))).twu;
                                    sumtwu += sum;
                                }
                                ++ii;
                            }
                            if (sumtwu == 0L || (double)sumtwu < Math.floor(this.minUtil / (long)this.coefficient)) break block18;
                            afterUL = this.constructForJoin(ULs.get(qItemNameList.get(i)), ULs.get(qItemNameList.get(j)), prefixUL);
                            ++this.countConstruct;
                            if (afterUL == null || (double)afterUL.getTwu() < Math.floor(this.minUtil / (long)this.coefficient)) break block18;
                        }
                        if (afterUL != null && (double)afterUL.getTwu() >= Math.floor(this.minUtil / (long)this.coefficient)) {
                            nextNameList.add(afterUL.getSingleItemsetName());
                            nextHUL.put(afterUL.getSingleItemsetName(), afterUL);
                            if (afterUL.getSumIutils() >= this.minUtil) {
                                this.insert(prefix, prefixLength, qItemNameList.get(i), qItemNameList.get(j), afterUL.getSumIutils());
                                ++this.HUQIcount;
                                nextHWQUI.add(afterUL.getSingleItemsetName());
                            } else {
                                if (this.combiningMethod != EnumCombination.COMBINEMAX && (double)afterUL.getSumIutils() >= Math.floor(this.minUtil / (long)this.coefficient) || this.combiningMethod == EnumCombination.COMBINEMAX && (double)afterUL.getSumIutils() >= Math.floor(this.minUtil / 2L)) {
                                    candidateList.add(afterUL.getSingleItemsetName());
                                    candidateHUL.put(afterUL.getSingleItemsetName(), afterUL);
                                }
                                if (afterUL.getSumIutils() + afterUL.getSumRutils() >= this.minUtil) {
                                    nextHWQUI.add(afterUL.getSingleItemsetName());
                                }
                            }
                        }
                    }
                    ++j;
                }
                if (candidateList.size() > 0) {
                    nextNameList = this.combineMethod(prefix, prefixLength, candidateList, nextNameList, nextHUL, nextHWQUI);
                    candidateHUL.clear();
                    candidateList.clear();
                }
                MemoryLogger.getInstance().checkMemory();
                if (nextNameList.size() >= 1) {
                    this.itemsetBuffer[prefixLength] = qItemNameList.get(i);
                    this.miner(this.itemsetBuffer, prefixLength + 1, ULs.get(qItemNameList.get(i)), nextHUL, nextNameList, br_writer_hqui, nextHWQUI);
                }
            }
            ++i;
        }
    }

    private int compareQItems(Qitem q1, Qitem q2) {
        int compare = q2.getQteMin() * this.mapItemToProfit.get(q2.getItem()) - q1.getQteMin() * this.mapItemToProfit.get(q1.getItem());
        return compare == 0 ? q1.getItem() - q2.getItem() : compare;
    }

    private int compareCandidateItems(Qitem q1, Qitem q2) {
        int compare = q1.getItem() - q2.getItem();
        if (compare == 0) {
            compare = q1.getQteMin() - q2.getQteMin();
        }
        if (compare == 0) {
            compare = q1.getQteMax() - q2.getQteMax();
        }
        return compare;
    }

    public void printStatistics() {
        System.out.println("============= TKQ v 2.52 Statistical results===============");
        System.out.println("K: " + this.k + " coefficient: " + this.coefficient);
        System.out.println("HUQIcount:" + this.HUQIcount);
        System.out.println("Runtime: " + (double)(this.endTime - this.startTime) / 1000.0 + " (s)");
        System.out.println("Memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " (Mb)");
        System.out.println("Join operation count: " + this.countConstruct);
        System.out.println("================================================");
    }
}

