/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.CFITree;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.FPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.FPTree;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFPClose {
    private long startTimestamp;
    private long endTime;
    private int transactionCount = 0;
    private int itemsetCount;
    public int minSupportRelative;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;
    private int[] countBuffer = null;
    public CFITree cfiTree = null;
    private Map<Integer, Integer> originalMapSupport = null;
    private final boolean DEBUG = false;
    Comparator<Integer> comparatorOriginalOrder = new Comparator<Integer>(){

        @Override
        public int compare(Integer item1, Integer item2) {
            int compare = (Integer)AlgoFPClose.this.originalMapSupport.get(item2) - (Integer)AlgoFPClose.this.originalMapSupport.get(item1);
            if (compare == 0) {
                compare = item1 - item2;
                return compare;
            }
            return compare;
        }
    };

    public Itemsets runAlgorithm(String input, String output, double minsupp) throws FileNotFoundException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        MemoryLogger.getInstance().reset();
        MemoryLogger.getInstance().checkMemory();
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.originalMapSupport = this.scanDatabaseToDetermineFrequencyOfSingleItems(input);
        this.minSupportRelative = (int)Math.ceil(minsupp * (double)this.transactionCount);
        this.cfiTree = new CFITree();
        FPTree tree = new FPTree();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            ArrayList<Integer> transaction = new ArrayList<Integer>();
            String[] stringArray = lineSplited;
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                if (this.originalMapSupport.get(item) >= this.minSupportRelative) {
                    transaction.add(item);
                }
                ++n2;
            }
            Collections.sort(transaction, this.comparatorOriginalOrder);
            tree.addTransaction(transaction);
        }
        this.cfiTree.setComparator(this.comparatorOriginalOrder);
        reader.close();
        tree.createHeaderList(this.originalMapSupport);
        if (tree.headerList.size() > 0) {
            this.itemsetBuffer = new int[2000];
            this.countBuffer = new int[2000];
            this.fpclose(tree, this.itemsetBuffer, 0, this.transactionCount, this.originalMapSupport);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        return this.patterns;
    }

    /*
     * WARNING - void declaration
     */
    private void fpclose(FPTree tree, int[] prefix, int prefixLength, int prefixSupport, Map<Integer, Integer> mapSupport) throws IOException {
        boolean singlePath = true;
        int position = prefixLength;
        if (tree.root.childs.size() > 1) {
            singlePath = false;
        } else {
            FPNode currentNode = tree.root.childs.get(0);
            while (true) {
                if (currentNode.childs.size() > 1) {
                    singlePath = false;
                    break;
                }
                this.itemsetBuffer[position] = currentNode.itemID;
                this.countBuffer[position] = currentNode.counter;
                ++position;
                if (currentNode.childs.size() == 0) break;
                currentNode = currentNode.childs.get(0);
            }
        }
        if (singlePath && this.countBuffer[position - 1] >= this.minSupportRelative) {
            int i = prefixLength;
            while (i <= position) {
                int[] headWithP;
                int pathSupport;
                if (i == position) {
                    pathSupport = this.countBuffer[i - 1];
                    headWithP = new int[i];
                    System.arraycopy(this.itemsetBuffer, 0, headWithP, 0, i);
                    this.sortOriginalOrder(headWithP, i);
                    if (this.cfiTree.passSubsetChecking(headWithP, i, pathSupport)) {
                        this.saveItemset(headWithP, i, pathSupport);
                    }
                } else if (i > 0 && this.countBuffer[i - 1] != 0 && this.countBuffer[i - 1] != this.countBuffer[i]) {
                    pathSupport = this.countBuffer[i - 1];
                    headWithP = new int[i];
                    System.arraycopy(this.itemsetBuffer, 0, headWithP, 0, i);
                    this.sortOriginalOrder(headWithP, i);
                    if (this.cfiTree.passSubsetChecking(headWithP, i, pathSupport)) {
                        this.saveItemset(headWithP, i, pathSupport);
                    }
                }
                ++i;
            }
        } else {
            int i = tree.headerList.size() - 1;
            while (i >= 0) {
                Integer item = tree.headerList.get(i);
                int support = mapSupport.get(item);
                int betaSupport = prefixSupport < support ? prefixSupport : support;
                prefix[prefixLength] = item;
                this.countBuffer[prefixLength] = betaSupport;
                ArrayList prefixPaths = new ArrayList();
                FPNode path = tree.mapItemNodes.get(item);
                HashMap<Integer, Integer> mapSupportBeta = new HashMap<Integer, Integer>();
                while (path != null) {
                    if (path.parent.itemID != -1) {
                        void var17_24;
                        ArrayList<Object> prefixPath = new ArrayList<Object>();
                        prefixPath.add(path);
                        int pathCount = path.counter;
                        FPNode fPNode = path.parent;
                        while (var17_24.itemID != -1) {
                            prefixPath.add(var17_24);
                            if (mapSupportBeta.get(var17_24.itemID) == null) {
                                mapSupportBeta.put(var17_24.itemID, pathCount);
                            } else {
                                mapSupportBeta.put(var17_24.itemID, (Integer)mapSupportBeta.get(var17_24.itemID) + pathCount);
                            }
                            FPNode fPNode2 = var17_24.parent;
                        }
                        prefixPaths.add(prefixPath);
                    }
                    path = path.nodeLink;
                }
                int[] headWithP = new int[prefixLength + 1];
                System.arraycopy(prefix, 0, headWithP, 0, prefixLength + 1);
                this.sortOriginalOrder(headWithP, prefixLength + 1);
                if (this.cfiTree.passSubsetChecking(headWithP, prefixLength + 1, betaSupport)) {
                    FPTree treeBeta = new FPTree();
                    for (List list : prefixPaths) {
                        treeBeta.addPrefixPath(list, mapSupportBeta, this.minSupportRelative);
                    }
                    if (treeBeta.root.childs.size() > 0) {
                        treeBeta.createHeaderList(this.originalMapSupport);
                        this.fpclose(treeBeta, prefix, prefixLength + 1, betaSupport, mapSupportBeta);
                    }
                    if (this.cfiTree.passSubsetChecking(headWithP, prefixLength + 1, betaSupport)) {
                        this.saveItemset(headWithP, prefixLength + 1, betaSupport);
                    }
                }
                --i;
            }
        }
    }

    private void saveItemset(int[] itemset2, int itemsetLength, int support) throws IOException {
        int[] itemsetCopy = new int[itemsetLength];
        System.arraycopy(itemset2, 0, itemsetCopy, 0, itemsetLength);
        this.sortOriginalOrder(itemsetCopy, itemsetLength);
        this.cfiTree.addCFI(itemsetCopy, itemsetCopy.length, support);
        ++this.itemsetCount;
        if (this.writer != null) {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < itemsetLength) {
                buffer.append(itemsetCopy[i]);
                if (i != itemsetLength - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            Arrays.sort(itemsetCopy);
            Itemset itemsetObj = new Itemset(itemsetCopy);
            itemsetObj.setAbsoluteSupport(support);
            this.patterns.addItemset(itemsetObj, itemsetLength);
        }
    }

    public void sortOriginalOrder(int[] a, int length) {
        int i = 0;
        while (i < length) {
            int j = length - 1;
            while (j >= i + 1) {
                boolean test;
                boolean bl = test = this.comparatorOriginalOrder.compare(a[j], a[j - 1]) < 0;
                if (test) {
                    int temp = a[j];
                    a[j] = a[j - 1];
                    a[j - 1] = temp;
                }
                --j;
            }
            ++i;
        }
    }

    private Map<Integer, Integer> scanDatabaseToDetermineFrequencyOfSingleItems(String input) throws FileNotFoundException, IOException {
        String line;
        HashMap<Integer, Integer> mapSupport = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapSupport.get(item);
                if (count == null) {
                    mapSupport.put(item, 1);
                } else {
                    count = count + 1;
                    mapSupport.put(item, count);
                }
                ++n2;
            }
            ++this.transactionCount;
        }
        reader.close();
        return mapSupport;
    }

    public void printStats() {
        System.out.println("=============  FP-Close v0.96r14  - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.transactionCount);
        System.out.print(" Max memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " mb \n");
        System.out.println(" Closed frequent itemset count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public int getDatabaseSize() {
        return this.transactionCount;
    }
}

