/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings.FPNode_Strings;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings.FPTree_Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFPGrowth_Strings {
    private long startTimestamp;
    private long endTime;
    private int transactionCount = 0;
    private int itemsetCount;
    public int relativeMinsupp;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, double minsupp) throws FileNotFoundException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.writer = new BufferedWriter(new FileWriter(output));
        final HashMap<String, Integer> mapSupport = new HashMap<String, Integer>();
        this.scanDatabaseToDetermineFrequencyOfSingleItems(input, mapSupport);
        this.relativeMinsupp = (int)Math.ceil(minsupp * (double)this.transactionCount);
        FPTree_Strings tree = new FPTree_Strings();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            ArrayList<String> transaction = new ArrayList<String>();
            String[] stringArray = lineSplited;
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                if ((Integer)mapSupport.get(itemString) >= this.relativeMinsupp) {
                    transaction.add(itemString);
                }
                ++n2;
            }
            Collections.sort(transaction, new Comparator<String>(){

                @Override
                public int compare(String item1, String item2) {
                    int compare = (Integer)mapSupport.get(item2) - (Integer)mapSupport.get(item1);
                    if (compare == 0) {
                        return item1.compareTo(item2);
                    }
                    return compare;
                }
            });
            tree.addTransaction(transaction);
        }
        reader.close();
        tree.createHeaderList(mapSupport);
        String[] prefixAlpha = new String[]{};
        if (tree.headerList.size() > 0) {
            this.fpgrowth(tree, prefixAlpha, this.transactionCount, mapSupport);
        }
        this.writer.close();
        this.endTime = System.currentTimeMillis();
    }

    private void scanDatabaseToDetermineFrequencyOfSingleItems(String input, Map<String, Integer> mapSupport) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer count = mapSupport.get(itemString);
                if (count == null) {
                    mapSupport.put(itemString, 1);
                } else {
                    count = count + 1;
                    mapSupport.put(itemString, count);
                }
                ++n2;
            }
            ++this.transactionCount;
        }
        reader.close();
    }

    private void fpgrowth(FPTree_Strings tree, String[] prefixAlpha, int prefixSupport, Map<String, Integer> mapSupport) throws IOException {
        if (!tree.hasMoreThanOnePath) {
            this.addAllCombinationsForPathAndPrefix(tree.root.childs.get(0), prefixAlpha);
        } else {
            this.fpgrowthMoreThanOnePath(tree, prefixAlpha, prefixSupport, mapSupport);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fpgrowthMoreThanOnePath(FPTree_Strings tree, String[] prefixAlpha, int prefixSupport, Map<String, Integer> mapSupport) throws IOException {
        int i = tree.headerList.size() - 1;
        while (i >= 0) {
            String item = tree.headerList.get(i);
            int support = mapSupport.get(item);
            if (support >= this.relativeMinsupp) {
                String[] beta = new String[prefixAlpha.length + 1];
                System.arraycopy(prefixAlpha, 0, beta, 0, prefixAlpha.length);
                beta[prefixAlpha.length] = item;
                int betaSupport = prefixSupport < support ? prefixSupport : support;
                this.writeItemsetToFile(beta, betaSupport);
                ArrayList prefixPaths = new ArrayList();
                FPNode_Strings path = tree.mapItemNodes.get(item);
                while (path != null) {
                    if (path.parent.itemID != null) {
                        void var13_16;
                        ArrayList<Object> prefixPath = new ArrayList<Object>();
                        prefixPath.add(path);
                        FPNode_Strings fPNode_Strings = path.parent;
                        while (var13_16.itemID != null) {
                            prefixPath.add(var13_16);
                            FPNode_Strings fPNode_Strings2 = var13_16.parent;
                        }
                        prefixPaths.add(prefixPath);
                    }
                    path = path.nodeLink;
                }
                HashMap<String, Integer> mapSupportBeta = new HashMap<String, Integer>();
                for (List list : prefixPaths) {
                    int pathCount = ((FPNode_Strings)list.get((int)0)).counter;
                    int j = 1;
                    while (j < list.size()) {
                        FPNode_Strings node = (FPNode_Strings)list.get(j);
                        if (mapSupportBeta.get(node.itemID) == null) {
                            mapSupportBeta.put(node.itemID, pathCount);
                        } else {
                            mapSupportBeta.put(node.itemID, (Integer)mapSupportBeta.get(node.itemID) + pathCount);
                        }
                        ++j;
                    }
                }
                FPTree_Strings fPTree_Strings = new FPTree_Strings();
                for (List list : prefixPaths) {
                    fPTree_Strings.addPrefixPath(list, mapSupportBeta, this.relativeMinsupp);
                }
                fPTree_Strings.createHeaderList(mapSupportBeta);
                if (fPTree_Strings.root.childs.size() > 0) {
                    this.fpgrowth(fPTree_Strings, beta, betaSupport, mapSupportBeta);
                }
            }
            --i;
        }
    }

    private void addAllCombinationsForPathAndPrefix(FPNode_Strings node, String[] prefix) throws IOException {
        String[] itemset2 = new String[prefix.length + 1];
        System.arraycopy(prefix, 0, itemset2, 0, prefix.length);
        itemset2[prefix.length] = node.itemID;
        this.writeItemsetToFile(itemset2, node.counter);
        if (node.childs.size() != 0) {
            this.addAllCombinationsForPathAndPrefix(node.childs.get(0), itemset2);
            this.addAllCombinationsForPathAndPrefix(node.childs.get(0), prefix);
        }
    }

    private void writeItemsetToFile(String[] itemset2, int support) throws IOException {
        ++this.itemsetCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < itemset2.length) {
            buffer.append(itemset2[i]);
            if (i != itemset2.length - 1) {
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(':');
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  FP-GROWTH - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.transactionCount);
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }
}

