/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings.FPNode_Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FPTree_Strings {
    List<String> headerList = null;
    Map<String, FPNode_Strings> mapItemNodes = new HashMap<String, FPNode_Strings>();
    boolean hasMoreThanOnePath = false;
    Map<String, FPNode_Strings> mapItemLastNode = new HashMap<String, FPNode_Strings>();
    FPNode_Strings root = new FPNode_Strings();

    FPTree_Strings() {
    }

    private void fixNodeLinks(String item, FPNode_Strings newNode) {
        FPNode_Strings lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        FPNode_Strings headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    public void addTransaction(List<String> transaction) {
        FPNode_Strings currentNode = this.root;
        for (String item : transaction) {
            FPNode_Strings child = currentNode.getChildWithID(item);
            if (child == null) {
                FPNode_Strings newNode = new FPNode_Strings();
                newNode.itemID = item;
                newNode.parent = currentNode;
                currentNode.childs.add(newNode);
                if (!this.hasMoreThanOnePath && currentNode.childs.size() > 1) {
                    this.hasMoreThanOnePath = true;
                }
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            ++child.counter;
            currentNode = child;
        }
    }

    void addPrefixPath(List<FPNode_Strings> prefixPath, Map<String, Integer> mapSupportBeta, int relativeMinsupp) {
        int pathCount = prefixPath.get((int)0).counter;
        FPNode_Strings currentNode = this.root;
        int i = prefixPath.size() - 1;
        while (i >= 1) {
            FPNode_Strings pathItem = prefixPath.get(i);
            if (mapSupportBeta.get(pathItem.itemID) >= relativeMinsupp) {
                FPNode_Strings child = currentNode.getChildWithID(pathItem.itemID);
                if (child == null) {
                    FPNode_Strings newNode = new FPNode_Strings();
                    newNode.itemID = pathItem.itemID;
                    newNode.parent = currentNode;
                    newNode.counter = pathCount;
                    currentNode.childs.add(newNode);
                    if (!this.hasMoreThanOnePath && currentNode.childs.size() > 1) {
                        this.hasMoreThanOnePath = true;
                    }
                    currentNode = newNode;
                    this.fixNodeLinks(pathItem.itemID, newNode);
                } else {
                    child.counter += pathCount;
                    currentNode = child;
                }
            }
            --i;
        }
    }

    void createHeaderList(final Map<String, Integer> mapSupport) {
        this.headerList = new ArrayList<String>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                int compare = (Integer)mapSupport.get(id2) - (Integer)mapSupport.get(id1);
                if (compare == 0) {
                    return id1.compareTo(id2);
                }
                return compare;
            }
        });
    }
}

