/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.haui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.haui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_miner.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHAUIMiner {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int huiCount = 0;
    Map<Integer, Integer> mapItemToAUUB;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, int minAUtility) throws IOException {
        block26: {
            String thisLine;
            BufferedReader myInput;
            block24: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToAUUB = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            String[] utilityValues = split[2].split(" ");
                            Integer transactionMUtility = Integer.MIN_VALUE;
                            int i = 0;
                            while (i < utilityValues.length) {
                                if (transactionMUtility < Integer.parseInt(utilityValues[i])) {
                                    transactionMUtility = Integer.parseInt(utilityValues[i]);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer auub = this.mapItemToAUUB.get(item);
                                auub = auub == null ? transactionMUtility : auub + transactionMUtility;
                                this.mapItemToAUUB.put(item, auub);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            ArrayList<Integer> ltemLists = new ArrayList<Integer>();
            for (Integer item : this.mapItemToAUUB.keySet()) {
                if (this.mapItemToAUUB.get(item) < minAUtility) continue;
                ltemLists.add(item);
            }
            Collections.sort(ltemLists, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return AlgoHAUIMiner.this.compareItems(o1, o2);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    ArrayList<List<Pair>> reviesdDatabase = new ArrayList<List<Pair>>();
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToAUUB.get(pair.item) >= minAUtility) {
                                revisedTransaction.add(pair);
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoHAUIMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        reviesdDatabase.add(revisedTransaction);
                    }
                    for (Integer item : ltemLists) {
                        this.initialUtilityList(minAUtility, reviesdDatabase, item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void initialUtilityList(int minAUtility, List<List<Pair>> revisedDatabase, int item) throws IOException {
        Pair pair;
        int j;
        int i;
        HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        HashMap<Integer, Integer> mapItemToAuubList = new HashMap<Integer, Integer>();
        int tid = 0;
        while (tid < revisedDatabase.size()) {
            i = 0;
            while (i < revisedDatabase.get(tid).size()) {
                if (revisedDatabase.get((int)tid).get((int)i).item == item) {
                    int transactionMaxUtility = Integer.MIN_VALUE;
                    j = i;
                    while (j < revisedDatabase.get(tid).size()) {
                        pair = revisedDatabase.get(tid).get(j);
                        if (pair.utility > transactionMaxUtility) {
                            transactionMaxUtility = pair.utility;
                        }
                        ++j;
                    }
                    j = i;
                    while (j < revisedDatabase.get(tid).size()) {
                        pair = revisedDatabase.get(tid).get(j);
                        Integer auub = (Integer)mapItemToAuubList.get(pair.item);
                        auub = auub == null ? transactionMaxUtility : auub + transactionMaxUtility;
                        mapItemToAuubList.put(pair.item, auub);
                        ++j;
                    }
                }
                ++i;
            }
            ++tid;
        }
        tid = 0;
        while (tid < revisedDatabase.size()) {
            i = 0;
            while (i < revisedDatabase.get(tid).size()) {
                if (revisedDatabase.get((int)tid).get((int)i).item == item) {
                    int maxUtility = Integer.MIN_VALUE;
                    j = i;
                    while (j < revisedDatabase.get(tid).size()) {
                        pair = revisedDatabase.get(tid).get(j);
                        if ((Integer)mapItemToAuubList.get(pair.item) >= minAUtility && pair.utility > maxUtility) {
                            maxUtility = pair.utility;
                        }
                        ++j;
                    }
                    j = i;
                    while (j < revisedDatabase.get(tid).size()) {
                        pair = revisedDatabase.get(tid).get(j);
                        Element element = new Element(tid, pair.utility, maxUtility);
                        if ((Integer)mapItemToAuubList.get(pair.item) >= minAUtility) {
                            UtilityList utilityListOfItem;
                            if (mapItemToUtilityList.containsKey(pair.item)) {
                                utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                                utilityListOfItem.addElement(element);
                            } else {
                                utilityListOfItem = new UtilityList(pair.item);
                                utilityListOfItem.addElement(element);
                                mapItemToUtilityList.put(pair.item, utilityListOfItem);
                            }
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
            ++tid;
        }
        ArrayList<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
        for (Integer mapItem : mapItemToUtilityList.keySet()) {
            UtilityList auList = (UtilityList)mapItemToUtilityList.get(mapItem);
            if (auList.sumMutils < minAUtility) continue;
            listOfUtilityLists.add(auList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoHAUIMiner.this.compareItems(o1.item, o2.item);
            }
        });
        this.huiMiner(new int[0], null, listOfUtilityLists, minAUtility, 1.0);
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToAUUB.get(item1) - this.mapItemToAUUB.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void huiMiner(int[] prefix, UtilityList pUL, List<UtilityList> ULs, int minAUtility, double length) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityList X = ULs.get(i);
            if ((double)X.sumIutils / length >= (double)minAUtility) {
                this.writeOut(prefix, X.item, (double)X.sumIutils / length);
            }
            if (X.sumMutils >= minAUtility) {
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                int j = i + 1;
                while (j < ULs.size()) {
                    UtilityList Y = ULs.get(j);
                    exULs.add(this.construct(pUL, X, Y));
                    ++j;
                }
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = X.item;
                this.huiMiner(newPrefix, X, exULs, minAUtility, length + 1.0);
            }
            if (length == 1.0) break;
            ++i;
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.mutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.mutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int item, double autility) throws IOException {
        ++this.huiCount;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < prefix.length) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        buffer.append(" #AUTIL: ");
        buffer.append(autility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HAUI-MINER ALGORITHM v.2.15 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

