/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau;

import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemsetTP;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemsetsTP;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.TransactionTP;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.UtilityTransactionDatabaseTP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoHAUIMMAU {
    private ItemsetsTP highAUtilityItemsets = null;
    protected UtilityTransactionDatabaseTP database;
    Map<Integer, Integer> minAUtility = new HashMap<Integer, Integer>();
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    private int candidatesCount;

    public ItemsetsTP runAlgorithm(UtilityTransactionDatabaseTP database, Map<Integer, Integer> mutipleMinUtilities, int GLMAU) {
        int candidateCount;
        this.database = database;
        this.minAUtility = mutipleMinUtilities;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.highAUtilityItemsets = new ItemsetsTP("HIGH AVERAGE UTILITY ITEMSETS WITH MULTIPLE MINIMUM THRESHOLDS");
        HashMap<List<Integer>, Integer> HAUIMap = new HashMap<List<Integer>, Integer>();
        HashMap<List<Integer>, Integer> candidateHAUIMap = new HashMap<List<Integer>, Integer>();
        this.candidatesCount = 0;
        ArrayList<ItemsetTP> candidatesSize1 = new ArrayList<ItemsetTP>();
        HashMap<Integer, HashSet<Integer>> mapItemTidsets = new HashMap<Integer, HashSet<Integer>>();
        HashMap<Integer, Integer> mapItemAUUB = new HashMap<Integer, Integer>();
        int maxItem = Integer.MIN_VALUE;
        int i = 0;
        while (i < database.size()) {
            TransactionTP transaction = database.getTransactions().get(i);
            int j = 0;
            while (j < transaction.getItems().size()) {
                HashSet<Integer> tidset2;
                ItemUtility itemUtilityObj = transaction.getItems().get(j);
                int item = itemUtilityObj.item;
                if (item > maxItem) {
                    maxItem = item;
                }
                if ((tidset2 = (HashSet<Integer>)mapItemTidsets.get(item)) == null) {
                    tidset2 = new HashSet<Integer>();
                    mapItemTidsets.put(item, tidset2);
                }
                tidset2.add(i);
                Integer sumUtility = (Integer)mapItemAUUB.get(item);
                if (sumUtility == null) {
                    sumUtility = 0;
                }
                sumUtility = sumUtility + transaction.getTransactionUtility();
                mapItemAUUB.put(item, sumUtility);
                ++j;
            }
            ++i;
        }
        int item = 0;
        while (item <= maxItem) {
            Integer estimatedUtility = (Integer)mapItemAUUB.get(item);
            if (estimatedUtility != null && estimatedUtility >= database.getLMAU(GLMAU)) {
                ItemsetTP itemset2 = new ItemsetTP();
                itemset2.addItem(item);
                itemset2.setTIDset((Set)mapItemTidsets.get(item));
                candidateHAUIMap.put(itemset2.getItems(), estimatedUtility);
                candidatesSize1.add(itemset2);
                this.highAUtilityItemsets.addItemset(itemset2, itemset2.size());
            }
            ++item;
        }
        i = 0;
        while (i < candidatesSize1.size()) {
            int j = candidatesSize1.size() - 1;
            while (j > 0) {
                if (mutipleMinUtilities.get(((ItemsetTP)candidatesSize1.get(j - 1)).getItems().get(0)) > mutipleMinUtilities.get(((ItemsetTP)candidatesSize1.get(j)).getItems().get(0))) {
                    Collections.swap(candidatesSize1, j, j - 1);
                }
                --j;
            }
            ++i;
        }
        List<ItemsetTP> currentLevel = candidatesSize1;
        do {
            candidateCount = this.highAUtilityItemsets.getItemsetsCount();
            currentLevel = this.generateCandidateSizeK(currentLevel, this.highAUtilityItemsets, candidateHAUIMap, mutipleMinUtilities, GLMAU);
        } while (candidateCount != this.highAUtilityItemsets.getItemsetsCount());
        MemoryLogger.getInstance().checkMemory();
        for (List<ItemsetTP> level : this.highAUtilityItemsets.getLevels()) {
            this.candidatesCount += level.size();
            Iterator<ItemsetTP> iterItemset = level.iterator();
            while (iterItemset.hasNext()) {
                ItemsetTP candidate = iterItemset.next();
                if (!AlgoHAUIMMAU.judge(candidate.getItems(), HAUIMap, true)) {
                    iterItemset.remove();
                    this.highAUtilityItemsets.decreaseCount();
                    continue;
                }
                for (TransactionTP transaction : database.getTransactions()) {
                    int transactionUtility = 0;
                    int matchesCount = 0;
                    int i2 = 0;
                    while (i2 < transaction.size()) {
                        if (candidate.getItems().contains(transaction.get((int)i2).item)) {
                            transactionUtility += transaction.getItemsUtilities().get((int)i2).utility;
                            ++matchesCount;
                        }
                        ++i2;
                    }
                    if (matchesCount != candidate.size()) continue;
                    candidate.incrementUtility(transactionUtility);
                }
                if ((float)candidate.getAUtility() >= candidate.getItemsetMau(mutipleMinUtilities, GLMAU)) {
                    HAUIMap.put(candidate.getItems(), candidate.getAUtility());
                }
                if (!((float)candidate.getAUtility() < candidate.getItemsetMau(mutipleMinUtilities, GLMAU))) continue;
                iterItemset.remove();
                this.highAUtilityItemsets.decreaseCount();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.highAUtilityItemsets;
    }

    protected static boolean judge(List<Integer> items, Map<List<Integer>, Integer> HAUIMap, boolean mark) {
        boolean temp = true;
        if (items.size() == 1) {
            return true;
        }
        ArrayList subset = new ArrayList();
        ArrayList<Integer> set = new ArrayList<Integer>();
        set.add(items.get(0));
        subset.add(set);
        int i = 1;
        while (i < items.size() - 1) {
            ArrayList<Integer> setadd;
            int j = 0;
            int k = subset.size();
            while (j < k) {
                setadd = new ArrayList();
                setadd.addAll((Collection)subset.get(j));
                setadd.add(items.get(i));
                subset.add(setadd);
                ++j;
            }
            setadd = new ArrayList<Integer>();
            setadd.add(items.get(i));
            subset.add(setadd);
            ++i;
        }
        i = 0;
        while (i < subset.size()) {
            if (mark) {
                if (!HAUIMap.containsKey(subset.get(i)) && !HAUIMap.containsKey(AlgoHAUIMMAU.subtraction(items, (List)subset.get(i)))) {
                    temp = false;
                    break;
                }
            } else if (!HAUIMap.containsKey(subset.get(i)) || !HAUIMap.containsKey(AlgoHAUIMMAU.subtraction(items, (List)subset.get(i)))) {
                temp = false;
                break;
            }
            ++i;
        }
        return temp;
    }

    protected static List<Integer> subtraction(List<Integer> items, List<Integer> subitems) {
        ArrayList<Integer> remainitems = new ArrayList<Integer>();
        int i = 0;
        while (i < items.size()) {
            boolean temp = true;
            int j = 0;
            while (j < subitems.size()) {
                if (items.get(i) == subitems.get(j)) {
                    temp = false;
                    break;
                }
                ++j;
            }
            if (temp) {
                remainitems.add(items.get(i));
            }
            ++i;
        }
        return remainitems;
    }

    protected List<ItemsetTP> generateCandidateSizeK(List<ItemsetTP> levelK_1, ItemsetsTP candidatesHAUUBI, Map<List<Integer>, Integer> candidateHAUIMap, Map<Integer, Integer> mutipleMinUtilities, int GLMAU) {
        int i = 0;
        while (i < levelK_1.size()) {
            ItemsetTP itemset1 = levelK_1.get(i);
            int j = i + 1;
            while (j < levelK_1.size()) {
                block9: {
                    ItemsetTP itemset2 = levelK_1.get(j);
                    int k = 0;
                    while (k < itemset1.size() - 1) {
                        if (itemset1.getItems().get(k) == itemset2.get(k)) {
                            ++k;
                            continue;
                        }
                        break block9;
                    }
                    Integer missing = itemset2.get(itemset2.size() - 1);
                    ItemsetTP candidate = new ItemsetTP();
                    int k2 = 0;
                    while (k2 < itemset1.size()) {
                        candidate.addItem(itemset1.get(k2));
                        ++k2;
                    }
                    candidate.addItem(missing);
                    if (AlgoHAUIMMAU.judge(candidate.getItems(), candidateHAUIMap, false)) {
                        HashSet<Integer> tidset2 = new HashSet<Integer>();
                        for (Integer val1 : itemset1.getTIDset()) {
                            if (!itemset2.getTIDset().contains(val1)) continue;
                            tidset2.add(val1);
                        }
                        int AUUB = 0;
                        for (Integer tid : tidset2) {
                            AUUB += this.database.getTransactions().get(tid).getTransactionUtility();
                        }
                        if ((float)AUUB >= candidate.getItemsetMau(mutipleMinUtilities, GLMAU)) {
                            candidate.setTIDset(tidset2);
                            candidatesHAUUBI.addItemset(candidate, candidate.size());
                            candidateHAUIMap.put(candidate.getItems(), candidate.getAUtility());
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidatesHAUUBI.getLevels().get(candidatesHAUUBI.getLevels().size() - 1);
    }

    public void printStats() throws IOException {
        System.out.println("=============  HAUIMMAU  ALGORITHM v. 2.15 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory: " + MemoryLogger.getInstance().getMaxMemory() + "MB");
        System.out.println(" High avergae-utility itemsets count : " + this.highAUtilityItemsets.getItemsetsCount());
        System.out.println(" Candidates count : " + this.candidatesCount);
        System.out.println("===================================================");
    }
}

