/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListEIHI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoEIHI {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public long totalTimeForAllRuns = 0L;
    public int totalCandidateCountForAllRuns = 0;
    public int transactionCount;
    public int candidateCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToRank;
    Map<Integer, Map<Integer, Integer>> mapEUCS;
    boolean debug = false;
    private Map<Integer, UtilityListEIHI> mapItemToUtilityList;
    List<UtilityListEIHI> listOfUtilityLists;
    int totalDBUtility = 0;
    int minUtility;
    int firstLine;
    private int[] itemsetBuffer = null;
    final int BUFFERS_SIZE = 400;
    List<Node> singleItemsNodes;
    int middle = -1;

    public int getRealHUICount() {
        return this.getRealHUICount(this.singleItemsNodes);
    }

    public int getRealHUICount(List<Node> list) {
        int count = 0;
        for (Node node : list) {
            if (node.utility >= this.minUtility) {
                ++count;
            }
            count += this.getRealHUICount(node.childs);
        }
        return count;
    }

    public void printHUIs() {
        this.printHUIs(this.singleItemsNodes, "");
    }

    public void printHUIs(List<Node> list, String prefix) {
        for (Node node : list) {
            String itemset2 = String.valueOf(prefix) + " " + node.item;
            if (node.utility >= this.minUtility) {
                System.out.println(String.valueOf(itemset2) + "  #UTIL: " + node.utility);
            }
            this.printHUIs(node.childs, itemset2);
        }
    }

    public void writeHUIsToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        this.writeHUIsToFile(this.singleItemsNodes, "", writer);
        writer.close();
    }

    public void writeHUIsToFile(List<Node> list, String prefix, BufferedWriter writer) throws IOException {
        for (Node node : list) {
            String itemset2 = String.valueOf(prefix) + " " + node.item;
            if (node.utility >= this.minUtility) {
                writer.write(String.valueOf(itemset2) + "  #UTIL: " + node.utility + "\n");
            }
            this.writeHUIsToFile(node.childs, itemset2, writer);
        }
    }

    public void printTrie() {
        System.out.println("==== trie ====");
        this.printTrie(this.singleItemsNodes, "");
    }

    public void printTrie(List<Node> list, String indent) {
        for (Node node : list) {
            String itemset2 = String.valueOf(indent) + node.item;
            System.out.println(String.valueOf(itemset2) + "  (" + node.utility + ")");
            this.printTrie(node.childs, String.valueOf(indent) + "\t");
        }
    }

    public boolean purgeTrie(List<Node> list) {
        boolean hasChildInHUI = false;
        Iterator<Node> iter = list.iterator();
        while (iter.hasNext()) {
            Node node = iter.next();
            if (node.utility >= this.minUtility) {
                hasChildInHUI = true;
                continue;
            }
            boolean nodeHasChildInAHUI = this.purgeTrie(node.childs);
            if (!nodeHasChildInAHUI) {
                iter.remove();
                continue;
            }
            hasChildInHUI = true;
        }
        return hasChildInHUI;
    }

    public void insertHUIinTrie(int[] prefix, int prefixLength, int lastitem, int utility) {
        List<Node> listNodes = this.singleItemsNodes;
        Node currentNode = null;
        int i = 0;
        while (i < prefixLength) {
            int item = prefix[i];
            currentNode = this.binarySearchForItem(listNodes, item);
            if (currentNode == null) {
                currentNode = new Node(item);
                listNodes.add(this.middle, currentNode);
                listNodes = currentNode.childs;
            } else {
                listNodes = currentNode.childs;
            }
            ++i;
        }
        currentNode = this.binarySearchForItem(listNodes, lastitem);
        if (currentNode == null) {
            currentNode = new Node(lastitem, utility);
            listNodes.add(this.middle, currentNode);
            ++this.huiCount;
        } else {
            if (currentNode.utility == -1) {
                ++this.huiCount;
            }
            currentNode.utility = utility;
        }
    }

    public Node binarySearchForItem(List<Node> list, int item) {
        this.middle = 0;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            this.middle = first + last >>> 1;
            if (this.compareItemsByRank(item, list.get((int)this.middle).item) > 0) {
                first = this.middle + 1;
                continue;
            }
            if (this.compareItemsByRank(item, list.get((int)this.middle).item) < 0) {
                last = this.middle - 1;
                continue;
            }
            return list.get(this.middle);
        }
        this.middle = first;
        return null;
    }

    public void runAlgorithm(String input, Integer minUtil, int firstLine, int lastLine) throws IOException {
        block36: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            ArrayList<UtilityListEIHI> newItemsUtilityLists;
            block34: {
                boolean firstTime;
                this.maxMemory = 0.0;
                this.candidateCount = 0;
                this.huiCount = 0;
                this.itemsetBuffer = new int[400];
                this.firstLine = firstLine;
                boolean bl = firstTime = this.mapEUCS == null;
                if (firstTime) {
                    this.mapEUCS = new HashMap<Integer, Map<Integer, Integer>>();
                    this.listOfUtilityLists = new ArrayList<UtilityListEIHI>();
                    this.mapItemToRank = new HashMap<Integer, Integer>();
                    this.mapItemToUtilityList = new HashMap<Integer, UtilityListEIHI>();
                    this.singleItemsNodes = new ArrayList<Node>(100);
                    this.totalDBUtility = 0;
                } else {
                    for (UtilityListEIHI ulist : this.listOfUtilityLists) {
                        ulist.switchDPtoD();
                    }
                }
                this.startTimestamp = System.currentTimeMillis();
                newItemsUtilityLists = new ArrayList<UtilityListEIHI>();
                if (this.mapItemToTWU == null) {
                    this.mapItemToTWU = new HashMap<Integer, Integer>();
                }
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        int tid = 0;
                        while ((thisLine = myInput.readLine()) != null && tid < lastLine) {
                            if (tid >= firstLine) {
                                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                                split = thisLine.split(":");
                                items = split[0].split(" ");
                                int transactionUtility = Integer.parseInt(split[1]);
                                int i = 0;
                                while (i < items.length) {
                                    Integer item = Integer.parseInt(items[i]);
                                    Integer twu = this.mapItemToTWU.get(item);
                                    if (twu == null) {
                                        UtilityListEIHI uList = new UtilityListEIHI(item);
                                        this.mapItemToUtilityList.put(item, uList);
                                        newItemsUtilityLists.add(uList);
                                        twu = transactionUtility;
                                    } else {
                                        twu = twu + transactionUtility;
                                    }
                                    this.mapItemToTWU.put(item, twu);
                                    ++i;
                                }
                                this.totalDBUtility += transactionUtility;
                            }
                            ++tid;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.minUtility = minUtil;
            Collections.sort(newItemsUtilityLists, new Comparator<UtilityListEIHI>(){

                @Override
                public int compare(UtilityListEIHI o1, UtilityListEIHI o2) {
                    return AlgoEIHI.this.compareItems(o1.item, o2.item);
                }
            });
            for (UtilityListEIHI list : newItemsUtilityLists) {
                this.mapItemToRank.put(list.item, this.mapItemToRank.size() + 1);
            }
            this.listOfUtilityLists.addAll(newItemsUtilityLists);
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null && tid < lastLine) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        if (tid >= firstLine) {
                            Pair pair;
                            ++this.transactionCount;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            String[] utilityValues = split[2].split(" ");
                            int remainingUtility = 0;
                            int newTWU = 0;
                            ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                            int i = 0;
                            while (i < items.length) {
                                pair = new Pair();
                                pair.item = Integer.parseInt(items[i]);
                                pair.utility = Integer.parseInt(utilityValues[i]);
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                                newTWU += pair.utility;
                                ++i;
                            }
                            Collections.sort(revisedTransaction, new Comparator<Pair>(){

                                @Override
                                public int compare(Pair o1, Pair o2) {
                                    return AlgoEIHI.this.compareItemsByRank(o1.item, o2.item);
                                }
                            });
                            i = 0;
                            while (i < revisedTransaction.size()) {
                                pair = (Pair)revisedTransaction.get(i);
                                UtilityListEIHI utilityListOfItem = this.mapItemToUtilityList.get(pair.item);
                                Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                                utilityListOfItem.addElementDP(element);
                                Map<Integer, Integer> mapFMAPItem = this.mapEUCS.get(pair.item);
                                if (mapFMAPItem == null) {
                                    mapFMAPItem = new HashMap<Integer, Integer>();
                                    this.mapEUCS.put(pair.item, mapFMAPItem);
                                }
                                int j = i + 1;
                                while (j < revisedTransaction.size()) {
                                    Pair pairAfter = (Pair)revisedTransaction.get(j);
                                    Integer twuSum = mapFMAPItem.get(pairAfter.item);
                                    if (twuSum == null) {
                                        mapFMAPItem.put(pairAfter.item, newTWU);
                                    } else {
                                        mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        ArrayList<UtilityListEIHI> listULForRecursion = new ArrayList<UtilityListEIHI>(this.listOfUtilityLists.size());
        for (UtilityListEIHI ul : this.listOfUtilityLists) {
            if (ul.sumIutilsDP == 0) continue;
            listULForRecursion.add(ul);
        }
        this.incFHM(this.itemsetBuffer, 0, null, listULForRecursion);
        this.checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.totalTimeForAllRuns += this.endTimestamp - this.startTimestamp;
        this.totalCandidateCountForAllRuns += this.candidateCount;
    }

    private void incFHM(int[] prefix, int prefixLength, UtilityListEIHI pUL, List<UtilityListEIHI> ULs) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityListEIHI X = ULs.get(i);
            int utilityOfX = X.sumIutilsD + X.sumIutilsDP;
            if (utilityOfX >= this.minUtility) {
                this.insertHUIinTrie(prefix, prefixLength, X.item, utilityOfX);
            }
            if (X.sumIutilsDP + X.sumRutilsDP + X.sumIutilsD + X.sumRutilsD >= this.minUtility) {
                ArrayList<UtilityListEIHI> exULs = new ArrayList<UtilityListEIHI>();
                int j = i + 1;
                while (j < ULs.size()) {
                    Integer twuF;
                    Map<Integer, Integer> mapTWUF;
                    UtilityListEIHI Y = ULs.get(j);
                    if (Y.sumIutilsDP != 0 && ((mapTWUF = this.mapEUCS.get(X.item)) == null || (twuF = mapTWUF.get(Y.item)) != null && twuF >= this.minUtility)) {
                        ++this.candidateCount;
                        UtilityListEIHI temp = this.construct(pUL, X, Y);
                        if (temp != null) {
                            exULs.add(temp);
                        }
                    }
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.incFHM(this.itemsetBuffer, prefixLength + 1, X, exULs);
            }
            ++i;
        }
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private int compareItemsByRank(int item1, int item2) {
        int compare = this.mapItemToRank.get(item1) - this.mapItemToRank.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private UtilityListEIHI construct(UtilityListEIHI P, UtilityListEIHI px, UtilityListEIHI py) {
        Element eXY;
        Element e;
        Element eXY2;
        Element ey;
        Element ex;
        long totalUtility = px.sumIutilsD + px.sumRutilsD + px.sumIutilsDP + px.sumRutilsDP;
        UtilityListEIHI pxyUL = new UtilityListEIHI(py.item);
        int i = px.elementsDP.size() - 1;
        while (i >= 0) {
            ex = px.elementsDP.get(i);
            ey = this.findElementWithTID(py.elementsDP, ex.tid);
            if (ey == null) {
                if ((totalUtility -= (long)(ex.iutils + ex.rutils)) < (long)this.minUtility) {
                    return null;
                }
            } else if (P == null) {
                eXY2 = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElementDP(eXY2);
            } else {
                e = this.findElementWithTID(P.elementsDP, ex.tid);
                if (e != null) {
                    eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
                    pxyUL.addElementDP(eXY);
                }
            }
            --i;
        }
        if (pxyUL.elementsDP.size() == 0) {
            return null;
        }
        i = 0;
        while (i < px.elementsD.size()) {
            ex = px.elementsD.get(i);
            ey = this.findElementWithTID(py.elementsD, ex.tid);
            if (ey == null) {
                if ((totalUtility -= (long)(ex.iutils + ex.rutils)) < (long)this.minUtility) {
                    return null;
                }
            } else if (P == null) {
                eXY2 = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElementD(eXY2);
            } else {
                e = this.findElementWithTID(P.elementsD, ex.tid);
                if (e != null) {
                    eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
                    pxyUL.addElementD(eXY);
                }
            }
            ++i;
        }
        Collections.reverse(pxyUL.elementsDP);
        return pxyUL;
    }

    private Element findElementWithTID(List<Element> list, int tid) {
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() throws IOException {
        System.out.println("=============  EIHI ALGORITHM - SPMF 0.97e - STATS =============");
        System.out.println(" Number of transactions processed " + this.transactionCount);
        System.out.println(" Execution time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" New High-utility itemsets found : " + this.huiCount);
        System.out.println(" Total high-utility itemsets count : " + this.getRealHUICount());
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println(" minutil : " + this.minUtility);
        System.out.println("===================================================");
        System.out.println("TOTAL DB Utility: " + this.totalDBUtility);
        System.out.println("TOTAL CANDIDATEs FOR ALL RUNS:" + this.totalCandidateCountForAllRuns + " candidates");
        System.out.println("TOTAL TIME FOR ALL RUNS: " + this.totalTimeForAllRuns + " ms");
        System.out.println("===================================================");
    }

    public class Node {
        int item;
        List<Node> childs = new ArrayList<Node>(3);
        int utility = -1;

        public Node(int item) {
            this.item = item;
        }

        public Node(int item, int utility) {
            this.item = item;
            this.utility = utility;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

