/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUI_LIST_INS {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public long totalTimeForAllRuns = 0L;
    public int totalCandidateCountForAllRuns = 0;
    public int candidateCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToRank;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Integer>> mapEUCS;
    boolean debug = false;
    private Map<Integer, UtilityList> mapItemToUtilityList;
    List<UtilityList> listOfUtilityLists;
    int totalDBUtility = 0;
    int minUtility;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    int currentTidForUtilityList = 0;

    public void runAlgorithm(String input, String output, Integer minUtil, int firstLine, int lastLine) throws IOException {
        block33: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            ArrayList<UtilityList> newItemsUtilityLists;
            block31: {
                this.candidateCount = 0;
                this.huiCount = 0;
                this.itemsetBuffer = new int[200];
                this.maxMemory = 0.0;
                this.writer = new BufferedWriter(new FileWriter(output));
                if (this.mapEUCS == null) {
                    this.mapEUCS = new HashMap<Integer, Map<Integer, Integer>>();
                    this.listOfUtilityLists = new ArrayList<UtilityList>();
                    this.mapItemToRank = new HashMap<Integer, Integer>();
                    this.mapItemToUtilityList = new HashMap<Integer, UtilityList>();
                }
                this.startTimestamp = System.currentTimeMillis();
                newItemsUtilityLists = new ArrayList<UtilityList>();
                if (this.mapItemToTWU == null) {
                    this.mapItemToTWU = new HashMap<Integer, Integer>();
                }
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        int tid = 0;
                        while ((thisLine = myInput.readLine()) != null && tid < lastLine) {
                            if (tid >= firstLine) {
                                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                                split = thisLine.split(":");
                                items = split[0].split(" ");
                                int transactionUtility = Integer.parseInt(split[1]);
                                int i = 0;
                                while (i < items.length) {
                                    Integer item = Integer.parseInt(items[i]);
                                    Integer twu = this.mapItemToTWU.get(item);
                                    if (twu == null) {
                                        UtilityList uList = new UtilityList(item);
                                        this.mapItemToUtilityList.put(item, uList);
                                        newItemsUtilityLists.add(uList);
                                        twu = transactionUtility;
                                    } else {
                                        twu = twu + transactionUtility;
                                    }
                                    this.mapItemToTWU.put(item, twu);
                                    ++i;
                                }
                                this.totalDBUtility += transactionUtility;
                            }
                            ++tid;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.minUtility = minUtil;
            Collections.sort(newItemsUtilityLists, new Comparator<UtilityList>(){

                @Override
                public int compare(UtilityList o1, UtilityList o2) {
                    return AlgoHUI_LIST_INS.this.compareItems(o1.item, o2.item);
                }
            });
            for (UtilityList list : newItemsUtilityLists) {
                this.mapItemToRank.put(list.item, this.mapItemToRank.size() + 1);
            }
            this.listOfUtilityLists.addAll(newItemsUtilityLists);
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null && tid < lastLine) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        if (tid >= firstLine) {
                            Pair pair;
                            ++this.currentTidForUtilityList;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            String[] utilityValues = split[2].split(" ");
                            int remainingUtility = 0;
                            int newTWU = 0;
                            ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                            int i = 0;
                            while (i < items.length) {
                                pair = new Pair();
                                pair.item = Integer.parseInt(items[i]);
                                pair.utility = Integer.parseInt(utilityValues[i]);
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                                newTWU += pair.utility;
                                ++i;
                            }
                            Collections.sort(revisedTransaction, new Comparator<Pair>(){

                                @Override
                                public int compare(Pair o1, Pair o2) {
                                    return AlgoHUI_LIST_INS.this.compareItemsByRank(o1.item, o2.item);
                                }
                            });
                            i = 0;
                            while (i < revisedTransaction.size()) {
                                pair = (Pair)revisedTransaction.get(i);
                                UtilityList utilityListOfItem = this.mapItemToUtilityList.get(pair.item);
                                Element element = new Element(this.currentTidForUtilityList, pair.utility, remainingUtility -= pair.utility);
                                utilityListOfItem.addElement(element);
                                Map<Integer, Integer> mapFMAPItem = this.mapEUCS.get(pair.item);
                                if (mapFMAPItem == null) {
                                    mapFMAPItem = new HashMap<Integer, Integer>();
                                    this.mapEUCS.put(pair.item, mapFMAPItem);
                                }
                                int j = i + 1;
                                while (j < revisedTransaction.size()) {
                                    Pair pairAfter = (Pair)revisedTransaction.get(j);
                                    Integer twuSum = mapFMAPItem.get(pairAfter.item);
                                    if (twuSum == null) {
                                        mapFMAPItem.put(pairAfter.item, newTWU);
                                    } else {
                                        mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        this.huiListIns(this.itemsetBuffer, 0, null, this.listOfUtilityLists, this.minUtility);
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
        this.totalTimeForAllRuns += this.endTimestamp - this.startTimestamp;
        this.totalCandidateCountForAllRuns += this.candidateCount;
    }

    public void closeFile() throws IOException {
        this.writer.close();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private int compareItemsByRank(int item1, int item2) {
        int compare = this.mapItemToRank.get(item1) - this.mapItemToRank.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void huiListIns(int[] prefix, int prefixLength, UtilityList pUL, List<UtilityList> ULs, int minUtility) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityList X = ULs.get(i);
            if (X.sumIutils >= (long)minUtility) {
                this.writeOut(prefix, prefixLength, X.item, X.sumIutils, X.elements.size());
            }
            if (X.sumIutils + X.sumRutils >= (long)minUtility) {
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                int j = i + 1;
                while (j < ULs.size()) {
                    Integer twuF;
                    UtilityList Y = ULs.get(j);
                    Map<Integer, Integer> mapTWUF = this.mapEUCS.get(X.item);
                    if (mapTWUF == null || (twuF = mapTWUF.get(Y.item)) != null && twuF >= minUtility) {
                        ++this.candidateCount;
                        UtilityList temp = this.construct(pUL, X, Y);
                        exULs.add(temp);
                    }
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.huiListIns(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
            }
            ++i;
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long sumIutils, int support) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        ArrayList<Integer> itemset2 = new ArrayList<Integer>(prefix.length);
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            itemset2.add(prefix[i]);
            ++i;
        }
        buffer.append(item);
        itemset2.add(item);
        buffer.append(" #UTIL: ");
        buffer.append(sumIutils);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() throws IOException {
        System.out.println("=============  HUI-LIST_INS ALGORITHM - STATS =============");
        System.out.println(" Transaction processed count : " + this.currentTidForUtilityList);
        System.out.println(" Execution time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println(" minutil : " + this.minUtility);
        System.out.println("===================================================");
        System.out.println("TOTAL CANDIDATE COUNT FOR ALL RUNS:" + this.totalCandidateCountForAllRuns + " candidates");
        System.out.println("TOTAL TIME FOR ALL RUNS:" + this.totalTimeForAllRuns + " ms");
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

