/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.huimaf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUIM_AF {
    boolean DEBUG_MODE = false;
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 20;
    final int iterations = 10000;
    int transactionCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    int step;
    int tryTime = 3;
    double delta = 0.9;
    int visaul;
    boolean is_swarm = false;
    boolean is_fellow = false;
    List<Fish> fishpopulation = new ArrayList<Fish>();
    List<Fish> subfishpopulation = new ArrayList<Fish>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<Double> percentage = new ArrayList<Double>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Item> Items;
    List<Fish> huiBA = new ArrayList<Fish>();
    List<Double> percentHUIBA;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        block38: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block36: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                this.mapItemToTWU0 = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            ++this.transactionCount;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                Integer twu0 = this.mapItemToTWU0.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                this.mapItemToTWU0.put(item, twu0);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        ArrayList<Integer> pattern = new ArrayList<Integer>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                pattern.add(pair.item);
                            } else {
                                this.mapItemToTWU0.remove(pair.item);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block38;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        if (this.DEBUG_MODE) {
            System.out.println("twuPattern:" + this.twuPattern.size());
            System.out.println(this.twuPattern);
        }
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        int i = 0;
        while (i < this.database.size()) {
            int j = 0;
            while (j < this.Items.size()) {
                int k = 0;
                while (k < this.database.get(i).size()) {
                    if (this.Items.get((int)j).item == this.database.get((int)i).get((int)k).item) {
                        this.Items.get((int)j).TIDS.set(i);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            this.generatePop(minUtility);
            int j = 0;
            while (j < 10000) {
                this.visaul = (int)((double)this.twuPattern.size() * 0.1) + 1;
                int i2 = 0;
                while (i2 < 20) {
                    this.is_swarm = false;
                    this.is_fellow = false;
                    Fish fellowFish = this.follow(i2, minUtility);
                    if (!this.is_fellow) {
                        Fish swarmFish = this.swarm(i2, minUtility);
                        if (this.is_swarm) {
                            this.subfishpopulation.add(i2, swarmFish);
                        }
                    } else {
                        this.subfishpopulation.add(i2, fellowFish);
                    }
                    if (!this.is_swarm && !this.is_fellow) {
                        Fish preyFish = this.prey(i2, minUtility);
                        this.subfishpopulation.add(i2, preyFish);
                    }
                    ++i2;
                }
                this.subfishpopulation.addAll(this.fishpopulation);
                Collections.sort(this.subfishpopulation);
                int k = 0;
                while (k < this.fishpopulation.size()) {
                    this.fishpopulation.set(k, this.subfishpopulation.get(k));
                    ++k;
                }
                this.subfishpopulation.clear();
                if (this.DEBUG_MODE && j % 1000 == 0) {
                    System.out.println(String.valueOf(j) + "-update end. HUIs No. is " + this.huiSets.size());
                }
                ++j;
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void generatePop(int minUtility) {
        this.percentage = this.roulettePercent();
        if (this.DEBUG_MODE) {
            System.out.println(this.percentage);
        }
        int i = 0;
        while (i < 20) {
            Fish tempFish = new Fish(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = this.rouletteSelect(this.percentage);
                if (tempFish.X.get(temp)) continue;
                ++j;
                tempFish.X.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(tempFish, transList);
            tempFish.calculateFitness(k, transList);
            this.fishpopulation.add(i, tempFish);
            if (this.fishpopulation.get((int)i).fitness >= minUtility) {
                this.insert(this.fishpopulation.get(i));
                this.addHuiBA(this.fishpopulation.get(i));
            }
            ++i;
        }
    }

    private Fish follow(int i, int minUtility) {
        Fish newfollowfish = new Fish(this.twuPattern.size());
        newfollowfish.copyFish(this.fishpopulation.get(i));
        Fish bestFish = new Fish(this.twuPattern.size());
        bestFish.copyFish(this.fishpopulation.get(0));
        int m = 0;
        while (m < 20) {
            List<Integer> disList = this.xorBAIndividual(this.fishpopulation.get(i), this.fishpopulation.get(m));
            int dis = disList.size();
            if (this.visaul > dis && this.fishpopulation.get((int)m).fitness > bestFish.fitness) {
                bestFish.copyFish(this.fishpopulation.get(m));
            }
            ++m;
        }
        List<Integer> dis1 = this.xorBAIndividual(bestFish, this.fishpopulation.get(i));
        this.step = (int)((double)dis1.size() * Math.random()) + 1;
        if (dis1.size() > 0) {
            int m2 = 0;
            while (m2 < this.step) {
                int changeBit = (int)((double)dis1.size() * Math.random());
                if (newfollowfish.X.get(dis1.get(changeBit))) {
                    newfollowfish.X.clear(dis1.get(changeBit));
                } else {
                    newfollowfish.X.set(dis1.get(changeBit));
                }
                ++m2;
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(newfollowfish, transList);
            newfollowfish.calculateFitness(newfollowfish.X.cardinality(), transList);
            if (newfollowfish.fitness >= minUtility) {
                this.insert(newfollowfish);
                this.addHuiBA(newfollowfish);
            }
            this.is_fellow = true;
            return newfollowfish;
        }
        this.is_fellow = false;
        return null;
    }

    private Fish swarm(int i, int minUtility) {
        List<Integer> disList;
        ArrayList<Integer> count1 = new ArrayList<Integer>();
        ArrayList<Integer> count0 = new ArrayList<Integer>();
        Fish newswarmfish = new Fish(this.twuPattern.size());
        newswarmfish.copyFish(this.fishpopulation.get(i));
        Fish centerFish = new Fish(this.twuPattern.size());
        int num = 0;
        int j = 0;
        while (j < this.twuPattern.size()) {
            count1.add(j, 0);
            count0.add(j, 0);
            ++j;
        }
        int m = 0;
        while (m < 20) {
            disList = this.xorBAIndividual(newswarmfish, this.fishpopulation.get(m));
            int dis = disList.size();
            if (this.visaul > dis) {
                ++num;
                int j2 = 0;
                while (j2 < this.twuPattern.size()) {
                    if (this.fishpopulation.get((int)m).X.get(j2)) {
                        count1.add(j2, (Integer)count1.get(j2) + 1);
                    } else {
                        count0.add(j2, (Integer)count0.get(j2) + 1);
                    }
                    ++j2;
                }
            }
            ++m;
        }
        j = 0;
        while (j < this.twuPattern.size()) {
            if ((Integer)count1.get(j) >= (Integer)count0.get(j)) {
                centerFish.X.set(j, true);
            } else {
                centerFish.X.set(j, false);
            }
            ++j;
        }
        ArrayList<Integer> transList = new ArrayList<Integer>();
        this.isRBAIndividual(centerFish, transList);
        centerFish.calculateFitness(centerFish.X.cardinality(), transList);
        if (centerFish.fitness >= minUtility) {
            this.insert(centerFish);
            this.addHuiBA(centerFish);
        }
        if (centerFish.fitness > this.fishpopulation.get((int)i).fitness) {
            disList = this.xorBAIndividual(centerFish, this.fishpopulation.get(i));
            this.step = (int)((double)disList.size() * Math.random()) + 1;
            if (disList.size() > 0) {
                int m2 = 0;
                while (m2 < this.step) {
                    int changeBit = (int)((double)disList.size() * Math.random());
                    if (newswarmfish.X.get(disList.get(changeBit))) {
                        newswarmfish.X.clear(disList.get(changeBit));
                    } else {
                        newswarmfish.X.set(disList.get(changeBit));
                    }
                    ++m2;
                }
            }
            transList = new ArrayList();
            this.isRBAIndividual(newswarmfish, transList);
            newswarmfish.calculateFitness(newswarmfish.X.cardinality(), transList);
            if (newswarmfish.fitness >= minUtility) {
                this.insert(newswarmfish);
                this.addHuiBA(newswarmfish);
            }
            this.is_swarm = true;
            return newswarmfish;
        }
        return null;
    }

    private Fish prey(int i, int minUtility) {
        int changeBit;
        ArrayList<Integer> transList = new ArrayList<Integer>();
        Fish tempFish = new Fish(this.twuPattern.size());
        tempFish.copyFish(this.fishpopulation.get(i));
        Fish newpreyfish = new Fish(this.twuPattern.size());
        newpreyfish.copyFish(this.fishpopulation.get(i));
        boolean flag = false;
        int k = 0;
        while (k < this.tryTime) {
            this.step = (int)(Math.random() * (double)this.visaul) + 1;
            int m = 0;
            while (m < this.step) {
                changeBit = (int)((double)this.twuPattern.size() * Math.random());
                if (tempFish.X.get(changeBit)) {
                    tempFish.X.clear(changeBit);
                } else {
                    tempFish.X.set(changeBit);
                }
                ++m;
            }
            this.isRBAIndividual(tempFish, transList);
            tempFish.calculateFitness(tempFish.X.cardinality(), transList);
            if (tempFish.fitness >= minUtility) {
                this.insert(tempFish);
                this.addHuiBA(tempFish);
            }
            if (tempFish.fitness > newpreyfish.fitness) {
                flag = true;
                newpreyfish.copyFish(tempFish);
            }
            transList.clear();
            if (flag) break;
            ++k;
        }
        if (!flag) {
            this.step = (int)(Math.random() * (double)this.visaul) + 1;
            int m = 0;
            while (m < this.step) {
                changeBit = (int)((double)this.twuPattern.size() * Math.random());
                if (this.fishpopulation.get((int)i).X.get(changeBit)) {
                    newpreyfish.X.clear(changeBit);
                } else {
                    newpreyfish.X.set(changeBit);
                }
                ++m;
            }
            this.isRBAIndividual(newpreyfish, transList);
            newpreyfish.calculateFitness(newpreyfish.X.cardinality(), transList);
            if (newpreyfish.fitness >= minUtility) {
                this.insert(newpreyfish);
                this.addHuiBA(newpreyfish);
            }
        }
        return newpreyfish;
    }

    public boolean isRBAIndividual(Fish tempBAIndividual, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        int i = 0;
        while (i < tempBAIndividual.X.length()) {
            if (tempBAIndividual.X.get(i)) {
                templist.add(i);
            }
            ++i;
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.transactionCount);
        BitSet midBitSet = new BitSet(this.transactionCount);
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        int i2 = 1;
        while (i2 < templist.size()) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i2)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
            } else {
                tempBitSet = (BitSet)midBitSet.clone();
                tempBAIndividual.X.clear((Integer)templist.get(i2));
            }
            ++i2;
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        int m = 0;
        while (m < tempBitSet.length()) {
            if (tempBitSet.get(m)) {
                list.add(m);
            }
            ++m;
        }
        return true;
    }

    private List<Integer> xorBAIndividual(Fish temp, Fish tempBAIndividual) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        BitSet tmpBitSet = (BitSet)temp.X.clone();
        tmpBitSet.xor(tempBAIndividual.X);
        int i = 0;
        while (i < tmpBitSet.length()) {
            if (tmpBitSet.get(i)) {
                list.add(i);
            }
            ++i;
        }
        return list;
    }

    private void addHuiBA(Fish tempBAIndividual) {
        Fish tmpBAIndividual = new Fish();
        tmpBAIndividual.copyFish(tempBAIndividual);
        if (this.huiBA.size() != 0) {
            int i = 0;
            while (i < this.huiBA.size()) {
                BitSet tmpBitSet = (BitSet)tmpBAIndividual.X.clone();
                tmpBitSet.xor(this.huiBA.get((int)i).X);
                if (tmpBitSet.cardinality() == 0) {
                    return;
                }
                ++i;
            }
        }
        this.huiBA.add(tmpBAIndividual);
    }

    private List<Double> roulettePercentHUIBA() {
        double sum = 0.0;
        double tempsum = 0.0;
        double percent = 0.0;
        ArrayList<Double> percentHUIBA = new ArrayList<Double>();
        int i = 0;
        while (i < this.huiBA.size()) {
            sum += (double)this.huiBA.get((int)i).fitness;
            ++i;
        }
        i = 0;
        while (i < this.huiBA.size()) {
            percent = (tempsum += (double)this.huiBA.get((int)i).fitness) / sum;
            percentHUIBA.add(percent);
            ++i;
        }
        return percentHUIBA;
    }

    private int rouletteSelectHUIBA(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void insert(Fish tempParticle) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.X.get(i)) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
            }
        }
    }

    private List<Double> roulettePercent() {
        double sum = 0.0;
        double tempSum = 0.0;
        int i = 0;
        while (i < this.twuPattern.size()) {
            sum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue();
            ++i;
        }
        i = 0;
        while (i < this.twuPattern.size()) {
            double tempPercent = (tempSum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue()) / (sum + 0.0);
            this.percentage.add(tempPercent);
            ++i;
        }
        return this.percentage;
    }

    private int rouletteSelect(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.huiSets.size()) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            buffer.append(System.lineSeparator());
            ++i;
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIM-AF ALGORITHM v.2.50 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class Fish
    implements Comparable {
        BitSet X;
        int fitness;

        public Fish() {
            this.X = new BitSet(AlgoHUIM_AF.this.twuPattern.size());
        }

        public Fish(int length) {
            this.X = new BitSet(length);
        }

        public void copyFish(Fish fish1) {
            this.X = (BitSet)fish1.X.clone();
            this.fitness = fish1.fitness;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            int m = 0;
            while (m < templist.size()) {
                int p = templist.get(m);
                int i = 0;
                int q = 0;
                int temp = 0;
                int sum = 0;
                while (q < AlgoHUIM_AF.this.database.get(p).size() && i < this.X.length()) {
                    if (this.X.get(i)) {
                        if (AlgoHUIM_AF.this.database.get((int)p).get((int)q).item == AlgoHUIM_AF.this.twuPattern.get(i)) {
                            sum += AlgoHUIM_AF.this.database.get((int)p).get((int)q).utility;
                            ++i;
                            ++q;
                            ++temp;
                            continue;
                        }
                        ++q;
                        continue;
                    }
                    ++i;
                }
                if (temp == k) {
                    fitness += sum;
                }
                ++m;
            }
            this.fitness = fitness;
        }

        public int compareTo(Object o) {
            return -(this.fitness - ((Fish)o).fitness);
        }
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item() {
            this.TIDS = new BitSet(AlgoHUIM_AF.this.transactionCount);
        }

        public Item(int item) {
            this.TIDS = new BitSet(AlgoHUIM_AF.this.transactionCount);
            this.item = item;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

