/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.itemsettree;

import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.AssociationRuleIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.HashTableIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.ItemsetTreeNode;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

abstract class AbstractItemsetTree {
    ItemsetTreeNode root = null;
    int nodeCount;
    long totalItemCountInNodes;
    long startTimestamp;
    long endTimestamp;

    AbstractItemsetTree() {
    }

    protected int[] getLargestCommonAncestor(int[] itemset1, int[] itemset2) {
        if (itemset2 == null || itemset1 == null) {
            return null;
        }
        int minI = itemset1.length < itemset2.length ? itemset1.length : itemset2.length;
        int count = 0;
        int i = 0;
        while (i < minI) {
            if (itemset1[i] != itemset2[i]) break;
            ++count;
            ++i;
        }
        if (count > 0 && count < minI) {
            int[] common = new int[count];
            System.arraycopy(itemset1, 0, common, 0, count);
            return common;
        }
        return null;
    }

    protected boolean ancestorOf(int[] itemset1, int[] itemset2) {
        if (itemset2 == null) {
            return false;
        }
        if (itemset1 == null) {
            return true;
        }
        if (itemset1.length >= itemset2.length) {
            return false;
        }
        int i = 0;
        while (i < itemset1.length) {
            if (itemset1[i] != itemset2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean same(int[] itemset1, int[] itemset2) {
        if (itemset2 == null || itemset1 == null) {
            return false;
        }
        if (itemset1.length != itemset2.length) {
            return false;
        }
        int i = 0;
        while (i < itemset1.length) {
            if (itemset1[i] != itemset2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public HashTableIT getFrequentItemsetSubsuming(int[] is, int minsup) {
        HashTableIT hashTable = this.getFrequentItemsetSubsuming(is);
        List<Itemset>[] listArray = hashTable.table;
        int n = hashTable.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<Itemset> list = listArray[n2];
            if (list != null) {
                Iterator<Itemset> it = list.iterator();
                while (it.hasNext()) {
                    Itemset itemset2 = it.next();
                    if (itemset2.support >= minsup) continue;
                    it.remove();
                }
            }
            ++n2;
        }
        return hashTable;
    }

    protected abstract HashTableIT getFrequentItemsetSubsuming(int[] var1);

    public List<AssociationRuleIT> generateRules(int[] s, int minsup, double minconf) {
        ArrayList<AssociationRuleIT> rules = new ArrayList<AssociationRuleIT>();
        HashSet<Integer> seti = new HashSet<Integer>();
        int i = 0;
        while (i < s.length) {
            seti.add(s[i]);
            ++i;
        }
        int suppS = this.getSupportOfItemset(s);
        HashTableIT frequentItemsets = this.getFrequentItemsetSubsuming(s, minsup);
        List<Itemset>[] listArray = frequentItemsets.table;
        int n = frequentItemsets.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<Itemset> list = listArray[n2];
            if (list != null) {
                for (Itemset c : list) {
                    if (c.size() == s.length) continue;
                    int[] l = new int[c.itemset.length - s.length];
                    int pos = 0;
                    int[] nArray = c.itemset;
                    int n3 = c.itemset.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Integer item = nArray[n4];
                        if (!seti.contains(item)) {
                            l[pos++] = item;
                        }
                        ++n4;
                    }
                    int suppC = this.getSupportOfItemset(c.itemset);
                    double conf = (double)suppC / (double)suppS;
                    if (!(conf >= minconf)) continue;
                    AssociationRuleIT rule = new AssociationRuleIT();
                    rule.itemset1 = s;
                    rule.itemset2 = l;
                    rule.support = suppC;
                    rule.confidence = conf;
                    rules.add(rule);
                }
            }
            ++n2;
        }
        return rules;
    }

    public abstract int getSupportOfItemset(int[] var1);
}

