/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.itemsettree;

import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.AbstractItemsetTree;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.HashTableIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.ItemsetTreeNode;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;

public class ItemsetTree
extends AbstractItemsetTree
implements Serializable {
    public void buildTree(String input) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.root = new ItemsetTreeNode(null, 0);
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int[] itemset2 = new int[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                itemset2[i] = Integer.parseInt(lineSplited[i]);
                ++i;
            }
            this.construct(null, this.root, itemset2);
        }
        reader.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void addTransaction(int[] transaction) {
        this.construct(null, this.root, transaction);
    }

    private void construct(ItemsetTreeNode parentOfR, ItemsetTreeNode r, int[] s) {
        int[] sr = r.itemset;
        if (this.same(s, sr)) {
            ++r.support;
            return;
        }
        if (this.ancestorOf(s, sr)) {
            ItemsetTreeNode newNode = new ItemsetTreeNode(s, r.support + 1);
            newNode.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNode);
            return;
        }
        int[] l = this.getLargestCommonAncestor(s, sr);
        if (l != null) {
            ItemsetTreeNode newNode = new ItemsetTreeNode(l, r.support + 1);
            newNode.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNode);
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(s, 1);
            newNode.childs.add(newNode2);
            return;
        }
        int indexLastItemOfR = sr == null ? 0 : sr.length;
        ++r.support;
        for (ItemsetTreeNode ci : r.childs) {
            if (this.same(s, ci.itemset)) {
                ++ci.support;
                return;
            }
            if (this.ancestorOf(s, ci.itemset)) {
                ItemsetTreeNode newNode = new ItemsetTreeNode(s, ci.support + 1);
                newNode.childs.add(ci);
                r.childs.remove(ci);
                r.childs.add(newNode);
                return;
            }
            if (this.ancestorOf(ci.itemset, s)) {
                this.construct(r, ci, s);
                return;
            }
            if (ci.itemset[indexLastItemOfR] != s[indexLastItemOfR]) continue;
            int[] ancestor = this.getLargestCommonAncestor(s, ci.itemset);
            ItemsetTreeNode newNode = new ItemsetTreeNode(ancestor, ci.support + 1);
            r.childs.add(newNode);
            newNode.childs.add(ci);
            r.childs.remove(ci);
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(s, 1);
            newNode.childs.add(newNode2);
            return;
        }
        ItemsetTreeNode newNode = new ItemsetTreeNode(s, 1);
        r.childs.add(newNode);
    }

    public void printStatistics() {
        System.out.println("========== ITEMSET TREE CONSTRUCTION - STATS ============");
        System.out.println(" Tree construction time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        this.nodeCount = 0;
        this.totalItemCountInNodes = 0L;
        this.recursiveStats(this.root);
        System.out.println(" Node count: " + this.nodeCount);
        System.out.println(" Sum of items in all node: " + this.totalItemCountInNodes + " avg per node :" + (double)this.totalItemCountInNodes / (double)this.nodeCount);
        System.out.println("=====================================");
    }

    private void recursiveStats(ItemsetTreeNode root) {
        if (root != null && root.itemset != null) {
            ++this.nodeCount;
            this.totalItemCountInNodes += (long)root.itemset.length;
        }
        for (ItemsetTreeNode node : root.childs) {
            this.recursiveStats(node);
        }
    }

    public void printTree() {
        System.out.println(this.root.toString(new StringBuilder(), ""));
    }

    public String toString() {
        return this.root.toString(new StringBuilder(), "");
    }

    @Override
    public int getSupportOfItemset(int[] s) {
        return this.count(s, this.root);
    }

    private int count(int[] s, ItemsetTreeNode root) {
        int count = 0;
        for (ItemsetTreeNode ci : root.childs) {
            if (ci.itemset[0] > s[0]) continue;
            if (this.includedIn(s, ci.itemset)) {
                count += ci.support;
                continue;
            }
            if (ci.itemset[ci.itemset.length - 1] >= s[s.length - 1]) continue;
            count += this.count(s, ci);
        }
        return count;
    }

    private boolean includedIn(int[] itemset1, int[] itemset2) {
        int count = 0;
        int i = 0;
        while (i < itemset2.length) {
            if (itemset2[i] == itemset1[count] && ++count == itemset1.length) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public HashTableIT getFrequentItemsetSubsuming(int[] s) {
        HashTableIT hash = new HashTableIT(1000);
        HashSet<Integer> seti = new HashSet<Integer>();
        int i = 0;
        while (i < s.length) {
            seti.add(s[i]);
            ++i;
        }
        this.selectiveMining(s, seti, this.root, hash);
        return hash;
    }

    private int selectiveMining(int[] s, HashSet<Integer> seti, ItemsetTreeNode t, HashTableIT hash) {
        int childrenSup = 0;
        for (ItemsetTreeNode ci : t.childs) {
            childrenSup += ci.support;
            if (ci.itemset[0] > s[0]) continue;
            if (this.includedIn(s, ci.itemset)) {
                if (ci.childs.size() == 0) {
                    hash.put(s, ci.support);
                    this.recursiveAdd(s, seti, ci.itemset, ci.support, hash, 0);
                    continue;
                }
                int remainingSup = ci.support - this.selectiveMining(s, seti, ci, hash);
                if (remainingSup <= 0) continue;
                hash.put(s, remainingSup);
                this.recursiveAdd(s, seti, ci.itemset, remainingSup, hash, 0);
                continue;
            }
            if (ci.itemset[ci.itemset.length - 1] >= s[s.length - 1]) continue;
            this.selectiveMining(s, seti, ci, hash);
        }
        return childrenSup;
    }

    private void recursiveAdd(int[] s, HashSet<Integer> seti, int[] ci, int cisupport, HashTableIT hash, int pos) {
        if (pos >= ci.length) {
            return;
        }
        if (!seti.contains(ci[pos])) {
            int[] newS = new int[s.length + 1];
            int j = 0;
            boolean added = false;
            int[] nArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                Integer item = nArray[n2];
                if (added || item < ci[pos]) {
                    newS[j++] = item;
                } else {
                    newS[j++] = ci[pos];
                    newS[j++] = item;
                    added = true;
                }
                ++n2;
            }
            if (j < s.length + 1) {
                newS[j++] = ci[pos];
            }
            hash.put(newS, cisupport);
            this.recursiveAdd(newS, seti, ci, cisupport, hash, pos + 1);
        }
        this.recursiveAdd(s, seti, ci, cisupport, hash, pos + 1);
    }
}

