/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.itemsettree;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.AbstractItemsetTree;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.HashTableIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.ItemsetTreeNode;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MemoryEfficientItemsetTree
extends AbstractItemsetTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    long sumBranchesLength;
    int totalNumberOfBranches;

    public void buildTree(String input) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.root = new ItemsetTreeNode(null, 0);
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int[] itemset2 = new int[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                itemset2[i] = Integer.parseInt(lineSplited[i]);
                ++i;
            }
            this.construct(null, this.root, itemset2, null);
        }
        reader.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void addTransaction(int[] transaction) {
        this.construct(null, this.root, transaction, null);
    }

    private void construct(ItemsetTreeNode parentOfR, ItemsetTreeNode r, int[] s, int[] prefix) {
        if (this.same(s, prefix, r.itemset)) {
            ++r.support;
            return;
        }
        int[] rprefix = this.append(prefix, r.itemset);
        if (this.ancestorOf(s, rprefix)) {
            int[] sprime = this.copyItemsetWithoutItemsFrom(s, prefix);
            int[] rprime = this.copyItemsetWithoutItemsFrom(rprefix, sprime);
            ItemsetTreeNode newNodeS = new ItemsetTreeNode(sprime, r.support + 1);
            newNodeS.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNodeS);
            r.itemset = rprime;
            return;
        }
        int[] l = this.getLargestCommonAncestor(s, rprefix);
        if (l != null) {
            int[] sprime = this.copyItemsetWithoutItemsFrom(s, l);
            int[] rprime = this.copyItemsetWithoutItemsFrom(r.itemset, l);
            ItemsetTreeNode newNode = new ItemsetTreeNode(l, r.support + 1);
            newNode.childs.add(r);
            parentOfR.childs.remove(r);
            parentOfR.childs.add(newNode);
            r.itemset = rprime;
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(sprime, 1);
            newNode.childs.add(newNode2);
            return;
        }
        int indexLastItemOfR = rprefix == null ? 0 : rprefix.length;
        ++r.support;
        for (ItemsetTreeNode ci : r.childs) {
            int[] ciprefix = this.append(rprefix, ci.itemset);
            if (this.same(s, ciprefix)) {
                ++ci.support;
                return;
            }
            if (this.ancestorOf(s, ciprefix)) {
                int[] sprime = this.copyItemsetWithoutItemsFrom(s, rprefix);
                int[] ciprime = this.copyItemsetWithoutItemsFrom(ci.itemset, s);
                ItemsetTreeNode newNode = new ItemsetTreeNode(sprime, ci.support + 1);
                newNode.childs.add(ci);
                r.childs.remove(ci);
                r.childs.add(newNode);
                ci.itemset = ciprime;
                return;
            }
            if (this.ancestorOf(ciprefix, s)) {
                this.construct(r, ci, s, rprefix);
                return;
            }
            if (ciprefix[indexLastItemOfR] != s[indexLastItemOfR]) continue;
            int[] ancestor = this.getLargestCommonAncestor(s, ciprefix);
            int[] ancestorprime = this.copyItemsetWithoutItemsFrom(ancestor, rprefix);
            ItemsetTreeNode newNode = new ItemsetTreeNode(ancestorprime, ci.support + 1);
            r.childs.add(newNode);
            ci.itemset = this.copyItemsetWithoutItemsFrom(ci.itemset, ancestorprime);
            newNode.childs.add(ci);
            r.childs.remove(ci);
            int[] sprime = this.copyItemsetWithoutItemsFromArrays(s, ancestorprime, rprefix);
            ItemsetTreeNode newNode2 = new ItemsetTreeNode(sprime, 1);
            newNode.childs.add(newNode2);
            return;
        }
        int[] sprime = this.copyItemsetWithoutItemsFrom(s, rprefix);
        ItemsetTreeNode newNode = new ItemsetTreeNode(sprime, 1);
        r.childs.add(newNode);
    }

    private int[] copyItemsetWithoutItemsFromArrays(int[] r, int[] prefix, int[] s) {
        ArrayList<Integer> rprime = new ArrayList<Integer>(r.length);
        int[] nArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int[] nArray2;
            Integer rvalue = nArray[n2];
            if (prefix != null) {
                nArray2 = prefix;
                n4 = prefix.length;
                n3 = 0;
                while (n3 < n4) {
                    int pvalue = nArray2[n3];
                    if (pvalue != rvalue) {
                        if (pvalue > rvalue) break;
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else if (s != null) {
                nArray2 = s;
                n4 = s.length;
                n3 = 0;
                while (n3 < n4) {
                    int svalue = nArray2[n3];
                    if (rvalue != svalue) {
                        if (svalue > rvalue) break;
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else {
                rprime.add(rvalue);
            }
            ++n2;
        }
        int[] rprimeArray = new int[rprime.size()];
        int i = 0;
        while (i < rprime.size()) {
            rprimeArray[i] = (Integer)rprime.get(i);
            ++i;
        }
        return rprimeArray;
    }

    private int[] copyItemsetWithoutItemsFrom(int[] itemset1, int[] itemset2) {
        if (itemset2 == null) {
            return itemset1;
        }
        ArrayList<Integer> itemset1prime = new ArrayList<Integer>(itemset1.length);
        int[] nArray = itemset1;
        int n = itemset1.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                int i1value = nArray[n2];
                int[] nArray2 = itemset2;
                int n3 = itemset2.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i2value = nArray2[n4];
                    if (i2value != i1value) {
                        if (i2value > i1value) break;
                        ++n4;
                        continue;
                    }
                    break block5;
                }
                itemset1prime.add(i1value);
            }
            ++n2;
        }
        int[] itemset1primeArray = new int[itemset1prime.size()];
        int i = 0;
        while (i < itemset1prime.size()) {
            itemset1primeArray[i] = (Integer)itemset1prime.get(i);
            ++i;
        }
        return itemset1primeArray;
    }

    private boolean same(int[] itemset1, int[] prefix, int[] itemset2) {
        if (prefix == null) {
            return this.same(itemset1, itemset2);
        }
        if (itemset2 == null || itemset1 == null) {
            return false;
        }
        if (itemset1.length != itemset2.length + prefix.length) {
            return false;
        }
        int i = 0;
        while (i < prefix.length) {
            if (itemset1[i] != prefix[i]) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < itemset2.length) {
            if (itemset1[j++] == itemset2[i++]) continue;
            return false;
        }
        return true;
    }

    public int[] append(int[] a1, int[] a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        int[] newArray = new int[a1.length + a2.length];
        int i = 0;
        while (i < a1.length) {
            newArray[i] = a1[i];
            ++i;
        }
        int j = 0;
        while (j < a2.length) {
            newArray[i++] = a2[j];
            ++j;
        }
        return newArray;
    }

    public void printStatistics() {
        System.gc();
        System.out.println("========== MEMORY EFFICIENT ITEMSET TREE CONSTRUCTION - STATS ============");
        System.out.println(" Tree construction time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        this.nodeCount = 0;
        this.totalItemCountInNodes = 0L;
        this.sumBranchesLength = 0L;
        this.totalNumberOfBranches = 0;
        this.recursiveStats(this.root, 1);
        System.out.println(" Node count: " + this.nodeCount);
        System.out.println(" Sum of items in all node: " + this.totalItemCountInNodes + " avg per node :" + (double)this.totalItemCountInNodes / (double)this.nodeCount);
        System.out.println("=====================================");
    }

    private void recursiveStats(ItemsetTreeNode root, int length) {
        if (root != null && root.itemset != null) {
            ++this.nodeCount;
            this.totalItemCountInNodes += (long)root.itemset.length;
        }
        for (ItemsetTreeNode node : root.childs) {
            this.recursiveStats(node, ++length);
        }
        if (root.childs.size() == 0) {
            this.sumBranchesLength += (long)length;
            ++this.totalNumberOfBranches;
        }
    }

    public void printTree() {
        System.out.println(this.root.toString(new StringBuilder(), ""));
    }

    public String toString() {
        return this.root.toString(new StringBuilder(), "");
    }

    @Override
    public int getSupportOfItemset(int[] s) {
        return this.count(s, this.root, new int[0]);
    }

    private int count(int[] s, ItemsetTreeNode root, int[] prefix) {
        int count = 0;
        for (ItemsetTreeNode ci : root.childs) {
            int[] ciprefix = this.append(prefix, ci.itemset);
            if (ciprefix[0] > s[0]) continue;
            if (ArraysAlgos.includedIn(s, ciprefix)) {
                count += ci.support;
                continue;
            }
            if (ciprefix[ciprefix.length - 1] >= s[s.length - 1]) continue;
            count += this.count(s, ci, ciprefix);
        }
        return count;
    }

    @Override
    public HashTableIT getFrequentItemsetSubsuming(int[] is, int minsup) {
        HashTableIT hashTable = this.getFrequentItemsetSubsuming(is);
        List<Itemset>[] listArray = hashTable.table;
        int n = hashTable.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<Itemset> list = listArray[n2];
            if (list != null) {
                Iterator<Itemset> it = list.iterator();
                while (it.hasNext()) {
                    Itemset itemset2 = it.next();
                    if (itemset2.support >= minsup) continue;
                    it.remove();
                }
            }
            ++n2;
        }
        return hashTable;
    }

    @Override
    public HashTableIT getFrequentItemsetSubsuming(int[] s) {
        HashTableIT hash = new HashTableIT(1000);
        HashSet<Integer> seti = new HashSet<Integer>();
        int i = 0;
        while (i < s.length) {
            seti.add(s[i]);
            ++i;
        }
        this.selectiveMining(s, seti, this.root, hash, null);
        return hash;
    }

    private int selectiveMining(int[] s, HashSet<Integer> seti, ItemsetTreeNode t, HashTableIT hash, int[] prefix) {
        int childrenSup = 0;
        for (ItemsetTreeNode ci : t.childs) {
            childrenSup += ci.support;
            int[] ciprefix = this.append(prefix, ci.itemset);
            if (ciprefix[0] > s[0]) continue;
            if (ArraysAlgos.includedIn(s, ciprefix)) {
                if (ci.childs.size() == 0) {
                    hash.put(s, ci.support);
                    this.recursiveAdd(s, seti, ciprefix, ci.support, hash, 0);
                    continue;
                }
                int remainingSup = ci.support - this.selectiveMining(s, seti, ci, hash, ciprefix);
                if (remainingSup <= 0) continue;
                hash.put(s, remainingSup);
                this.recursiveAdd(s, seti, ciprefix, remainingSup, hash, 0);
                continue;
            }
            if (ciprefix[ciprefix.length - 1] >= s[s.length - 1]) continue;
            this.selectiveMining(s, seti, ci, hash, ciprefix);
        }
        return childrenSup;
    }

    private void recursiveAdd(int[] s, HashSet<Integer> seti, int[] ci, int cisupport, HashTableIT hash, int pos) {
        if (pos >= ci.length) {
            return;
        }
        if (!seti.contains(ci[pos])) {
            int[] newS = new int[s.length + 1];
            int j = 0;
            boolean added = false;
            int[] nArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                Integer item = nArray[n2];
                if (added || item < ci[pos]) {
                    newS[j++] = item;
                } else {
                    newS[j++] = ci[pos];
                    newS[j++] = item;
                    added = true;
                }
                ++n2;
            }
            if (j < s.length + 1) {
                newS[j++] = ci[pos];
            }
            hash.put(newS, cisupport);
            this.recursiveAdd(newS, seti, ci, cisupport, hash, pos + 1);
        }
        this.recursiveAdd(s, seti, ci, cisupport, hash, pos + 1);
    }
}

