/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lcm;

import ca.pfv.spmf.algorithms.frequentpatterns.lcm.Dataset;
import ca.pfv.spmf.algorithms.frequentpatterns.lcm.Transaction;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AlgoLCMFreq {
    private Itemsets frequentItemsets;
    BufferedWriter writer = null;
    private int frequentCount;
    long startTimestamp;
    long endTimestamp;
    int minsupRelative;
    final int BUFFERS_SIZE = 1000;
    private int[] itemsetBuffer = null;
    private int[] itemsetOutputBuffer = null;
    private List<Transaction>[] buckets;
    int maxItemsetSize = Integer.MAX_VALUE;

    public Itemsets runAlgorithm(double minimumSupport, Dataset dataset, String outputPath) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        if (outputPath != null) {
            this.writer = new BufferedWriter(new FileWriter(outputPath));
            this.itemsetOutputBuffer = new int[1000];
        } else {
            this.writer = null;
            this.frequentItemsets = new Itemsets("Itemsets");
        }
        this.itemsetBuffer = new int[1000];
        this.frequentCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsupRelative = (int)Math.ceil(minimumSupport * (double)dataset.getTransactions().size());
        if (this.maxItemsetSize >= 1) {
            this.performFirstOccurenceDelivery(dataset);
            for (Transaction transaction : dataset.getTransactions()) {
                transaction.removeInfrequentItems(this.buckets, this.minsupRelative);
            }
            ArrayList<Integer> allItems = new ArrayList<Integer>();
            for (Integer item : dataset.getUniqueItems()) {
                if (this.buckets[item].size() < this.minsupRelative || this.maxItemsetSize < 1) continue;
                allItems.add(item);
            }
            Collections.sort(allItems);
            this.backtrackingLCMFreq(this.itemsetBuffer, 0, dataset.getTransactions(), allItems);
        }
        this.endTimestamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        return this.frequentItemsets;
    }

    private void backtrackingLCMFreq(int[] p, int pLength, List<Transaction> transactionsOfP, List<Integer> frequentItems) throws IOException {
        int j = 0;
        while (j < frequentItems.size()) {
            Integer e = frequentItems.get(j);
            List<Transaction> transactionsPe = this.intersectTransactions(transactionsOfP, e);
            p[pLength] = e;
            int supportPe = transactionsPe.size();
            this.output(p, pLength + 1, supportPe);
            if (pLength + 2 <= this.maxItemsetSize) {
                this.anyTimeDatabaseReductionFreq(transactionsPe, j, frequentItems, p, pLength, e);
                ArrayList<Integer> newFrequentItems = new ArrayList<Integer>();
                int k = j + 1;
                while (k < frequentItems.size()) {
                    Integer itemK = frequentItems.get(k);
                    int supportK = this.buckets[itemK].size();
                    if (supportK >= this.minsupRelative) {
                        newFrequentItems.add(itemK);
                    }
                    ++k;
                }
                this.backtrackingLCMFreq(p, pLength + 1, transactionsPe, newFrequentItems);
            }
            ++j;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void performFirstOccurenceDelivery(Dataset dataset) {
        this.buckets = new List[dataset.getMaxItem() + 1];
        for (Integer item : dataset.uniqueItems) {
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
        }
        for (Transaction transaction : dataset.getTransactions()) {
            Integer[] integerArray = transaction.getItems();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer item = integerArray[n2];
                this.buckets[item].add(transaction);
                ++n2;
            }
        }
    }

    private void anyTimeDatabaseReductionFreq(List<Transaction> transactionsPe, int j, List<Integer> frequentItems, int[] itemset2, int itemsetLength, Integer e) {
        int i = j + 1;
        while (i < frequentItems.size()) {
            Integer item = frequentItems.get(i);
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
            ++i;
        }
        for (Transaction transaction : transactionsPe) {
            int i2 = transaction.getItems().length - 1;
            while (i2 > transaction.offset) {
                Integer item = transaction.getItems()[i2];
                if (frequentItems.contains(item)) {
                    this.buckets[item].add(transaction);
                }
                --i2;
            }
        }
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item, int searchAfterPosition) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = searchAfterPosition + 1;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = 0;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public boolean containsByBinarySearch(int[] items, int item, int start, int end) {
        int low = start;
        int high = end;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items[middle] == item) {
                return true;
            }
            if (items[middle] < item) {
                low = middle + 1;
            }
            if (items[middle] <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public List<Transaction> intersectTransactions(List<Transaction> transactionsOfP, Integer e) {
        ArrayList<Transaction> transactionsPe = new ArrayList<Transaction>();
        for (Transaction transaction : transactionsOfP) {
            int posE = transaction.containsByBinarySearch(e);
            if (posE == -1) continue;
            transactionsPe.add(new Transaction(transaction, posE));
        }
        return transactionsPe;
    }

    private void output(int[] itemset2, int itemsetLength, int support) throws IOException {
        ++this.frequentCount;
        if (this.writer != null) {
            System.arraycopy(itemset2, 0, this.itemsetOutputBuffer, 0, itemsetLength);
            Arrays.sort(this.itemsetOutputBuffer, 0, itemsetLength);
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < itemsetLength) {
                buffer.append(this.itemsetOutputBuffer[i]);
                if (i != itemsetLength - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            int[] itemsetArray = new int[itemsetLength];
            System.arraycopy(itemset2, 0, itemsetArray, 0, itemsetLength);
            Arrays.sort(itemsetArray);
            Itemset itemsetObj = new Itemset(itemsetArray);
            itemsetObj.setAbsoluteSupport(support);
            this.frequentItemsets.addItemset(itemsetObj, itemsetLength);
        }
    }

    public void printStats() {
        System.out.println("========== LCMFreq v0.96r18 - STATS ============");
        System.out.println(" Freq. itemsets count: " + this.frequentCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxItemsetSize = length;
    }
}

