/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth.LPPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth.TimeIntervals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LPPTree {
    List<Integer> headerList = null;
    Map<Integer, LPPNode> mapItemNodes = new HashMap<Integer, LPPNode>();
    Map<Integer, LPPNode> mapItemLastNode = new HashMap<Integer, LPPNode>();
    LPPNode root = new LPPNode();

    public void addTransaction(List<Integer> transaction, int timestamp) {
        LPPNode currentNode = this.root;
        for (Integer item : transaction) {
            LPPNode child = currentNode.getChildByID(item);
            if (child == null) {
                LPPNode newNode = new LPPNode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            currentNode = child;
        }
        currentNode.timestamps.add(timestamp);
    }

    private void fixNodeLinks(Integer item, LPPNode newNode) {
        LPPNode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        LPPNode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    void createHeaderList(List<Integer> lastHeaderList, final Map<Integer, TimeIntervals> mapTimeIntervals) {
        if (lastHeaderList == null) {
            this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
            Collections.sort(this.headerList, new Comparator<Integer>(){

                @Override
                public int compare(Integer item1, Integer item2) {
                    int compare = ((TimeIntervals)mapTimeIntervals.get(item2)).getTotalDuration() - ((TimeIntervals)mapTimeIntervals.get(item1)).getTotalDuration();
                    if (compare == 0) {
                        return item1 - item2;
                    }
                    return compare;
                }
            });
        } else {
            this.headerList = new ArrayList<Integer>();
            for (int item : lastHeaderList) {
                if (!mapTimeIntervals.containsKey(item)) continue;
                this.headerList.add(item);
            }
        }
    }

    public void addPrefixPath(List<LPPNode> prefixPath, Map<Integer, TimeIntervals> mapBetaTimeIntervals) {
        List<Integer> pathTimestamps = prefixPath.get((int)0).timestamps;
        LPPNode currentNode = this.root;
        int i = prefixPath.size() - 1;
        while (i >= 1) {
            LPPNode pathItem = prefixPath.get(i);
            if (mapBetaTimeIntervals.containsKey(pathItem.itemID)) {
                LPPNode child = currentNode.getChildByID(pathItem.itemID);
                if (child == null) {
                    LPPNode newNode = new LPPNode();
                    newNode.itemID = pathItem.itemID;
                    newNode.parent = currentNode;
                    currentNode.childs.add(newNode);
                    currentNode = newNode;
                    this.fixNodeLinks(pathItem.itemID, newNode);
                } else {
                    currentNode = child;
                }
            }
            --i;
        }
        if (currentNode.itemID != -1) {
            currentNode.timestamps.addAll(pathTimestamps);
        }
    }

    public void removeTailItem() {
        int tail = this.headerList.size() - 1;
        LPPNode tailNode = this.mapItemNodes.get(this.headerList.get(tail));
        this.mapItemNodes.remove(this.headerList.get(tail));
        this.headerList.remove(tail);
        while (tailNode != null) {
            LPPNode parent = tailNode.parent;
            parent.removeChildByID(tailNode.itemID);
            if (parent.itemID != -1) {
                List<Integer> timestamps = tailNode.timestamps;
                parent.timestamps.addAll((Collection<Integer>)new ArrayList<Integer>(timestamps){
                    {
                        this.addAll(list);
                    }
                });
            }
            tailNode = tailNode.nodeLink;
        }
    }
}

