/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lppm;

import ca.pfv.spmf.algorithms.frequentpatterns.lppm.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.lppm.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AlgoLPPMBreadth2 {
    private int maxPer;
    private int minDur;
    private int maxSoPer;
    BufferedWriter writer = null;
    private long intersectionCount = 0L;
    protected Itemsets patterns = null;
    private int largestTs;
    private boolean selfIncrement;
    private int itemsetCount;
    private long startTimestamp;
    private long endTime;

    public Itemsets runAlgorithm(String input, String output, int maxPer, int minDur, int maxSoPer, boolean selfIncrement) throws IOException {
        MemoryLogger.getInstance().reset();
        this.maxPer = maxPer;
        this.minDur = minDur;
        this.maxSoPer = maxSoPer;
        this.selfIncrement = selfIncrement;
        this.intersectionCount = 0L;
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("Local Periodic Pattern");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.startTimestamp = System.currentTimeMillis();
        Map<Integer, BitSet> mapItemTS = this.convertTimeStamps(input);
        ArrayList<Integer> lpp1 = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, BitSet>> it = mapItemTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BitSet> entry = it.next();
            if (!this.generatePattern(entry, 1)) {
                it.remove();
                continue;
            }
            lpp1.add(entry.getKey());
        }
        Collections.sort(lpp1);
        LinkedHashMap<int[], ArrayList<Integer>> combinationMap = this.generateCandidate2(lpp1, mapItemTS);
        while ((combinationMap = this.generateCandidateK(combinationMap, mapItemTS)).size() > 0) {
        }
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private LinkedHashMap<int[], ArrayList<Integer>> generateCandidateK(LinkedHashMap<int[], ArrayList<Integer>> combinationMap, Map<Integer, BitSet> mapItemTS) throws IOException {
        LinkedHashMap<int[], ArrayList<Integer>> newCombinationMap = new LinkedHashMap<int[], ArrayList<Integer>>();
        for (Map.Entry<int[], ArrayList<Integer>> entry : combinationMap.entrySet()) {
            int len = entry.getValue().size();
            if (len <= 1) continue;
            if (len == 2) {
                int itemI = entry.getValue().get(0);
                int itemJ = entry.getValue().get(1);
                BitSet bitSetIJ = (BitSet)mapItemTS.get(itemI).clone();
                bitSetIJ.and(mapItemTS.get(itemJ));
                ++this.intersectionCount;
                int[] prefix = new int[entry.getKey().length + 2];
                int m = 0;
                while (m < entry.getKey().length) {
                    prefix[m] = entry.getKey()[m];
                    bitSetIJ.and(mapItemTS.get(prefix[m]));
                    ++this.intersectionCount;
                    ++m;
                }
                ArrayList<int[]> timeIntervals = this.bitset2intervals(bitSetIJ);
                if (timeIntervals.size() <= 0) continue;
                prefix[entry.getKey().length] = itemI;
                prefix[entry.getKey().length + 1] = itemJ;
                this.save(prefix, timeIntervals, prefix.length);
                continue;
            }
            int[] prefix = new int[entry.getKey().length + 2];
            BitSet bitSetPrefix = (BitSet)mapItemTS.get(entry.getKey()[0]).clone();
            prefix[0] = entry.getKey()[0];
            int m = 1;
            while (m < entry.getKey().length) {
                prefix[m] = entry.getKey()[m];
                bitSetPrefix.and(mapItemTS.get(entry.getKey()[m]));
                ++this.intersectionCount;
                ++m;
            }
            int i = 0;
            while (i < len - 1) {
                int itemI = entry.getValue().get(i);
                BitSet bitSetI = (BitSet)mapItemTS.get(itemI).clone();
                bitSetI.and(bitSetPrefix);
                ++this.intersectionCount;
                prefix[entry.getKey().length] = itemI;
                int[] head = new int[entry.getKey().length + 1];
                System.arraycopy(prefix, 0, head, 0, entry.getKey().length + 1);
                int j = i + 1;
                while (j < len) {
                    int itemJ = entry.getValue().get(j);
                    BitSet bitSetIJ = (BitSet)mapItemTS.get(itemJ).clone();
                    bitSetIJ.and(bitSetI);
                    ++this.intersectionCount;
                    ArrayList<int[]> timeIntervals = this.bitset2intervals(bitSetIJ);
                    if (timeIntervals.size() > 0) {
                        prefix[entry.getKey().length + 1] = itemJ;
                        this.save((int[])prefix.clone(), timeIntervals, prefix.length);
                        if (newCombinationMap.containsKey(head)) {
                            newCombinationMap.get(head).add(itemJ);
                        } else {
                            newCombinationMap.put(head, new ArrayList<Integer>(itemJ){
                                {
                                    this.add(n);
                                }
                            });
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return newCombinationMap;
    }

    private LinkedHashMap<int[], ArrayList<Integer>> generateCandidate2(ArrayList<Integer> lpp1, Map<Integer, BitSet> mapItemTS) throws IOException {
        LinkedHashMap<int[], ArrayList<Integer>> newConbinationMap = new LinkedHashMap<int[], ArrayList<Integer>>();
        int i = 0;
        while (i < lpp1.size() - 1) {
            int itemI = lpp1.get(i);
            BitSet bitSetI = mapItemTS.get(itemI);
            int[] head = new int[]{itemI};
            int j = i + 1;
            while (j < lpp1.size()) {
                int itemJ = lpp1.get(j);
                BitSet bitSetIJ = (BitSet)mapItemTS.get(itemJ).clone();
                bitSetIJ.and(bitSetI);
                ++this.intersectionCount;
                ArrayList<int[]> timeIntervals = this.bitset2intervals(bitSetIJ);
                if (timeIntervals.size() > 0) {
                    int[] itemName = new int[]{itemI, itemJ};
                    this.save(itemName, timeIntervals, 2);
                    if (!newConbinationMap.containsKey(head)) {
                        newConbinationMap.put(head, new ArrayList<Integer>(itemJ){
                            {
                                this.add(n);
                            }
                        });
                    } else {
                        newConbinationMap.get(head).add(itemJ);
                    }
                }
                ++j;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        return newConbinationMap;
    }

    private ArrayList<int[]> bitset2intervals(BitSet bitSet) {
        ArrayList<int[]> timeIntervals = new ArrayList<int[]>();
        int left = -1;
        int soPer = this.maxSoPer;
        int preTS = bitSet.nextSetBit(1);
        int ts = bitSet.nextSetBit(preTS + 1);
        while (ts > 0) {
            if (ts - preTS <= this.maxPer && left == -1) {
                left = preTS;
                soPer = this.maxSoPer;
            }
            if (left != -1 && (soPer = Math.max(0, soPer + ts - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                }
                left = -1;
            }
            preTS = ts;
            ts = bitSet.nextSetBit(preTS + 1);
        }
        if (left != -1) {
            if ((soPer = Math.max(0, soPer + this.largestTs - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                }
            } else if (this.largestTs - left >= this.minDur) {
                timeIntervals.add(new int[]{left, this.largestTs});
            }
        }
        return timeIntervals;
    }

    private boolean generatePattern(Map.Entry<Integer, BitSet> entry, int k) throws IOException {
        ArrayList<int[]> timeIntervals = new ArrayList<int[]>();
        int left = -1;
        BitSet bitSet = entry.getValue();
        int soPer = this.maxSoPer;
        int preTS = bitSet.nextSetBit(1);
        int ts = bitSet.nextSetBit(preTS + 1);
        while (ts > 0) {
            if (ts - preTS <= this.maxPer && left == -1) {
                left = preTS;
                soPer = this.maxSoPer;
            }
            if (left != -1) {
                if ((soPer = Math.max(0, soPer + ts - preTS - this.maxPer)) > this.maxSoPer) {
                    if (preTS - left >= this.minDur) {
                        timeIntervals.add(new int[]{left, preTS});
                    } else {
                        bitSet.clear(left, preTS + 1);
                    }
                    left = -1;
                }
            } else {
                bitSet.clear(preTS);
            }
            preTS = ts;
            ts = bitSet.nextSetBit(preTS + 1);
        }
        if (left != -1) {
            if ((soPer = Math.max(0, soPer + this.largestTs - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                } else {
                    bitSet.clear(left, preTS + 1);
                }
            } else if (this.largestTs - left >= this.minDur) {
                timeIntervals.add(new int[]{left, this.largestTs});
            } else {
                bitSet.clear(left, this.largestTs + 1);
            }
        }
        if (timeIntervals.size() > 0) {
            this.save(new int[]{entry.getKey()}, timeIntervals, k);
            entry.setValue(bitSet);
            return true;
        }
        return false;
    }

    private Map<Integer, BitSet> convertTimeStamps(String input) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, BitSet> mapItemTS = new HashMap<Integer, BitSet>();
        if (this.selfIncrement) {
            String line;
            int ts = 1;
            while ((line = reader.readLine()) != null) {
                String[] lineSplited;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] stringArray = lineSplited = line.split(" ");
                int n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemString = stringArray[n2];
                    Integer itemName = Integer.parseInt(itemString);
                    if (!mapItemTS.containsKey(itemName)) {
                        mapItemTS.put(itemName, new BitSet());
                    }
                    ((BitSet)mapItemTS.get(itemName)).set(ts);
                    ++n2;
                }
                ++ts;
            }
            this.largestTs = ts - 1;
        } else {
            String line;
            int ts = 0;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                ts = Integer.parseInt(lineSplited[1]);
                String[] stringArray = lineItems;
                int n = lineItems.length;
                int n3 = 0;
                while (n3 < n) {
                    String itemString = stringArray[n3];
                    Integer itemName = Integer.parseInt(itemString);
                    if (!mapItemTS.containsKey(itemName)) {
                        mapItemTS.put(itemName, new BitSet());
                    }
                    ((BitSet)mapItemTS.get(itemName)).set(ts);
                    ++n3;
                }
            }
            this.largestTs = ts;
        }
        reader.close();
        return mapItemTS;
    }

    private void save(int[] items, ArrayList<int[]> timeIntervals, int k) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            this.patterns.addItemset(new Itemset(items, timeIntervals), k);
        } else {
            StringBuilder buffer = new StringBuilder();
            int[] nArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                int item = nArray[n2];
                buffer.append(item);
                buffer.append(" ");
                ++n2;
            }
            buffer.append("#Time-Interval: ");
            for (int[] time : timeIntervals) {
                buffer.append("[ ");
                buffer.append(time[0]);
                buffer.append(" , ");
                buffer.append(time[1]);
                buffer.append(" ]  ");
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  LPPM_breadth(SPM) - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Intersection count : " + this.intersectionCount);
        System.out.println("===================================================");
    }
}

