/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.memu;

import ca.pfv.spmf.algorithms.frequentpatterns.memu.CAUEntry;
import ca.pfv.spmf.algorithms.frequentpatterns.memu.CAUList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMEMU {
    private long startTimestamp;
    private long endTimestamp;
    private int hauiCount;
    private long candidateCount;
    private Map<Integer, Integer> item2mau = null;
    private Map<Integer, Map<Integer, Long>> mapEUCS = null;
    private int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    private BufferedWriter writer = null;
    private int leastMAU;

    private Map<Integer, Integer> readProfits(String profitPath) throws IOException {
        System.out.println(profitPath);
        HashMap<Integer, Integer> item2profits = new HashMap<Integer, Integer>();
        BufferedReader in = new BufferedReader(new FileReader(profitPath));
        String line = null;
        String[] pair = null;
        while ((line = in.readLine()) != null) {
            pair = line.split(", ");
            item2profits.put(Integer.parseInt(pair[0].trim()), Integer.parseInt(pair[1].trim()));
        }
        in.close();
        return item2profits;
    }

    public void runAlgorithm(String inputProfit, String inputDB, String outputFilePath, int beta, int GLMAU) throws IOException {
        int quantity;
        int itemName;
        String curTran;
        this.startTimestamp = 0L;
        this.endTimestamp = 0L;
        this.hauiCount = 0;
        this.candidateCount = 0L;
        this.leastMAU = 0;
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.itemsetBuffer = new int[this.BUFFERS_SIZE];
        this.mapEUCS = new HashMap<Integer, Map<Integer, Long>>();
        HashMap<Integer, Long> item2auub = new HashMap<Integer, Long>();
        this.item2mau = new HashMap<Integer, Integer>();
        if (outputFilePath != null && !outputFilePath.equalsIgnoreCase("null")) {
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        Map<Integer, Integer> item2profits = this.readProfits(inputProfit);
        this.leastMAU = Integer.MAX_VALUE;
        for (Map.Entry<Integer, Integer> entry : item2profits.entrySet()) {
            int val = Math.max(entry.getValue() * beta, GLMAU);
            this.leastMAU = this.leastMAU > val ? val : this.leastMAU;
            this.item2mau.put(entry.getKey(), val);
        }
        BufferedReader dbReader = null;
        dbReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(inputDB))));
        while ((curTran = dbReader.readLine()) != null) {
            String[] items = curTran.split(" ");
            int maxItemUtility = -1;
            int i = 0;
            while (i < items.length) {
                itemName = Integer.parseInt(items[i].trim());
                quantity = Integer.parseInt(items[i + 1].trim());
                int tmputility = quantity * item2profits.get(itemName);
                if (maxItemUtility < tmputility) {
                    maxItemUtility = tmputility;
                }
                i += 2;
            }
            i = 0;
            while (i < items.length) {
                itemName = Integer.parseInt(items[i].trim());
                Long auub = (Long)item2auub.get(itemName);
                auub = auub == null ? (long)maxItemUtility : auub + (long)maxItemUtility;
                item2auub.put(itemName, auub);
                i += 2;
            }
        }
        dbReader.close();
        ArrayList<CAUList> listOfCAULists = new ArrayList<CAUList>();
        HashMap<Integer, CAUList> mapItemToUtilityList = new HashMap<Integer, CAUList>();
        for (Map.Entry entry : item2auub.entrySet()) {
            Integer item = (Integer)entry.getKey();
            if ((Long)item2auub.get(item) < (long)this.leastMAU) continue;
            CAUList uList = new CAUList(item);
            mapItemToUtilityList.put(item, uList);
            listOfCAULists.add(uList);
        }
        Collections.sort(listOfCAULists, new Comparator<CAUList>(){

            @Override
            public int compare(CAUList o1, CAUList o2) {
                return AlgoMEMU.this.compareItems(o1.item, o2.item);
            }
        });
        dbReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(inputDB))));
        int tid = 0;
        while ((curTran = dbReader.readLine()) != null) {
            Pair pair;
            String[] items = curTran.split(" ");
            ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
            int maxUtility = 0;
            int i = 0;
            while (i < items.length) {
                itemName = Integer.parseInt(items[i].trim());
                quantity = Integer.parseInt(items[i + 1].trim());
                int tmputility = quantity * item2profits.get(itemName);
                Pair pair2 = new Pair();
                pair2.item = itemName;
                pair2.utility = tmputility;
                if ((Long)item2auub.get(pair2.item) >= (long)this.leastMAU) {
                    if (maxUtility < pair2.utility) {
                        maxUtility = pair2.utility;
                    }
                    revisedTransaction.add(pair2);
                }
                i += 2;
            }
            Collections.sort(revisedTransaction, new Comparator<Pair>(){

                @Override
                public int compare(Pair o1, Pair o2) {
                    return AlgoMEMU.this.compareItems(o1.item, o2.item);
                }
            });
            int rmu = 0;
            int remu = 0;
            int i2 = revisedTransaction.size() - 1;
            while (i2 >= 0) {
                pair = (Pair)revisedTransaction.get(i2);
                rmu = pair.utility > rmu ? pair.utility : rmu;
                CAUList cauListOfItem = (CAUList)mapItemToUtilityList.get(pair.item);
                CAUEntry cauEntry = null;
                cauEntry = new CAUEntry(tid, pair.utility, rmu, remu);
                cauListOfItem.addElement(cauEntry);
                remu = remu < pair.utility ? pair.utility : remu;
                --i2;
            }
            i2 = 0;
            while (i2 < revisedTransaction.size()) {
                pair = (Pair)revisedTransaction.get(i2);
                Map<Integer, Long> subEAUCS = this.mapEUCS.get(pair.item);
                if (subEAUCS == null) {
                    subEAUCS = new HashMap<Integer, Long>();
                    this.mapEUCS.put(pair.item, subEAUCS);
                }
                int j = i2 + 1;
                while (j < revisedTransaction.size()) {
                    Pair pairAfter = (Pair)revisedTransaction.get(j);
                    Long twoAuub = subEAUCS.get(pairAfter.item);
                    if (twoAuub == null) {
                        subEAUCS.put(pairAfter.item, Long.valueOf(maxUtility));
                    } else {
                        subEAUCS.put(pairAfter.item, twoAuub + (long)maxUtility);
                    }
                    ++j;
                }
                ++i2;
            }
            ++tid;
        }
        dbReader.close();
        this.search(this.itemsetBuffer, 0, null, listOfCAULists, 0);
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.item2mau.get(item1) - this.item2mau.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void search(int[] prefix, int prefixLength, CAUList p, List<CAUList> cauListOfP, int sumMAUOfPrefix) throws IOException {
        int i = 0;
        while (i < cauListOfP.size()) {
            block10: {
                CAUList x = cauListOfP.get(i);
                int sumMAUOfPx = this.item2mau.get(x.item) + sumMAUOfPrefix;
                if (x.sumUtility >= (long)sumMAUOfPx) {
                    ++this.hauiCount;
                    if (this.writer != null) {
                        this.writeOut(prefix, prefixLength, x.item, (double)x.sumUtility / (double)(prefixLength + 1), (double)sumMAUOfPx / (double)(prefixLength + 1));
                    }
                }
                if (x.sumUtility + x.sumOfRemu * (long)(prefixLength + 1) < (long)sumMAUOfPx || x.sumOfRmu * (long)(prefixLength + 1) < (long)sumMAUOfPx) break block10;
                ArrayList<CAUList> exULs = new ArrayList<CAUList>();
                int j = i + 1;
                while (j < cauListOfP.size()) {
                    block12: {
                        CAUList y;
                        block11: {
                            y = cauListOfP.get(j);
                            Map<Integer, Long> auub1 = this.mapEUCS.get(x.item);
                            if (auub1 == null) break block11;
                            Long auub2 = auub1.get(y.item);
                            long mauOfPrefix = 0L;
                            if (prefixLength != 0) {
                                mauOfPrefix = sumMAUOfPrefix / prefixLength;
                            }
                            if (auub2 == null || auub2 < Math.max((long)this.leastMAU, mauOfPrefix)) break block12;
                        }
                        ++this.candidateCount;
                        CAUList pxy = this.construct(prefixLength + 1, p, x, y, sumMAUOfPx);
                        if (pxy != null) {
                            exULs.add(pxy);
                        }
                    }
                    ++j;
                }
                if (prefixLength == this.BUFFERS_SIZE) {
                    this.BUFFERS_SIZE += this.BUFFERS_SIZE / 4;
                    int[] tmp = new int[this.BUFFERS_SIZE];
                    System.arraycopy(this.itemsetBuffer, 0, tmp, 0, prefixLength);
                    this.itemsetBuffer = tmp;
                }
                this.itemsetBuffer[prefixLength] = x.item;
                this.search(this.itemsetBuffer, prefixLength + 1, x, exULs, sumMAUOfPx);
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private CAUList construct(int prefixLen, CAUList p, CAUList px, CAUList py, long sumMAUOfPx) {
        CAUList pxyUL = new CAUList(py.item);
        long sumOfRmu = px.sumOfRmu;
        long sumOfRemu = (long)((double)px.sumUtility / (double)prefixLen + (double)px.sumOfRemu);
        for (CAUEntry ex : px.cauEntries) {
            CAUEntry ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (Math.min(sumOfRemu = (long)((double)sumOfRemu - ((double)ex.utility / (double)prefixLen + (double)ex.remu)), sumOfRmu -= (long)ex.rmu) * (long)prefixLen >= sumMAUOfPx) continue;
                return null;
            }
            if (p == null) {
                CAUEntry eXY = new CAUEntry(ex.tid, ex.utility + ey.utility, ex.rmu, ey.remu);
                pxyUL.addElement(eXY);
                continue;
            }
            CAUEntry e = this.findElementWithTID(p, ex.tid);
            if (e == null) continue;
            CAUEntry eXY = new CAUEntry(ex.tid, ex.utility + ey.utility - e.utility, ex.rmu, ey.remu);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private CAUEntry findElementWithTID(CAUList ulist, int tid) {
        List<CAUEntry> list = ulist.cauEntries;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, double averageUtility, double mau) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(String.valueOf(prefix[i]) + " ");
            ++i;
        }
        buffer.append(item);
        buffer.append(" #AUTIL: ");
        buffer.append(String.format("%.2f", averageUtility));
        buffer.append(" #mau: " + String.format("%.2f", mau));
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  MEMU ALGORITHM v.2.36 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.hauiCount);
        System.out.println("===================================================");
    }

    private class Pair {
        int item = 0;
        int utility = 0;

        private Pair() {
        }
    }
}

