/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.mpfps;

import ca.pfv.spmf.algorithms.frequentpatterns.mpfps.SeqTidList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoMPFPS_DFS {
    double maxStandardDeviation = 200.0;
    double minRA = 0.01;
    int maxPeriodicity = 100;
    int minimumSupport = 2;
    int numOfSequences = 0;
    List<Integer> sequenceLengths = new ArrayList<Integer>();
    Map<int[], Double> result = new HashMap<int[], Double>();
    long totalTime;
    int patternCount;

    public void runAlgorithm(double maxStandardDeviation, double minRA, int maxPeriodicity, int minimumSupport, String inputFile, String outputFile) throws Exception {
        MemoryLogger.getInstance().reset();
        long startTime = System.currentTimeMillis();
        this.maxStandardDeviation = maxStandardDeviation;
        this.maxPeriodicity = maxPeriodicity;
        this.minRA = minRA;
        this.minimumSupport = minimumSupport;
        this.result = new HashMap<int[], Double>();
        this.sequenceLengths = new ArrayList<Integer>();
        this.numOfSequences = 0;
        List<SeqTidList> periodicFrequentPatterns = this.getFreqPeriodicPattern(inputFile);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        for (SeqTidList periodicPat : periodicFrequentPatterns) {
            out.println(periodicPat);
        }
        out.println();
        out.close();
        this.patternCount = periodicFrequentPatterns.size();
        MemoryLogger.getInstance().checkMemory();
        this.totalTime = System.currentTimeMillis() - startTime;
    }

    public void printStats() {
        System.out.println("=============  MPFPS_DFS v.2.40 - STATS =============");
        System.out.println("Pattern count: " + this.patternCount);
        System.out.println("Memory : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("Total time : " + this.totalTime + " ms");
        System.out.println("===================================================");
    }

    public List<SeqTidList> getSingleItemTidList(String fileName, int minSup) throws IOException {
        File file = new File(fileName);
        BufferedReader reader = null;
        String tempReader = null;
        ArrayList<SeqTidList> singleItemTidList = new ArrayList<SeqTidList>();
        int currentLine = 0;
        reader = new BufferedReader(new FileReader(file));
        while ((tempReader = reader.readLine()) != null) {
            if (tempReader.isEmpty() || tempReader.charAt(0) == '#' || tempReader.charAt(0) == '%' || tempReader.charAt(0) == '@') continue;
            String[] tempSplitted = tempReader.split(" ");
            int currentTran = 0;
            for (SeqTidList tempSeqTid : singleItemTidList) {
                tempSeqTid.newLine = true;
            }
            int i = 0;
            while (i < tempSplitted.length - 1) {
                boolean found = false;
                int temp = Integer.parseInt(tempSplitted[i]);
                int tempOfNext = Integer.parseInt(tempSplitted[i + 1]);
                if (temp != -1 && temp != -2) {
                    for (SeqTidList current : singleItemTidList) {
                        int lengthOfSequences = current.sequenceNum.size();
                        if (temp != current.itemSet[0]) continue;
                        if (current.sequenceNum.get(lengthOfSequences - 1) != currentLine) {
                            ArrayList<Integer> newTidSet = new ArrayList<Integer>();
                            newTidSet.add(currentTran);
                            current.seqTidSet.add(newTidSet);
                            current.sequenceNum.add(currentLine);
                            current.seqSupport.add(1);
                            current.newLine = false;
                        } else {
                            int length = current.seqTidSet.size();
                            current.seqTidSet.get(length - 1).add(currentTran);
                            int tempSup = current.seqSupport.get(length - 1);
                            current.seqSupport.set(length - 1, tempSup + 1);
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        SeqTidList current;
                        current = new SeqTidList(1);
                        current.itemSet[0] = temp;
                        current.seqTidSet.add(new ArrayList());
                        current.seqTidSet.get(0).add(currentTran);
                        current.seqSupport.add(1);
                        current.sequenceNum.add(currentLine);
                        singleItemTidList.add(current);
                    }
                } else if (temp == -1 && tempOfNext != -2) {
                    ++currentTran;
                } else if (temp == -1 && tempOfNext == -2) {
                    this.sequenceLengths.add(currentTran);
                    break;
                }
                ++i;
            }
            ++currentLine;
        }
        this.numOfSequences = currentLine;
        reader.close();
        ArrayList<SeqTidList> periodicSingleItemTidList = new ArrayList<SeqTidList>();
        for (SeqTidList temp : singleItemTidList) {
            int num = 0;
            Iterator<List<Integer>> iterator = temp.seqTidSet.iterator();
            while (iterator.hasNext()) {
                List<Integer> currentTidSet = iterator.next();
                if (!this.checkPeriodicity(currentTidSet, this.sequenceLengths.get(temp.sequenceNum.get(num)))) {
                    iterator.remove();
                    temp.sequenceNum.remove(num);
                    temp.seqSupport.remove(num);
                    continue;
                }
                ++num;
            }
            if (temp.seqTidSet.isEmpty()) continue;
            periodicSingleItemTidList.add(temp);
        }
        ArrayList<SeqTidList> tempTidlist = new ArrayList<SeqTidList>();
        for (SeqTidList temp : periodicSingleItemTidList) {
            int num = 0;
            SeqTidList tempSeqTidList = new SeqTidList();
            for (int sup : temp.seqSupport) {
                if (sup >= minSup) {
                    tempSeqTidList.seqTidSet.add(temp.seqTidSet.get(num));
                    tempSeqTidList.seqSupport.add(temp.seqSupport.get(num));
                    tempSeqTidList.sequenceNum.add(temp.sequenceNum.get(num));
                }
                ++num;
            }
            tempSeqTidList.itemSet = temp.itemSet;
            double seqRatio = (double)tempSeqTidList.seqSupport.size() / (double)this.numOfSequences;
            if (tempSeqTidList.seqSupport.size() <= 0 || !(seqRatio >= this.minRA)) continue;
            tempSeqTidList.ra = seqRatio;
            tempTidlist.add(tempSeqTidList);
        }
        return tempTidlist;
    }

    public List<SeqTidList> getFreqPeriodicPattern(String fileName) throws IOException {
        List<SeqTidList> freSingleItemTidlist = this.getSingleItemTidList(fileName, this.minimumSupport);
        List<SeqTidList> periodicFrequent = new ArrayList<SeqTidList>();
        periodicFrequent = this.periodicFrequent(freSingleItemTidlist, this.minimumSupport, periodicFrequent);
        return periodicFrequent;
    }

    public List<Integer> intersectTids(List<Integer> list1, List<Integer> list2) {
        ArrayList<Integer> common = new ArrayList<Integer>();
        int i = 0;
        while (i < list1.size()) {
            if (Collections.binarySearch(list2, list1.get(i)) >= 0) {
                common.add(list1.get(i));
            }
            ++i;
        }
        return common;
    }

    public int[] unionItemsets(int[] list1, int[] list2) {
        int len = list1.length;
        int[] unionItemSet = Arrays.copyOf(list1, len + 1);
        unionItemSet[len] = list2[len - 1];
        return unionItemSet;
    }

    public boolean checkBoundRa(List<Integer> tidSet, int lengthOfSequence) {
        boolean periodic = true;
        int length = tidSet.size();
        int[] periods = new int[length + 1];
        int temp = 0;
        double avgPr = 0.0;
        int sum = 0;
        double sumDevi = 0.0;
        double stanDevi = 0.0;
        Collections.sort(tidSet);
        int firstPeriod = tidSet.get(0) - 0;
        if (firstPeriod < 0 || firstPeriod > this.maxPeriodicity) {
            periodic = false;
        } else {
            periods[0] = firstPeriod;
        }
        int i = 0;
        while (i < length - 1) {
            temp = tidSet.get(i + 1) - tidSet.get(i);
            if (temp < 0 || temp > this.maxPeriodicity) {
                periodic = false;
                break;
            }
            periods[i + 1] = temp;
            sum += temp;
            ++i;
        }
        int lastPeriod = lengthOfSequence - tidSet.get(length - 1);
        if (lastPeriod < 0 || lastPeriod > this.maxPeriodicity) {
            periodic = false;
        } else {
            periods[length] = lastPeriod;
        }
        if (periodic) {
            avgPr = sum / length;
            int j = 0;
            while (j < periods.length) {
                sumDevi += ((double)periods[j] - avgPr) * ((double)periods[j] - avgPr);
                ++j;
            }
            stanDevi = Math.sqrt(sumDevi / (double)length);
            if (stanDevi > this.maxStandardDeviation) {
                periodic = false;
            }
        }
        return periodic;
    }

    public boolean checkPeriodicity(List<Integer> tidSet, int lengthOfSequence) {
        boolean periodic = true;
        int length = tidSet.size();
        int[] periods = new int[length + 1];
        int temp = 0;
        double avgPr = 0.0;
        int sum = 0;
        double sumDevi = 0.0;
        double stanDevi = 0.0;
        Collections.sort(tidSet);
        int firstPeriod = tidSet.get(0) - 0;
        if (firstPeriod < 0 || firstPeriod > this.maxPeriodicity) {
            periodic = false;
        } else {
            periods[0] = firstPeriod;
        }
        int i = 0;
        while (i < length - 1) {
            temp = tidSet.get(i + 1) - tidSet.get(i);
            if (temp < 0 || temp > this.maxPeriodicity) {
                periodic = false;
                break;
            }
            periods[i + 1] = temp;
            sum += temp;
            ++i;
        }
        int lastPeriod = lengthOfSequence - tidSet.get(length - 1);
        if (lastPeriod < 0 || lastPeriod > this.maxPeriodicity) {
            periodic = false;
        } else {
            periods[length] = lastPeriod;
        }
        if (periodic) {
            avgPr = sum / length;
            int j = 0;
            while (j < periods.length) {
                sumDevi += ((double)periods[j] - avgPr) * ((double)periods[j] - avgPr);
                ++j;
            }
            stanDevi = Math.sqrt(sumDevi / (double)length);
            if (stanDevi > this.maxStandardDeviation) {
                periodic = false;
            }
        }
        return periodic;
    }

    public List<SeqTidList> periodicFrequent(List<SeqTidList> tidlistOfTemp, int minSup, List<SeqTidList> result) {
        ArrayList<SeqTidList> tempTidList = new ArrayList<SeqTidList>();
        int i = 0;
        while (i < tidlistOfTemp.size()) {
            SeqTidList currentTidListA = tidlistOfTemp.get(i);
            result.add(currentTidListA);
            int len = currentTidListA.itemSet.length;
            int j = i + 1;
            while (j < tidlistOfTemp.size()) {
                SeqTidList currentTidListB = tidlistOfTemp.get(j);
                if (this.haveSamePrefix(currentTidListA, currentTidListB)) {
                    SeqTidList currentTidListAB = new SeqTidList(len + 1);
                    currentTidListAB.itemSet = this.unionItemsets(currentTidListA.itemSet, currentTidListB.itemSet);
                    List<Integer> interSequenceNum = this.intersectTids(currentTidListA.sequenceNum, currentTidListB.sequenceNum);
                    for (int serial : interSequenceNum) {
                        List<Integer> tidSetB;
                        int serialNumA = Collections.binarySearch(currentTidListA.sequenceNum, serial);
                        int serialNumB = Collections.binarySearch(currentTidListB.sequenceNum, serial);
                        List<Integer> tidSetA = currentTidListA.seqTidSet.get(serialNumA);
                        List<Integer> interTidsAB = this.intersectTids(tidSetA, tidSetB = currentTidListB.seqTidSet.get(serialNumB));
                        if (interTidsAB.isEmpty() || !this.checkPeriodicity(interTidsAB, interTidsAB.size())) continue;
                        currentTidListAB.seqTidSet.add(interTidsAB);
                        currentTidListAB.sequenceNum.add(serial);
                        currentTidListAB.seqSupport.add(interTidsAB.size());
                    }
                    tempTidList.add(currentTidListAB);
                }
                ++j;
            }
            ++i;
        }
        ArrayList<SeqTidList> cutTidList = new ArrayList<SeqTidList>();
        for (SeqTidList temp : tempTidList) {
            int num = 0;
            SeqTidList tempSeqTidList = new SeqTidList();
            for (int sup : temp.seqSupport) {
                if (sup >= minSup) {
                    tempSeqTidList.seqTidSet.add(temp.seqTidSet.get(num));
                    tempSeqTidList.seqSupport.add(temp.seqSupport.get(num));
                    tempSeqTidList.sequenceNum.add(temp.sequenceNum.get(num));
                }
                ++num;
            }
            tempSeqTidList.itemSet = temp.itemSet;
            double seqRatio = (double)tempSeqTidList.seqSupport.size() / (double)this.numOfSequences;
            if (tempSeqTidList.seqSupport.size() <= 0 || !(seqRatio >= this.minRA)) continue;
            cutTidList.add(tempSeqTidList);
        }
        tempTidList = cutTidList;
        if (tempTidList.isEmpty()) {
            return result;
        }
        return this.periodicFrequent(tempTidList, minSup, result);
    }

    public boolean haveSamePrefix(SeqTidList list1, SeqTidList list2) {
        int length = list1.itemSet.length;
        boolean havaSamePrefix = false;
        boolean temp = true;
        if (list1.itemSet.length == 1 && list2.itemSet.length == 1) {
            havaSamePrefix = true;
        } else {
            int i = 0;
            while (i < length - 1) {
                if (list1.itemSet[i] != list2.itemSet[i]) {
                    temp = false;
                }
                ++i;
            }
            if (temp && list1.itemSet[length - 1] != list2.itemSet[length - 1]) {
                havaSamePrefix = true;
            }
        }
        return havaSamePrefix;
    }

    public int compare(int[] first, int[] second) {
        int i = 0;
        while (i < first.length && i < second.length) {
            if (first[i] < second[i]) {
                return -1;
            }
            if (first[i] > second[i]) {
                return 1;
            }
            ++i;
        }
        return first.length - second.length;
    }
}

