/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.negFIN;

import ca.pfv.spmf.algorithms.frequentpatterns.negFIN.MyBitVector;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoNegFIN {
    long startTimestamp;
    long endTimestamp;
    public BMCTreeNode bmcTreeRoot;
    public SetEnumerationTreeNode nlRoot;
    private int numOfTrans;
    public int numOfFItem;
    int outputCount = 0;
    public int minSupport;
    public Item[] item;
    public int[] itemset;
    public int itemsetLen = 0;
    public int[] sameItems;
    public Map<Integer, ArrayList<BMCTreeNode>> mapItemNodeset;
    BufferedWriter writer = null;
    static Comparator<Item> comp = new Comparator<Item>(){

        @Override
        public int compare(Item a, Item b) {
            return b.num - a.num;
        }
    };

    void scanDB(String filename, double minSupport) throws IOException {
        String line;
        this.numOfTrans = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ++this.numOfTrans;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                } else {
                    count = count + 1;
                    mapItemCount.put(item, count);
                }
                ++n2;
            }
        }
        reader.close();
        this.minSupport = (int)Math.ceil(minSupport * (double)this.numOfTrans);
        this.numOfFItem = mapItemCount.size();
        Item[] tempItems = new Item[this.numOfFItem];
        int i = 0;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            tempItems[i] = new Item();
            tempItems[i].index = (Integer)entry.getKey();
            tempItems[i].num = (Integer)entry.getValue();
            ++i;
        }
        this.item = new Item[i];
        System.arraycopy(tempItems, 0, this.item, 0, i);
        this.numOfFItem = this.item.length;
        Arrays.sort(this.item, comp);
    }

    void construct_BMC_tree(String filename) throws IOException {
        String line;
        int bmcTreeNodeCount = 0;
        this.bmcTreeRoot.label = -1;
        this.bmcTreeRoot.bitmapCode = new MyBitVector(this.numOfFItem);
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        Item[] transaction = new Item[this.numOfFItem];
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int tLen = 0;
            String[] stringArray = lineSplited;
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                int itemX = Integer.parseInt(itemString);
                int j = 0;
                while (j < this.numOfFItem) {
                    if (itemX == this.item[j].index) {
                        transaction[tLen] = new Item();
                        transaction[tLen].index = itemX;
                        transaction[tLen].num = 0 - j;
                        ++tLen;
                        break;
                    }
                    ++j;
                }
                ++n2;
            }
            Arrays.sort(transaction, 0, tLen, comp);
            int curPos = 0;
            BMCTreeNode curRoot = this.bmcTreeRoot;
            BMCTreeNode rightSibling = null;
            while (curPos != tLen) {
                BMCTreeNode child = curRoot.firstChild;
                while (child != null) {
                    if (child.label == 0 - transaction[curPos].num) {
                        ++curPos;
                        ++child.count;
                        curRoot = child;
                        break;
                    }
                    if (child.rightSibling == null) {
                        rightSibling = child;
                        child = null;
                        break;
                    }
                    child = child.rightSibling;
                }
                if (child == null) break;
            }
            int j = curPos;
            while (j < tLen) {
                BMCTreeNode bmcTreeNode = new BMCTreeNode();
                bmcTreeNode.label = 0 - transaction[j].num;
                if (rightSibling != null) {
                    rightSibling.rightSibling = bmcTreeNode;
                    rightSibling = null;
                } else {
                    curRoot.firstChild = bmcTreeNode;
                }
                bmcTreeNode.rightSibling = null;
                bmcTreeNode.firstChild = null;
                bmcTreeNode.father = curRoot;
                bmcTreeNode.count = 1;
                curRoot = bmcTreeNode;
                ++bmcTreeNodeCount;
                ++j;
            }
        }
        reader.close();
        BMCTreeNode root = this.bmcTreeRoot.firstChild;
        this.mapItemNodeset = new HashMap<Integer, ArrayList<BMCTreeNode>>();
        block6: while (root != null) {
            root.bitmapCode = (MyBitVector)root.father.bitmapCode.clone();
            root.bitmapCode.set(root.label);
            ArrayList<BMCTreeNode> nodeset = this.mapItemNodeset.get(root.label);
            if (nodeset == null) {
                nodeset = new ArrayList();
                this.mapItemNodeset.put(root.label, nodeset);
            }
            nodeset.add(root);
            if (root.firstChild != null) {
                root = root.firstChild;
                continue;
            }
            if (root.rightSibling != null) {
                root = root.rightSibling;
                continue;
            }
            root = root.father;
            while (root != null) {
                if (root.rightSibling != null) {
                    root = root.rightSibling;
                    continue block6;
                }
                root = root.father;
            }
        }
    }

    void initializeSetEnumerationTree() {
        SetEnumerationTreeNode lastChild = null;
        int t = this.numOfFItem - 1;
        while (t >= 0) {
            SetEnumerationTreeNode nlNode = new SetEnumerationTreeNode();
            nlNode.label = t;
            nlNode.count = 0;
            nlNode.nodeset = this.mapItemNodeset.get(t);
            nlNode.firstChild = null;
            nlNode.next = null;
            nlNode.count = this.item[t].num;
            if (this.nlRoot.firstChild == null) {
                this.nlRoot.firstChild = nlNode;
                lastChild = nlNode;
            } else {
                lastChild.next = nlNode;
                lastChild = nlNode;
            }
            --t;
        }
    }

    public void constructing_frequent_itemset_tree(SetEnumerationTreeNode curNode, int level, int sameCount) throws IOException {
        SetEnumerationTreeNode child;
        MemoryLogger.getInstance().checkMemory();
        SetEnumerationTreeNode sibling = curNode.next;
        SetEnumerationTreeNode lastChild = null;
        while (sibling != null) {
            child = new SetEnumerationTreeNode();
            child.nodeset = new ArrayList<BMCTreeNode>();
            int countNegNodeset = 0;
            if (level == 1) {
                int i = 0;
                while (i < curNode.nodeset.size()) {
                    BMCTreeNode ni = curNode.nodeset.get(i);
                    if (!ni.bitmapCode.isSet(sibling.label)) {
                        child.nodeset.add(ni);
                        countNegNodeset += ni.count;
                    }
                    ++i;
                }
            } else {
                int j = 0;
                while (j < sibling.nodeset.size()) {
                    BMCTreeNode nj = sibling.nodeset.get(j);
                    if (nj.bitmapCode.isSet(curNode.label)) {
                        child.nodeset.add(nj);
                        countNegNodeset += nj.count;
                    }
                    ++j;
                }
            }
            child.count = curNode.count - countNegNodeset;
            if (child.count >= this.minSupport) {
                if (curNode.count == child.count) {
                    this.sameItems[sameCount++] = sibling.label;
                } else {
                    child.label = sibling.label;
                    child.firstChild = null;
                    child.next = null;
                    if (curNode.firstChild == null) {
                        curNode.firstChild = lastChild = child;
                    } else {
                        lastChild.next = child;
                        lastChild = child;
                    }
                }
            } else {
                child.nodeset = null;
            }
            sibling = sibling.next;
        }
        this.itemset[this.itemsetLen++] = curNode.label;
        this.writeItemsetsToFile(curNode, sameCount);
        child = curNode.firstChild;
        curNode.firstChild = null;
        while (child != null) {
            SetEnumerationTreeNode next = child.next;
            this.constructing_frequent_itemset_tree(child, level + 1, sameCount);
            child.next = null;
            child = next;
        }
        --this.itemsetLen;
    }

    private void writeItemsetsToFile(SetEnumerationTreeNode curNode, int sameCount) throws IOException {
        StringBuilder buffer = new StringBuilder();
        ++this.outputCount;
        int i = 0;
        while (i < this.itemsetLen) {
            buffer.append(this.item[this.itemset[i]].index);
            buffer.append(' ');
            ++i;
        }
        buffer.append("#SUP: ");
        buffer.append(curNode.count);
        buffer.append("\n");
        if (sameCount > 0) {
            long i2 = 1L;
            long max = 1 << sameCount;
            while (i2 < max) {
                int k = 0;
                while (k < this.itemsetLen) {
                    buffer.append(this.item[this.itemset[k]].index);
                    buffer.append(' ');
                    ++k;
                }
                int j = 0;
                while (j < sameCount) {
                    int isSet = (int)i2 & 1 << j;
                    if (isSet > 0) {
                        buffer.append(this.item[this.sameItems[j]].index);
                        buffer.append(' ');
                    }
                    ++j;
                }
                buffer.append("#SUP: ");
                buffer.append(curNode.count);
                buffer.append("\n");
                ++this.outputCount;
                ++i2;
            }
        }
        this.writer.write(buffer.toString());
    }

    public void printStats() {
        System.out.println("========== negFIN - STATS ============");
        System.out.println(" Minsup = " + this.minSupport + "\n Number of transactions: " + this.numOfTrans);
        System.out.println(" Number of frequent  itemsets: " + this.outputCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================");
    }

    public void runAlgorithm(String filename, double minsup, String output) throws IOException {
        this.bmcTreeRoot = new BMCTreeNode();
        this.nlRoot = new SetEnumerationTreeNode();
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.startTimestamp = System.currentTimeMillis();
        this.scanDB(filename, minsup);
        this.itemsetLen = 0;
        this.itemset = new int[this.numOfFItem];
        this.construct_BMC_tree(filename);
        this.nlRoot.label = this.numOfFItem;
        this.nlRoot.firstChild = null;
        this.nlRoot.next = null;
        this.initializeSetEnumerationTree();
        this.sameItems = new int[this.numOfFItem];
        SetEnumerationTreeNode curNode = this.nlRoot.firstChild;
        this.nlRoot.firstChild = null;
        SetEnumerationTreeNode next = null;
        while (curNode != null) {
            next = curNode.next;
            this.constructing_frequent_itemset_tree(curNode, 1, 0);
            curNode.next = null;
            curNode = next;
        }
        this.writer.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    class BMCTreeNode {
        public int label;
        public BMCTreeNode firstChild;
        public BMCTreeNode rightSibling;
        public BMCTreeNode father;
        public int count;
        MyBitVector bitmapCode;

        BMCTreeNode() {
        }
    }

    class Item {
        public int index;
        public int num;

        Item() {
        }
    }

    class SetEnumerationTreeNode {
        public int label;
        public SetEnumerationTreeNode firstChild;
        public SetEnumerationTreeNode next;
        public int count;
        List<BMCTreeNode> nodeset;

        SetEnumerationTreeNode() {
        }
    }
}

