/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.opusminer;

import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.FindClosure;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.Global;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.itemsetRec;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class PrintItemsets {
    public static boolean valgt(itemsetRec i1, itemsetRec i2) {
        return i1.value > i2.value;
    }

    public static void print_itemset(BufferedWriter writer, itemset is, boolean isCSVInputFile) throws IOException {
        Iterator item_it = is.iterator();
        while (item_it.hasNext()) {
            Integer integer = (Integer)item_it.next();
            if (isCSVInputFile) {
                String name = Global.itemNames.get(integer);
                writer.write(name);
            } else {
                writer.write(integer.toString());
            }
            if (!item_it.hasNext()) continue;
            writer.write(32);
        }
    }

    public static void print_itemsetRec(BufferedWriter f, itemsetRec is, boolean isCSVInputFile, boolean searchByLift) throws IOException {
        PrintItemsets.print_itemset(f, is, isCSVInputFile);
        String measure = searchByLift ? " #LIFT: " : " #LEVERAGE: ";
        f.write(" #SUP: " + is.count + measure + is.value);
        f.write(" #PVALUE: " + is.p);
        if (Global.printClosures) {
            itemset closure = new itemset();
            FindClosure.find_closure(is, closure);
            if (closure.size() > is.size()) {
                f.write(" #CLOSURE: ");
                PrintItemsets.print_itemset(f, closure, isCSVInputFile);
            }
        }
        f.newLine();
    }

    public static void print_itemsets(BufferedWriter f, ArrayList<itemsetRec> is, boolean isCSVInputFile, boolean searchByLift) throws IOException {
        Collections.sort(is, new Comparator<itemsetRec>(){

            @Override
            public int compare(itemsetRec i1, itemsetRec i2) {
                float val = i2.value - i1.value;
                if (val > 0.0f) {
                    return 1;
                }
                if (val < 0.0f) {
                    return -1;
                }
                return 0;
            }
        });
        Iterator<itemsetRec> it = is.iterator();
        int failed_count = 0;
        while (it.hasNext()) {
            itemsetRec itemsetRec2 = it.next();
            if (!itemsetRec2.self_sufficient) {
                ++failed_count;
                continue;
            }
            PrintItemsets.print_itemsetRec(f, itemsetRec2, isCSVInputFile, searchByLift);
        }
        if (failed_count != 0) {
            f.write("\n" + failed_count + " itemsets failed test for self sufficiency\n");
            for (itemsetRec itemsetRec2 : is) {
                if (itemsetRec2.self_sufficient) continue;
                PrintItemsets.print_itemsetRec(f, itemsetRec2, isCSVInputFile, searchByLift);
            }
        }
    }
}

