/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.pascal;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.pascal.ItemsetPascal;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoPASCAL {
    protected int k;
    protected int totalCandidateCount = 0;
    protected long startTimestamp;
    protected long endTimestamp;
    private int itemsetCount;
    private int minsupRelative;
    private List<int[]> database = null;
    BufferedWriter writer = null;
    int maxItemsetSize = Integer.MAX_VALUE;

    public void runAlgorithm(double minsup, String input, String output) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.itemsetCount = 0;
        this.totalCandidateCount = 0;
        MemoryLogger.getInstance().reset();
        int transactionCount = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        this.database = new ArrayList<int[]>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int[] transaction = new int[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                Integer item = Integer.parseInt(lineSplited[i]);
                transaction[i] = item;
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                } else {
                    count = count + 1;
                    mapItemCount.put(item, count);
                }
                ++i;
            }
            this.database.add(transaction);
            ++transactionCount;
        }
        reader.close();
        this.minsupRelative = (int)Math.ceil(minsup * (double)transactionCount);
        this.k = 1;
        ArrayList<ItemsetPascal> frequent1 = new ArrayList<ItemsetPascal>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            int itemsetSupport = (Integer)entry.getValue();
            if (itemsetSupport < this.minsupRelative || this.maxItemsetSize < 1) continue;
            ItemsetPascal itemset2 = new ItemsetPascal(new int[]{(Integer)entry.getKey()});
            itemset2.isGenerator = itemsetSupport != transactionCount;
            itemset2.pred_sup = transactionCount;
            itemset2.setAbsoluteSupport(itemsetSupport);
            frequent1.add(itemset2);
            this.saveItemsetToFile(itemset2);
        }
        mapItemCount = null;
        Collections.sort(frequent1, new Comparator<ItemsetPascal>(){

            @Override
            public int compare(ItemsetPascal o1, ItemsetPascal o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        this.totalCandidateCount += frequent1.size();
        if (frequent1.size() > 0 && this.maxItemsetSize > 1) {
            ArrayList<ItemsetPascal> level = null;
            this.k = 2;
            do {
                MemoryLogger.getInstance().checkMemory();
                List<ItemsetPascal> candidatesK = this.k == 2 ? this.generateCandidate2(frequent1) : this.generateCandidateSizeK(level);
                this.totalCandidateCount += candidatesK.size();
                for (ItemsetPascal candidate : candidatesK) {
                    if (!candidate.isGenerator) continue;
                    block5: for (int[] transaction : this.database) {
                        if (transaction.length < this.k) continue;
                        int pos = 0;
                        int[] nArray = transaction;
                        int n = transaction.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int item = nArray[n2];
                            if (item == candidate.itemset[pos]) {
                                if (++pos == candidate.itemset.length) {
                                    candidate.support = candidate.support + 1;
                                    continue block5;
                                }
                            } else if (item > candidate.itemset[pos]) continue block5;
                            ++n2;
                        }
                    }
                }
                level = new ArrayList<ItemsetPascal>();
                for (ItemsetPascal candidate : candidatesK) {
                    if (candidate.getAbsoluteSupport() < this.minsupRelative) continue;
                    if (candidate.getAbsoluteSupport() == candidate.pred_sup) {
                        candidate.isGenerator = false;
                    }
                    level.add(candidate);
                    this.saveItemsetToFile(candidate);
                }
                ++this.k;
            } while (!level.isEmpty() && this.k <= this.maxItemsetSize);
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private List<ItemsetPascal> generateCandidate2(List<ItemsetPascal> frequent1) {
        ArrayList<ItemsetPascal> candidates = new ArrayList<ItemsetPascal>();
        int i = 0;
        while (i < frequent1.size()) {
            ItemsetPascal itemset1 = frequent1.get(i);
            int item1 = itemset1.get(0);
            int j = i + 1;
            while (j < frequent1.size()) {
                ItemsetPascal itemset2 = frequent1.get(j);
                int item2 = itemset2.get(0);
                ItemsetPascal itemset3 = new ItemsetPascal(new int[]{item1, item2});
                itemset3.isGenerator = itemset1.isGenerator && itemset2.isGenerator;
                itemset3.pred_sup = Math.min(itemset1.getAbsoluteSupport(), itemset2.getAbsoluteSupport());
                if (!itemset3.isGenerator) {
                    itemset3.support = itemset3.pred_sup;
                }
                candidates.add(itemset3);
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    protected List<ItemsetPascal> generateCandidateSizeK(List<ItemsetPascal> levelK_1) {
        ArrayList<ItemsetPascal> candidates = new ArrayList<ItemsetPascal>();
        int i = 0;
        while (i < levelK_1.size()) {
            int[] itemset1 = levelK_1.get((int)i).itemset;
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block9: {
                    int[] itemset2 = levelK_1.get((int)j).itemset;
                    int k = 0;
                    while (k < itemset1.length) {
                        if (k == itemset1.length - 1) {
                            if (itemset1[k] >= itemset2[k]) {
                                break block1;
                            }
                        } else {
                            if (itemset1[k] >= itemset2[k]) {
                                if (itemset1[k] > itemset2[k]) break block1;
                            }
                            break block9;
                        }
                        ++k;
                    }
                    int[] newItemset = new int[itemset1.length + 1];
                    System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                    newItemset[itemset1.length] = itemset2[itemset2.length - 1];
                    ItemsetPascal newItemsetPascal = new ItemsetPascal(newItemset);
                    if (this.allSubsetsOfSizeK_1AreFrequent(newItemsetPascal, levelK_1)) {
                        if (!newItemsetPascal.isGenerator) {
                            newItemsetPascal.support = newItemsetPascal.pred_sup;
                        }
                        candidates.add(newItemsetPascal);
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(ItemsetPascal candidateItemset, List<ItemsetPascal> levelK_1) {
        int[] candidate = candidateItemset.itemset;
        int posRemoved = 0;
        while (posRemoved < candidate.length) {
            int first = 0;
            int last = levelK_1.size() - 1;
            boolean found = false;
            while (first <= last) {
                int middle = first + last >>> 1;
                if (ArraysAlgos.sameAs(levelK_1.get(middle).getItems(), candidate, posRemoved) < 0) {
                    first = middle + 1;
                    continue;
                }
                if (ArraysAlgos.sameAs(levelK_1.get(middle).getItems(), candidate, posRemoved) > 0) {
                    last = middle - 1;
                    continue;
                }
                found = true;
                int supportMiddle = levelK_1.get(middle).getAbsoluteSupport();
                boolean isAGenerator = levelK_1.get((int)middle).isGenerator;
                if (!isAGenerator) {
                    candidateItemset.isGenerator = false;
                }
                if (supportMiddle >= candidateItemset.pred_sup) break;
                candidateItemset.pred_sup = supportMiddle;
                break;
            }
            if (!found) {
                return false;
            }
            ++posRemoved;
        }
        return true;
    }

    void saveItemsetToFile(ItemsetPascal itemset2) throws IOException {
        this.writer.write(String.valueOf(itemset2.toString()) + " #SUP: " + itemset2.getAbsoluteSupport() + " #IS_GENERATOR " + itemset2.isGenerator);
        this.writer.newLine();
        ++this.itemsetCount;
    }

    public void printStats() {
        System.out.println("=============  PASCAL - STATS =============");
        System.out.println(" Candidates count : " + this.totalCandidateCount);
        System.out.println(" The algorithm stopped at size " + (this.k - 1) + ", because there is no candidate");
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxItemsetSize = length;
    }
}

