/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.skymine;

import ca.pfv.spmf.algorithms.frequentpatterns.skymine.AlgoSkyMine;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.UPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UPTree {
    List<Integer> headerList = null;
    boolean hasMoreThanOnePath = false;
    Map<Integer, UPNode> mapItemNodes = new HashMap<Integer, UPNode>();
    UPNode root = new UPNode();
    Map<Integer, UPNode> mapItemLastNode = new HashMap<Integer, UPNode>();

    public void addTransaction(List<Item> transaction, long RTU) {
        UPNode currentNode = this.root;
        int i = 0;
        long RemainingUtility = 0L;
        int size = transaction.size();
        i = 0;
        while (i < size) {
            int k = i + 1;
            while (k < transaction.size()) {
                RemainingUtility += transaction.get(k).getUtility();
                ++k;
            }
            int item = transaction.get(i).getName();
            short quantity = transaction.get(i).getQuantity();
            UPNode child = currentNode.getChildWithID(item);
            if (child == null) {
                long nodeUtility = RTU - RemainingUtility;
                RemainingUtility = 0L;
                currentNode = this.insertNewNode(currentNode, item, nodeUtility, -1, true, quantity);
            } else {
                long currentNU = child.nodeUtility;
                long nodeUtility = currentNU + (RTU - RemainingUtility);
                RemainingUtility = 0L;
                ++child.count;
                child.nodeUtility = nodeUtility;
                currentNode = child;
                if (child.min_node_quantity > quantity) {
                    child.min_node_quantity = quantity;
                }
            }
            ++i;
        }
    }

    public void addLocalTransaction(List<UPNode> localPath, long pathUtility, Map<Integer, Long> mapMinimumItemUtility, int pathCount) {
        UPNode currentlocalNode = this.root;
        int i = 0;
        long RemainingUtility = 0L;
        int size = localPath.size();
        i = 0;
        while (i < size) {
            int k = i + 1;
            while (k < localPath.size()) {
                UPNode search = localPath.get(k);
                RemainingUtility += (long)search.min_node_quantity * AlgoSkyMine.mapItemUtility.get(search.itemID) * (long)pathCount;
                ++k;
            }
            int item = localPath.get((int)i).itemID;
            UPNode child = currentlocalNode.getChildWithID(item);
            if (child == null) {
                long nodeUtility = pathUtility - RemainingUtility;
                RemainingUtility = 0L;
                currentlocalNode = this.insertNewNode(currentlocalNode, item, nodeUtility, pathCount, false, localPath.get((int)i).min_node_quantity);
            } else {
                long currentNU = child.nodeUtility;
                long nodeUtility = currentNU + (pathUtility - RemainingUtility);
                RemainingUtility = 0L;
                child.count += pathCount;
                child.nodeUtility = nodeUtility;
                currentlocalNode = child;
                if (child.min_node_quantity > localPath.get((int)i).min_node_quantity || child.min_node_quantity == 0) {
                    child.min_node_quantity = localPath.get((int)i).min_node_quantity;
                }
            }
            ++i;
        }
    }

    private UPNode insertNewNode(UPNode currentlocalNode, int item, long nodeUtility, int pathCount, boolean global, short min_quantity) {
        UPNode localheadernode;
        UPNode newNode = new UPNode();
        newNode.itemID = item;
        newNode.nodeUtility = nodeUtility;
        newNode.min_node_quantity = min_quantity;
        newNode.count = global ? 1 : pathCount;
        newNode.parent = currentlocalNode;
        currentlocalNode.childs.add(newNode);
        if (!this.hasMoreThanOnePath && currentlocalNode.childs.size() > 1) {
            this.hasMoreThanOnePath = true;
        }
        if ((localheadernode = this.mapItemNodes.get(item)) == null) {
            this.mapItemNodes.put(item, newNode);
            this.mapItemLastNode.put(item, newNode);
        } else {
            UPNode lastNode = this.mapItemLastNode.get(item);
            lastNode.nodeLink = newNode;
            this.mapItemLastNode.put(item, newNode);
        }
        return newNode;
    }

    void createHeaderList(final Map<Integer, Long> mapItemToEstimatedUtility) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                int compare = (int)((Long)mapItemToEstimatedUtility.get(id2) - (Long)mapItemToEstimatedUtility.get(id1));
                if (compare == 0) {
                    return id1 - id2;
                }
                return compare;
            }
        });
    }

    public String toString() {
        String output = "";
        output = String.valueOf(output) + "HEADER TABLE: " + this.mapItemNodes + " \n";
        output = String.valueOf(output) + "hasMoreThanOnePath: " + this.hasMoreThanOnePath + " \n";
        return String.valueOf(output) + this.toString("", this.root);
    }

    public String toString(String indent, UPNode node) {
        String output = String.valueOf(indent) + node.toString() + "\n";
        String childsOutput = "";
        for (UPNode child : node.childs) {
            childsOutput = String.valueOf(childsOutput) + this.toString(String.valueOf(indent) + " ", child);
        }
        return String.valueOf(output) + childsOutput;
    }
}

