/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.Itemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.SPPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.SPPTree;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.Support_maxla;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class AlgoTSPIN {
    private long startTimestamp;
    private long endTimestamp;
    private int lastTID = -1;
    private int itemsetCount;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;
    private int[] itemsetOutputBuffer = null;
    private int maxPatternLength = 1000;
    private boolean self_increment;
    private int minSup;
    private int maxPer;
    private int maxla;
    private int k;
    PriorityQueue<Itemset> kItemsets;
    private boolean usePlus = true;

    public AlgoTSPIN(int maxPer, int maxla, int k, boolean self_increment) {
        this.maxPer = maxPer;
        this.maxla = maxla;
        this.k = k;
        this.self_increment = self_increment;
    }

    public Itemsets runAlgorithm(String input, String output) throws FileNotFoundException, IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        MemoryLogger.getInstance().reset();
        MemoryLogger.getInstance().checkMemory();
        this.minSup = 1;
        this.kItemsets = new PriorityQueue();
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("Top " + this.k + " Stable periodic frequent itemsets");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
            this.itemsetOutputBuffer = new int[2000];
        }
        Map<Integer, Support_maxla> mapSPP_list = this.scanDatabaseToDetermineSPPlistOfSingleItems(input);
        SPPTree tree = new SPPTree();
        this.buildTreeByScanDataAgain(tree, input, mapSPP_list);
        System.out.println("# of node : " + tree.numberOfNode);
        if (tree.headerList.size() > 0) {
            this.itemsetBuffer = new int[2000];
            this.TSPIN(tree, this.itemsetBuffer, 0, mapSPP_list);
        }
        this.writeResultToFile(output);
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        return this.patterns;
    }

    private Map<Integer, Support_maxla> scanDatabaseToDetermineSPPlistOfSingleItems(String input) throws IOException {
        int n;
        String[] lineSplited;
        String line;
        int current_TID;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, Support_maxla> mapSPP_list = new HashMap<Integer, Support_maxla>();
        HashMap<Integer, Integer> preTID = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> prela = new HashMap<Integer, Integer>();
        HashSet pruningSet = new HashSet();
        if (this.self_increment) {
            current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] stringArray = lineSplited = line.split(" ");
                n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    int pre_TID;
                    int per;
                    String itemString = stringArray[n2];
                    Integer item_name = Integer.parseInt(itemString);
                    if (!(this.usePlus && pruningSet.contains(item_name) || (per = current_TID - (pre_TID = preTID.getOrDefault(item_name, 0).intValue())) == 0)) {
                        int current_la = Math.max(0, prela.getOrDefault(item_name, 0) + per - this.maxPer);
                        if (this.usePlus && current_la > this.maxla) {
                            if (mapSPP_list.containsKey(item_name)) {
                                mapSPP_list.remove(item_name);
                            }
                        } else {
                            if (!mapSPP_list.containsKey(item_name)) {
                                mapSPP_list.put(item_name, new Support_maxla());
                            }
                            ((Support_maxla)mapSPP_list.get(item_name)).setMaxla(current_la);
                            prela.put(item_name, current_la);
                            preTID.put(item_name, current_TID);
                            ((Support_maxla)mapSPP_list.get(item_name)).increaseSupport();
                        }
                    }
                    ++n2;
                }
                ++current_TID;
            }
            this.lastTID = current_TID - 1;
        } else {
            current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                System.out.print(lineSplited[1]);
                current_TID = Integer.parseInt(lineSplited[1]);
                String[] stringArray = lineItems;
                int n3 = lineItems.length;
                n = 0;
                while (n < n3) {
                    String itemString = stringArray[n];
                    Integer item_name = Integer.parseInt(itemString);
                    int pre_TID = preTID.getOrDefault(item_name, 0);
                    int per = current_TID - pre_TID;
                    if (per != 0) {
                        int current_la = Math.max(0, prela.getOrDefault(item_name, 0) + per - this.maxPer);
                        if (this.usePlus && current_la > this.maxla) {
                            if (mapSPP_list.containsKey(item_name)) {
                                mapSPP_list.remove(item_name);
                            }
                        } else {
                            if (!mapSPP_list.containsKey(item_name)) {
                                mapSPP_list.put(item_name, new Support_maxla());
                            }
                            ((Support_maxla)mapSPP_list.get(item_name)).setMaxla(current_la);
                            prela.put(item_name, current_la);
                            preTID.put(item_name, current_TID);
                            ((Support_maxla)mapSPP_list.get(item_name)).increaseSupport();
                        }
                    }
                    ++n;
                }
            }
            this.lastTID = current_TID;
        }
        reader.close();
        Iterator it = mapSPP_list.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            int item_name = (Integer)entry.getKey();
            ((Support_maxla)entry.getValue()).setMaxla((Integer)prela.get(item_name) + this.lastTID - (Integer)preTID.get(item_name) - this.maxPer);
            if (((Support_maxla)entry.getValue()).getSupport() >= this.minSup && ((Support_maxla)entry.getValue()).getMaxla() <= this.maxla) continue;
            it.remove();
        }
        prela.clear();
        preTID.clear();
        return mapSPP_list;
    }

    private void buildTreeByScanDataAgain(SPPTree tree, String input, final Map<Integer, Support_maxla> mapSPP_list) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        if (this.self_increment) {
            String line;
            int current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.split(" ");
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                String[] stringArray = lineSplited;
                int n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemString = stringArray[n2];
                    Integer item_name = Integer.parseInt(itemString);
                    if (mapSPP_list.containsKey(item_name) && !transaction.contains(item_name)) {
                        transaction.add(item_name);
                    }
                    ++n2;
                }
                Collections.sort(transaction, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer item1, Integer item2) {
                        int compare = ((Support_maxla)mapSPP_list.get(item2)).getSupport() - ((Support_maxla)mapSPP_list.get(item1)).getSupport();
                        if (compare == 0) {
                            return item1 - item2;
                        }
                        return compare;
                    }
                });
                if (transaction.size() > 0) {
                    tree.addTransaction(transaction, current_TID);
                }
                ++current_TID;
            }
        } else {
            String line;
            int current_TID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.trim().split("\\|");
                String[] lineItems = lineSplited[0].trim().split(" ");
                current_TID = Integer.parseInt(lineSplited[1]);
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                String[] stringArray = lineItems;
                int n = lineItems.length;
                int n3 = 0;
                while (n3 < n) {
                    String itemString = stringArray[n3];
                    Integer item_name = Integer.parseInt(itemString);
                    if (mapSPP_list.containsKey(item_name) && !transaction.contains(item_name)) {
                        transaction.add(item_name);
                    }
                    ++n3;
                }
                Collections.sort(transaction, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer item1, Integer item2) {
                        int compare = ((Support_maxla)mapSPP_list.get(item2)).getSupport() - ((Support_maxla)mapSPP_list.get(item1)).getSupport();
                        if (compare == 0) {
                            return item1 - item2;
                        }
                        return compare;
                    }
                });
                if (transaction.size() <= 0) continue;
                tree.addTransaction(transaction, current_TID);
            }
        }
        reader.close();
        tree.createHeaderList(null, mapSPP_list);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void TSPIN(SPPTree tree, int[] prefix, int prefixLength, Map<Integer, Support_maxla> mapSPP_list) throws IOException {
        if (prefixLength != this.maxPatternLength) ** GOTO lbl42
        return;
lbl-1000:
        // 1 sources

        {
            item = tree.headerList.get(tree.headerList.size() - 1);
            prefix[prefixLength] = item;
            this.saveItemset(prefix, prefixLength + 1, mapSPP_list.get(item).getSupport(), mapSPP_list.get(item).getMaxla());
            if (prefixLength + 1 >= this.maxPatternLength) continue;
            prefixPaths = new ArrayList<ArrayList<E>>();
            path = tree.mapItemNodes.get(item);
            mapBetaTIDs = new HashMap<Integer, List<Integer>>();
            while (path != null) {
                if (path.parent.itemID != -1) {
                    prefixPath = new ArrayList<SPPNode>();
                    prefixPath.add(path);
                    pathTIDs = path.TIDs;
                    parent = path.parent;
                    while (parent.itemID != -1) {
                        prefixPath.add(parent);
                        if (mapBetaTIDs.get(parent.itemID) == null) {
                            mapBetaTIDs.put(parent.itemID, (List<Integer>)new ArrayList<Integer>(pathTIDs){
                                {
                                    this.addAll(list);
                                }
                            });
                        } else {
                            ((List)mapBetaTIDs.get(parent.itemID)).addAll(pathTIDs);
                        }
                        parent = parent.parent;
                    }
                    prefixPaths.add(prefixPath);
                }
                path = path.nodeLink;
            }
            mapBetaSPPlist = this.getMapBetaSPPlist(mapBetaTIDs);
            if (mapBetaSPPlist.size() > 0) {
                treeBeta = new SPPTree();
                for (List prefixPath : prefixPaths) {
                    treeBeta.addPrefixPath(prefixPath, mapBetaSPPlist);
                }
                if (treeBeta.root.childs.size() > 0) {
                    treeBeta.createHeaderList(tree.headerList, mapBetaSPPlist);
                    this.TSPIN(treeBeta, prefix, prefixLength + 1, mapBetaSPPlist);
                }
            }
            tree.removeTailItem();
lbl42:
            // 3 sources

            ** while (tree.headerList.size() > 0)
        }
lbl43:
        // 1 sources

        MemoryLogger.getInstance().checkMemory();
    }

    private void saveItemset(int[] itemset2, int itemsetLength, int support, int maxla) throws IOException {
        ++this.itemsetCount;
        System.arraycopy(itemset2, 0, this.itemsetOutputBuffer, 0, itemsetLength);
        Arrays.sort(this.itemsetOutputBuffer, 0, itemsetLength);
        ArrayList<Integer> testItem = new ArrayList<Integer>();
        int i = 0;
        while (i < itemsetLength) {
            testItem.add(this.itemsetOutputBuffer[i]);
            ++i;
        }
        Itemset testItemset = new Itemset(testItem, support, maxla);
        this.kItemsets.add(testItemset);
        if (this.kItemsets.size() > this.k && support > this.minSup) {
            do {
                this.kItemsets.poll();
            } while (this.kItemsets.size() > this.k);
            this.minSup = this.kItemsets.peek().getAbsoluteSupport();
        }
    }

    private Map<Integer, Support_maxla> getMapBetaSPPlist(Map<Integer, List<Integer>> mapBetaTIDs) {
        HashMap<Integer, Support_maxla> mapBetaSPPlist = new HashMap<Integer, Support_maxla>();
        block0: for (Map.Entry<Integer, List<Integer>> entry : mapBetaTIDs.entrySet()) {
            Support_maxla sm = new Support_maxla();
            List<Integer> TIDs = entry.getValue();
            Collections.sort(TIDs);
            int pre_TID = 0;
            int pre_la = 0;
            for (int current_TID : TIDs) {
                int current_la = Math.max(0, pre_la + current_TID - pre_TID - this.maxPer);
                if (this.usePlus && current_la > this.maxla) continue block0;
                sm.setMaxla(current_la);
                sm.increaseSupport();
                pre_TID = current_TID;
                pre_la = current_la;
            }
            int current_la = Math.max(0, pre_la + this.lastTID - pre_TID - this.maxPer);
            sm.setMaxla(current_la);
            if (sm.getSupport() < this.minSup || sm.getMaxla() > this.maxla) continue;
            mapBetaSPPlist.put(entry.getKey(), sm);
        }
        mapBetaTIDs.clear();
        return mapBetaSPPlist;
    }

    public void writeResultToFile(String output) throws IOException {
        Iterator<Itemset> iter = this.kItemsets.iterator();
        while (iter.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            Itemset itemset2 = iter.next();
            int i = 0;
            while (i < itemset2.itemset.length) {
                buffer.append(itemset2.getItems()[i]);
                if (i != itemset2.itemset.length - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append("  #SUP: ");
            buffer.append(itemset2.support);
            buffer.append("  #MAXLA: ");
            buffer.append(itemset2.maxla);
            this.writer.write(buffer.toString());
            if (!iter.hasNext()) continue;
            this.writer.newLine();
        }
        this.writer.close();
    }

    public void printStats() {
        System.out.println("=============  TSPIN  - STATS ===============");
        long temps = this.endTimestamp - this.startTimestamp;
        System.out.print(" Max memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " mb \n");
        System.out.println(" Itemset counts : " + this.itemsetCount);
        System.out.println(" k itemset count: " + this.kItemsets.size());
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("minSup: " + this.minSup);
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxPatternLength = length;
    }

    public void cancelSelfIncrement() {
        this.self_increment = false;
    }
}

