/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tku;

import ca.pfv.spmf.algorithms.frequentpatterns.tku.StringPair;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

class AlgoPhase2OfTKU {
    private int minUtility;
    private int theCurrentK;
    private int numberOfTransactions;
    private String inputFilePath;
    private String sortedCandidatePath;
    private String temporaryFilePathWHUIs = "HUI.txt";
    private String outputTopKHUIsFilePath;
    private final String delimiter = ":";
    private int numTopKHUI;

    AlgoPhase2OfTKU() {
    }

    void runAlgorithm(int minUtil, int transactionCount, int currentK, String inputPath, String sortedCandidateFile, String outputFile) throws IOException {
        this.minUtility = minUtil;
        this.numberOfTransactions = transactionCount;
        this.theCurrentK = currentK;
        this.inputFilePath = inputPath;
        this.sortedCandidatePath = sortedCandidateFile;
        this.outputTopKHUIsFilePath = outputFile;
        FileWriter fw = new FileWriter(this.temporaryFilePathWHUIs);
        BufferedWriter bfw = new BufferedWriter(fw);
        ArrayList[] HDB = new ArrayList[this.numberOfTransactions];
        ArrayList[] BNF = new ArrayList[this.numberOfTransactions];
        this.initialization(HDB, BNF, HDB.length);
        AlgoPhase2OfTKU.readDatabase(HDB, BNF, HDB.length, this.inputFilePath);
        this.readCandidateItemsets(HDB, BNF, HDB.length, this.sortedCandidatePath, bfw);
        FileReader bf1 = new FileReader(this.temporaryFilePathWHUIs);
        BufferedReader bfr1 = new BufferedReader(bf1);
        FileWriter fw1 = new FileWriter(this.outputTopKHUIsFilePath);
        BufferedWriter bfw1 = new BufferedWriter(fw1);
        String record = "";
        this.setNumberOfTopKHUIs(0);
        while ((record = bfr1.readLine()) != null) {
            String[] temp = record.split(":");
            if (Integer.parseInt(temp[1]) < this.minUtility) continue;
            record = record.replace(":", " #UTIL: ");
            bfw1.write(record);
            bfw1.newLine();
            this.setNumberOfTopKHUIs(this.getNumberOfTopKHUIs() + 1);
        }
        bfw1.flush();
        fw1.close();
        bfw1.close();
        bf1.close();
        bfr1.close();
        fw.close();
        bfw.close();
        File fileToDelete = new File(this.temporaryFilePathWHUIs);
        fileToDelete.delete();
        fileToDelete = new File(sortedCandidateFile);
        fileToDelete.delete();
    }

    int readCandidateItemsets(ArrayList<Integer>[] HDB, ArrayList<Integer>[] BNF, int num_trans, String CIPath, BufferedWriter Lbfw) throws IOException {
        RedBlackTree<StringPair> Heap = new RedBlackTree<StringPair>(true);
        FileReader bf = new FileReader(CIPath);
        BufferedReader bfr = new BufferedReader(bf);
        int num_HU = 0;
        String CIR = "";
        while ((CIR = bfr.readLine()) != null) {
            String[] CI = CIR.split(":");
            int Match_Count = 0;
            int EUtility = 0;
            String[] candidate = CI[0].split(" ");
            if (Integer.parseInt(CI[1]) < this.minUtility) continue;
            int i = 0;
            while (i < num_trans) {
                if (HDB[i].size() != 0) {
                    Match_Count = 0;
                    int PUtility = 0;
                    int s = 0;
                    while (s < candidate.length) {
                        if (HDB[i].contains(Integer.parseInt(candidate[s]))) {
                            ++Match_Count;
                            int index = HDB[i].indexOf(Integer.parseInt(candidate[s]));
                            ArrayList<Integer> B = BNF[i];
                            int Ben = B.get(index);
                            PUtility += Ben;
                        } else {
                            PUtility = 0;
                            break;
                        }
                        ++s;
                    }
                    if (Match_Count == candidate.length) {
                        EUtility += PUtility;
                    }
                }
                ++i;
            }
            if (EUtility < this.minUtility) continue;
            Lbfw.write(String.valueOf(CI[0]) + ":" + EUtility);
            Lbfw.newLine();
            this.updateHeap(Heap, CI[0], EUtility);
            ++num_HU;
        }
        Lbfw.flush();
        bf.close();
        bfr.close();
        return num_HU;
    }

    static void readDatabase(ArrayList<Integer>[] HDB, ArrayList<Integer>[] BNF, int num_trans, String DBPath) throws IOException {
        FileReader bf = new FileReader(DBPath);
        BufferedReader bfr = new BufferedReader(bf);
        String record = "";
        int trans_count = 0;
        while ((record = bfr.readLine()) != null) {
            String[] data = record.split(":");
            String[] transaction = data[0].split(" ");
            String[] benefit = data[2].split(" ");
            int i = 0;
            while (i < transaction.length) {
                HDB[trans_count].add(Integer.parseInt(transaction[i]));
                BNF[trans_count].add(Integer.parseInt(benefit[i]));
                ++i;
            }
            ++trans_count;
        }
    }

    void initialization(ArrayList[] HDB, ArrayList[] BNF, int num_trans) {
        int i = 0;
        while (i < num_trans) {
            HDB[i] = new ArrayList(0);
            BNF[i] = new ArrayList(0);
            ++i;
        }
    }

    void updateHeap(RedBlackTree<StringPair> NCH, String HUI2, int Utility) {
        if (NCH.size() < this.theCurrentK) {
            NCH.add(new StringPair(HUI2, Utility));
        } else if (NCH.size() >= this.theCurrentK && Utility > this.minUtility) {
            NCH.add(new StringPair(HUI2, Utility));
            NCH.popMinimum();
        }
        if (NCH.minimum().y > this.minUtility && NCH.size() >= this.theCurrentK) {
            this.minUtility = NCH.minimum().y;
        }
    }

    int getNumberOfTopKHUIs() {
        return this.numTopKHUI;
    }

    void setNumberOfTopKHUIs(int numTopKHUI) {
        this.numTopKHUI = numTopKHUI;
    }
}

