/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tkuce;

import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoTKUCE {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 2000;
    final int iterations = 2000;
    int transactionCount;
    int K;
    int minUtility = 0;
    final float alpha = 0.2f;
    Map<Integer, Integer> mapItemToTWU;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    float[] p;
    List<Particle> population = new ArrayList<Particle>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Item> Items;
    List<Particle> huiTopKBA = new ArrayList<Particle>();

    public void runAlgorithm(String input, String output, int k) throws IOException {
        block32: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block30: {
                this.K = k;
                MemoryLogger.getInstance().reset();
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            ++this.transactionCount;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= this.minUtility) {
                                revisedTransaction.add(pair);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU.keySet());
        Collections.sort(this.twuPattern);
        this.p = new float[this.twuPattern.size()];
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        int i = 0;
        while (i < this.database.size()) {
            int j = 0;
            while (j < this.Items.size()) {
                int m = 0;
                while (m < this.database.get(i).size()) {
                    if (this.Items.get((int)j).item == this.database.get((int)i).get((int)m).item) {
                        this.Items.get((int)j).TIDS.set(i);
                    }
                    ++m;
                }
                ++j;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.twuPattern.size() > 0) {
            this.generatePop();
            int i2 = 0;
            while (i2 < 2000) {
                Collections.sort(this.population, new Comparator<Particle>(){

                    @Override
                    public int compare(Particle itemset1, Particle itemset2) {
                        return -(itemset1.fitness - itemset2.fitness);
                    }
                });
                int max_min = this.population.get((int)0).fitness - this.population.get((int)1999).fitness;
                if (max_min == 0) break;
                this.update();
                ++i2;
            }
            i2 = 0;
            while (i2 < this.K) {
                if (i2 <= this.huiTopKBA.size() - 1) {
                    this.insert(this.huiTopKBA.get(i2));
                }
                ++i2;
            }
            int next = this.K;
            while (this.huiTopKBA.get((int)next).fitness == this.huiTopKBA.get((int)(next - 1)).fitness) {
                this.insert(this.huiTopKBA.get(next));
                ++next;
            }
        }
        this.writeOut();
        MemoryLogger.getInstance().checkMemory();
        this.maxMemory = MemoryLogger.getInstance().getMaxMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void generatePop() {
        int i = 0;
        while (i < 2000) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = (int)(Math.random() * (double)this.twuPattern.size()) + 1;
                if (tempParticle.X.get(temp)) continue;
                ++j;
                tempParticle.X.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(tempParticle, transList);
            tempParticle.calculateFitness(k, transList);
            this.population.add(i, tempParticle);
            this.insertTopList(this.population.get(i));
            ++i;
        }
    }

    private void update() {
        int[] num = new int[this.twuPattern.size()];
        int i = 0;
        while ((float)i < 400.0f) {
            int j = 0;
            while (j < this.twuPattern.size()) {
                if (this.population.get((int)i).X.get(j)) {
                    int n = j;
                    num[n] = num[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        this.minUtility = this.population.get((int)399).fitness;
        i = 0;
        while (i < this.twuPattern.size()) {
            this.p[i] = (float)((double)num[i] / 400.0);
            ++i;
        }
        int k = 0;
        int i2 = 0;
        while (i2 < 2000) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            this.update_Particle(tempParticle);
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(tempParticle, transList);
            k = tempParticle.X.cardinality();
            tempParticle.calculateFitness(k, transList);
            this.population.add(i2, tempParticle);
            this.insertTopList(this.population.get(i2));
            ++i2;
        }
    }

    private void update_Particle(Particle temp) {
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (Math.random() < (double)this.p[i]) {
                temp.X.set(i);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertTopList(Particle tmp) {
        block7: {
            temp = new Particle();
            temp.copyParticle(tmp);
            if (this.huiTopKBA.size() == 0) {
                this.huiTopKBA.add(temp);
                return;
            }
            max = 0;
            min = this.K - 1;
            mid = 0;
            if (this.huiTopKBA.size() >= this.K) break block7;
            min = this.huiTopKBA.size() - 1;
            if (temp.fitness < this.huiTopKBA.get((int)min).fitness) {
                this.huiTopKBA.add(temp);
                return;
            }
            ** GOTO lbl28
        }
        if (temp.fitness >= this.huiTopKBA.get((int)min).fitness) ** GOTO lbl28
        return;
lbl-1000:
        // 1 sources

        {
            mid = (max + min) / 2;
            if (temp.fitness > this.huiTopKBA.get((int)mid).fitness) {
                min = mid - 1;
                continue;
            }
            if (temp.fitness < this.huiTopKBA.get((int)mid).fitness) {
                max = mid + 1;
                continue;
            }
            return;
lbl28:
            // 4 sources

            ** while (max <= min)
        }
lbl29:
        // 1 sources

        if (temp.fitness >= this.huiTopKBA.get((int)mid).fitness) {
            this.huiTopKBA.add(mid, temp);
        } else {
            this.huiTopKBA.add(mid + 1, temp);
        }
    }

    public boolean isRBAIndividual(Particle tempBAIndividual, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempBAIndividual.X.get(i)) {
                templist.add(i);
            }
            ++i;
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.transactionCount);
        BitSet midBitSet = new BitSet(this.transactionCount);
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        int i2 = 1;
        while (i2 < templist.size()) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i2)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
            } else {
                tempBitSet = (BitSet)midBitSet.clone();
                tempBAIndividual.X.clear((Integer)templist.get(i2));
            }
            ++i2;
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        int m = 0;
        while (m < tempBitSet.length()) {
            if (tempBitSet.get(m)) {
                list.add(m);
            }
            ++m;
        }
        return true;
    }

    private void insert(Particle tempParticle) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.X.get(i)) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
            }
        }
    }

    private void writeOut() throws IOException {
        int i = 0;
        while (i < this.huiSets.size()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL:");
            buffer.append(this.huiSets.get((int)i).fitness);
            this.writer.write(buffer.toString());
            this.writer.newLine();
            ++i;
        }
    }

    public void printStats() {
        System.out.println("============= TKU-CE Algorithm v 2.52 ==========");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("================================================");
    }

    static class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item(int item) {
            this.TIDS = new BitSet(AlgoTKUCE.this.transactionCount);
            this.item = item;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class Particle {
        BitSet X;
        int fitness;

        public Particle() {
            this.X = new BitSet(AlgoTKUCE.this.twuPattern.size());
        }

        public Particle(int length) {
            this.X = new BitSet(length);
        }

        public void copyParticle(Particle particle1) {
            this.X = (BitSet)particle1.X.clone();
            this.fitness = particle1.fitness;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            int m = 0;
            while (m < templist.size()) {
                int p = templist.get(m);
                int i = 0;
                int q = 0;
                int temp = 0;
                int sum = 0;
                while (q < AlgoTKUCE.this.database.get(p).size() && i < AlgoTKUCE.this.twuPattern.size()) {
                    if (this.X.get(i)) {
                        if (AlgoTKUCE.this.database.get((int)p).get((int)q).item == AlgoTKUCE.this.twuPattern.get(i)) {
                            sum += AlgoTKUCE.this.database.get((int)p).get((int)q).utility;
                            ++i;
                            ++q;
                            ++temp;
                            continue;
                        }
                        ++q;
                        continue;
                    }
                    ++i;
                }
                if (temp == k) {
                    fitness += sum;
                }
                ++m;
            }
            this.fitness = fitness;
        }
    }
}

