/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ulbminer;

import ca.pfv.spmf.algorithms.frequentpatterns.ulbminer.Element;
import java.util.ArrayList;

public class UtilityListBuffer {
    ArrayList<Element> elements = new ArrayList();
    ArrayList<Summary> summaries = new ArrayList();
    public Summary currentSummary = null;
    int allocatedElementCountForLastUtilityList = 0;

    public UtilityListBuffer(int sumSupport, int itemCount) {
        this.elements = new ArrayList(sumSupport * 2);
        this.summaries = new ArrayList(itemCount * 2);
    }

    public UtilityListBuffer() {
        this.elements = new ArrayList();
        this.summaries = new ArrayList();
    }

    public void selectCurrentUtilityList(int utilityListIndex) {
        this.currentSummary = this.summaries.get(utilityListIndex);
    }

    public int getSumIUtilCurrentUtilityList() {
        return this.currentSummary.sumIUtils;
    }

    public int getSumRUtilCurrentUtilityList() {
        return this.currentSummary.sumRUtils;
    }

    public int getItemCurrentUtilityList() {
        return this.currentSummary.item;
    }

    public int getElementCountCurrentUtilityList() {
        return this.currentSummary.endPos - this.currentSummary.startPos;
    }

    public Element getIthElementInCurrentUtilityList(int elementNumber) {
        return this.elements.get(this.currentSummary.startPos + elementNumber);
    }

    public void createANewUtilityList(int item, int utilityListIndex) {
        if (utilityListIndex >= this.summaries.size()) {
            this.currentSummary = new Summary();
            this.summaries.add(this.currentSummary);
        } else {
            this.currentSummary = this.summaries.get(utilityListIndex);
        }
        this.currentSummary.item = item;
        this.currentSummary.sumIUtils = 0;
        this.currentSummary.sumRUtils = 0;
        if (utilityListIndex == 0) {
            this.currentSummary.startPos = 0;
            this.currentSummary.endPos = 0;
        } else {
            Summary previousUtilityList = this.summaries.get(utilityListIndex - 1);
            this.currentSummary.endPos = this.currentSummary.startPos = previousUtilityList.endPos + this.allocatedElementCountForLastUtilityList;
        }
        this.allocatedElementCountForLastUtilityList = 0;
    }

    public void addElementToCurrentUtilityList(int tid, int iutil, int rutil) {
        int insertionPosition = this.currentSummary.endPos;
        if (insertionPosition >= this.elements.size()) {
            this.elements.add(new Element(tid, iutil, rutil));
        } else {
            Element element = this.elements.get(insertionPosition);
            element.tid = tid;
            element.iutils = iutil;
            element.rutils = rutil;
        }
        this.currentSummary.sumIUtils += iutil;
        this.currentSummary.sumRUtils += rutil;
        ++this.currentSummary.endPos;
    }

    public void allocateSpaceForElements(int support) {
        int i = 0;
        while (i < support) {
            this.elements.add(new Element());
            ++i;
        }
        this.allocatedElementCountForLastUtilityList = support;
    }

    public Element findElementWithTIDCurrenUtilityList(int tid) {
        int first = this.currentSummary.startPos;
        int last = this.currentSummary.endPos - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (this.elements.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (this.elements.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return this.elements.get(middle);
        }
        return null;
    }

    public void finishBuildingSingleItemsUtilityLists() {
        this.allocatedElementCountForLastUtilityList = 0;
    }

    public void printToString() {
        System.out.println(" ====== ELEMENTS ======");
        int i = 0;
        while (i < this.elements.size()) {
            System.out.println("tid = " + this.elements.get((int)i).tid + " iutil " + this.elements.get((int)i).iutils + " rutil " + this.elements.get((int)i).rutils);
            ++i;
        }
        System.out.println(" ====== UTILITY-lISTS ======");
        i = 0;
        while (i < this.summaries.size()) {
            Summary summary = this.summaries.get(i);
            System.out.println("item = " + summary.item + " start " + summary.startPos + " end " + summary.endPos + " sumI " + summary.sumIUtils + " sumR " + summary.sumRUtils);
            ++i;
        }
    }

    class Summary {
        Integer item;
        int startPos;
        int endPos;
        int sumIUtils;
        int sumRUtils;

        Summary() {
        }
    }
}

