/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup;

import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPNodePlus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UPTreePlus {
    List<Integer> headerList = null;
    boolean hasMoreThanOnePath = false;
    Map<Integer, UPNodePlus> mapItemNodes = new HashMap<Integer, UPNodePlus>();
    UPNodePlus root = new UPNodePlus();
    Map<Integer, UPNodePlus> mapItemLastNode = new HashMap<Integer, UPNodePlus>();

    public void addTransaction(List<Item> transaction, int RTU) {
        UPNodePlus currentNode = this.root;
        int i = 0;
        int RemainingUtility = 0;
        int size = transaction.size();
        i = 0;
        while (i < size) {
            int k = i + 1;
            while (k < transaction.size()) {
                RemainingUtility += transaction.get(k).getUtility();
                ++k;
            }
            int item = transaction.get(i).getName();
            int MinimalNodeUtility = transaction.get(i).getUtility();
            UPNodePlus child = currentNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = RTU - RemainingUtility;
                RemainingUtility = 0;
                currentNode = this.insertNewNode(currentNode, item, nodeUtility, MinimalNodeUtility);
            } else {
                int currentNU = child.nodeUtility;
                int nodeUtility = currentNU + (RTU - RemainingUtility);
                RemainingUtility = 0;
                ++child.count;
                child.nodeUtility = nodeUtility;
                int currentUtility = transaction.get(i).getUtility();
                if (currentUtility < child.minimalNodeUtility) {
                    child.minimalNodeUtility = currentUtility;
                }
                currentNode = child;
            }
            ++i;
        }
    }

    public void addLocalTransaction(List<Integer> localPath, int pathUtility, Map<Integer, Integer> mapMiniNodeUtility, int pathCount) {
        UPNodePlus currentlocalNode = this.root;
        int i = 0;
        int RemainingUtility = 0;
        int size = localPath.size();
        i = 0;
        while (i < size) {
            int k = i + 1;
            while (k < localPath.size()) {
                int search = localPath.get(k);
                RemainingUtility += mapMiniNodeUtility.get(search) * pathCount;
                ++k;
            }
            int item = localPath.get(i);
            int minimalNodeUtility = mapMiniNodeUtility.get(item);
            UPNodePlus child = currentlocalNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = pathUtility - RemainingUtility;
                RemainingUtility = 0;
                currentlocalNode = this.insertNewNode(currentlocalNode, item, nodeUtility, minimalNodeUtility);
            } else {
                int currentNU = child.nodeUtility;
                int nodeUtility = currentNU + (pathUtility - RemainingUtility);
                RemainingUtility = 0;
                ++child.count;
                child.nodeUtility = nodeUtility;
                child.minimalNodeUtility = minimalNodeUtility;
                currentlocalNode = child;
            }
            ++i;
        }
    }

    private UPNodePlus insertNewNode(UPNodePlus currentlocalNode, int item, int nodeUtility, int MinimalNodeUtility) {
        UPNodePlus localheadernode;
        UPNodePlus newNode = new UPNodePlus();
        newNode.itemID = item;
        newNode.nodeUtility = nodeUtility;
        newNode.count = 1;
        newNode.minimalNodeUtility = MinimalNodeUtility;
        newNode.parent = currentlocalNode;
        currentlocalNode.childs.add(newNode);
        if (!this.hasMoreThanOnePath && currentlocalNode.childs.size() > 1) {
            this.hasMoreThanOnePath = true;
        }
        if ((localheadernode = this.mapItemNodes.get(item)) == null) {
            this.mapItemNodes.put(item, newNode);
            this.mapItemLastNode.put(item, newNode);
        } else {
            UPNodePlus lastNode = this.mapItemLastNode.get(item);
            lastNode.nodeLink = newNode;
            this.mapItemLastNode.put(item, newNode);
        }
        return newNode;
    }

    void createHeaderList(final Map<Integer, Integer> mapItemToEstimatedUtility) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                int compare = (Integer)mapItemToEstimatedUtility.get(id2) - (Integer)mapItemToEstimatedUtility.get(id1);
                if (compare == 0) {
                    return id1 - id2;
                }
                return compare;
            }
        });
    }

    public String toString() {
        String output = "";
        output = String.valueOf(output) + "HEADER TABLE: " + this.mapItemNodes + " \n";
        output = String.valueOf(output) + "hasMoreThanOnePath: " + this.hasMoreThanOnePath + " \n";
        return String.valueOf(output) + this.toString("", this.root);
    }

    public String toString(String indent, UPNodePlus node) {
        String output = String.valueOf(indent) + node.toString() + "\n";
        String childsOutput = "";
        for (UPNodePlus child : node.childs) {
            childsOutput = String.valueOf(childsOutput) + this.toString(String.valueOf(indent) + " ", child);
        }
        return String.valueOf(output) + childsOutput;
    }
}

