/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import ca.pfv.spmf.algorithms.graph_mining.aerminer.Vertex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributedGraph {
    private Map<Integer, Vertex> vMap = new HashMap<Integer, Vertex>();
    private Map<Integer, Set<Integer>> edgesMap = new HashMap<Integer, Set<Integer>>();

    public AttributedGraph(int stage) {
    }

    public void addVertex(int id) {
        this.vMap.put(id, new Vertex(id));
    }

    public Vertex getVertex(int id) {
        return this.vMap.get(id);
    }

    public void addAttrValForV(int vId, List<Integer> attrList, List<Double> valList) {
        Vertex v = this.vMap.get(vId);
        v.addAttrsValsForV(attrList, valList);
    }

    public void addEdges(int v1, List<Integer> v2L) {
        for (int v2 : v2L) {
            this.addEdge(v1, v2);
        }
    }

    public void addEdge(int v1, int v2) {
        Set<Integer> v1Neighbors = this.edgesMap.get(v1);
        Set<Integer> v2Neighbors = this.edgesMap.get(v2);
        if (v1Neighbors == null) {
            v1Neighbors = new HashSet<Integer>();
            this.edgesMap.put(v1, v1Neighbors);
        }
        if (v2Neighbors == null) {
            v2Neighbors = new HashSet<Integer>();
            this.edgesMap.put(v2, v2Neighbors);
        }
        v1Neighbors.add(v2);
        v2Neighbors.add(v1);
    }

    public int getVerNum() {
        return this.vMap.size();
    }

    public Iterable<Integer> getAllVerticeId() {
        return this.vMap.keySet();
    }

    public Map<Integer, Set<Integer>> getEdgesMap() {
        return this.edgesMap;
    }

    public Set<Integer> getNeighbors(int vId) {
        return this.getEdgesMap().get(vId) == null ? new HashSet<Integer>() : this.getEdgesMap().get(vId);
    }
}

