/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import ca.pfv.spmf.algorithms.graph_mining.aerminer.AttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.ParametersSettingAERMiner;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.Vertex;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class EnlargeGraph {
    private static boolean ALLASDOUBLE = true;
    private static int TOTAL_NUM_ATTR = ParametersSettingAERMiner.TOTAL_NUM_ATTR;
    private static String ATTR_FILE_PATH = ParametersSettingAERMiner.ATTR_FILE_PATH;
    private static String EDGE_FILE_PATH = ParametersSettingAERMiner.EDGE_FILE_PATH;
    private static String VERTICES_FILE_PATH = ParametersSettingAERMiner.VERTEX_MAP_NAME_PATH;
    private static int VERTEXNUM = ParametersSettingAERMiner.VERTEXNUM;
    private static int MOVENUM = 10000;

    public static void main(String[] args) throws IOException {
        int[] enlarge;
        int[] nArray = enlarge = new int[]{1, 5, 10, 15, 20, 25, 30, 50};
        int n = enlarge.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            EnlargeGraph.statGraph(i);
            ++n2;
        }
    }

    public static void statGraph(int enlargeSize) throws IOException {
        Map<Integer, AttributedGraph> dyAG = EnlargeGraph.readEnLargeGraph(enlargeSize);
        int numTimestamps = dyAG.size();
        int numVertices = dyAG.get(0).getVerNum();
        int totalCount4E = 0;
        for (Map.Entry<Integer, AttributedGraph> entry : dyAG.entrySet()) {
            int i = entry.getKey();
            AttributedGraph aG = dyAG.get(i);
            for (Map.Entry<Integer, Set<Integer>> edgeLinkEntry : aG.getEdgesMap().entrySet()) {
                totalCount4E += edgeLinkEntry.getValue().size();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("total timestamps: ").append(numTimestamps);
        sb.append("\ntotal vertices: ").append(numVertices);
        sb.append("\naverage edges for each vertex each timestamp: ").append(1.0 * (double)totalCount4E / (double)(numTimestamps * numVertices));
        System.out.println(sb.toString());
        FileWriter fileWriterAttr = new FileWriter(String.valueOf(ATTR_FILE_PATH) + "_" + enlargeSize + ".txt");
        FileWriter fileWriterEdge = new FileWriter(String.valueOf(EDGE_FILE_PATH) + "_" + enlargeSize + ".txt");
        int t = 0;
        while (t < dyAG.size()) {
            Object v;
            fileWriterAttr.write("T" + t + "\n");
            fileWriterEdge.write("T" + t + "\n");
            AttributedGraph attributedGraph = dyAG.get(t);
            Map<Integer, Set<Integer>> edgesMap = attributedGraph.getEdgesMap();
            for (Map.Entry<Integer, Set<Integer>> entry2 : edgesMap.entrySet()) {
                v = entry2.getKey();
                fileWriterEdge.write("" + v);
                for (int otherV : edgesMap.get(v)) {
                    fileWriterEdge.write(" " + otherV);
                }
                fileWriterEdge.write("\n");
            }
            Iterator<Object> iterator = attributedGraph.getAllVerticeId().iterator();
            while (iterator.hasNext()) {
                int vId = (Integer)iterator.next();
                v = attributedGraph.getVertex(vId);
                fileWriterAttr.write(String.valueOf(vId));
                int i = 1;
                while (i <= TOTAL_NUM_ATTR) {
                    fileWriterAttr.write(" " + ((Vertex)v).getAttrDouMap().get(i));
                    ++i;
                }
                fileWriterAttr.write("\n");
            }
            ++t;
        }
        fileWriterAttr.close();
        fileWriterEdge.close();
        FileWriter fileWriterMapping = new FileWriter(String.valueOf(VERTICES_FILE_PATH) + "_" + enlargeSize + ".txt");
        BufferedReader br = new BufferedReader(new FileReader(VERTICES_FILE_PATH));
        String line = br.readLine();
        while (line != null) {
            String[] split = line.split(",");
            int id = Integer.parseInt(split[0]);
            int i = 0;
            while (i < enlargeSize) {
                fileWriterMapping.write(String.valueOf(id + (MOVENUM + VERTEXNUM) * i) + "," + split[1] + "\n");
                ++i;
            }
            line = br.readLine();
        }
        fileWriterMapping.close();
        br.close();
    }

    public static Map<Integer, AttributedGraph> readEnLargeGraph(int size) throws IOException {
        System.out.println("@@@ start to read original graph ...");
        HashMap<Integer, AttributedGraph> DyAG = new HashMap<Integer, AttributedGraph>();
        EnlargeGraph.readEnLargeGraphAttributes(DyAG, size);
        System.out.println(DyAG.size());
        EnlargeGraph.readEnLargeGraphEdges(DyAG, size);
        System.out.println("reading graph finish !");
        return DyAG;
    }

    private static void readEnLargeGraphEdges(Map<Integer, AttributedGraph> dyAG, int enlargerSize) throws IOException {
        BufferedReader brEdges = new BufferedReader(new FileReader(EDGE_FILE_PATH));
        String line2 = brEdges.readLine();
        while (line2 != null) {
            if (!line2.startsWith("T")) continue;
            int aGId = Integer.parseInt(line2.split("T")[1]);
            AttributedGraph aG = dyAG.get(aGId);
            while ((line2 = brEdges.readLine()) != null && !line2.startsWith("T")) {
                EnlargeGraph.edgeLineProcessEnlarge(aG, line2, enlargerSize);
            }
        }
        brEdges.close();
    }

    private static void edgeLineProcessEnlarge(AttributedGraph aG, String line, int enlargerSize) {
        String[] items = line.split(" ");
        int enlarge = 0;
        while (enlarge < enlargerSize) {
            int vId = Integer.parseInt(items[0]) + enlarge * (aG.getVerNum() + MOVENUM);
            LinkedList<Integer> neighbors = new LinkedList<Integer>();
            int i = 1;
            while (i < items.length) {
                neighbors.add(Integer.parseInt(items[i]) + enlarge * (VERTEXNUM + MOVENUM));
                ++i;
            }
            aG.addEdges(vId, neighbors);
            ++enlarge;
        }
    }

    private static void readEnLargeGraphAttributes(Map<Integer, AttributedGraph> dyAG, int enlargeSize) throws IOException {
        BufferedReader brAttr = new BufferedReader(new FileReader(ATTR_FILE_PATH));
        String line1 = brAttr.readLine();
        int count = 0;
        while (line1 != null) {
            if (line1.startsWith("T")) {
                AttributedGraph aG = new AttributedGraph(count);
                while ((line1 = brAttr.readLine()) != null && !line1.startsWith("T")) {
                    EnlargeGraph.attrLineProcessEnlarge(aG, line1, enlargeSize);
                }
                dyAG.put(count, aG);
            }
            ++count;
        }
        brAttr.close();
    }

    private static void attrLineProcessEnlarge(AttributedGraph aG, String line, int enlargeSize) {
        String[] items = line.split(" ");
        int enlarge = 0;
        while (enlarge < enlargeSize) {
            int vId = Integer.parseInt(items[0]) + (VERTEXNUM + MOVENUM) * enlarge;
            aG.addVertex(vId);
            if (ALLASDOUBLE) {
                LinkedList<Integer> attrTypes = new LinkedList<Integer>();
                LinkedList<Double> attrVals = new LinkedList<Double>();
                int i = 1;
                while (i < TOTAL_NUM_ATTR + 1) {
                    Double val = Double.parseDouble(items[i]);
                    attrTypes.add(i);
                    attrVals.add(val);
                    ++i;
                }
                aG.addAttrValForV(vId, attrTypes, attrVals);
            }
            ++enlarge;
        }
    }
}

