/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import ca.pfv.spmf.algorithms.graph_mining.aerminer.SupportPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Instance {
    private SupportPoint childPoint;
    private List<Integer> parentVIds = new ArrayList<Integer>();

    public Instance(SupportPoint childPoint) {
        this.childPoint = childPoint;
    }

    public void growParent(int vId) {
        this.parentVIds.add(vId);
    }

    public List<Integer> getParentVIds() {
        return this.parentVIds;
    }

    public SupportPoint getChildPoint() {
        return this.childPoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance instance = (Instance)o;
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int i = 0;
        while (i < this.getParentVIds().size()) {
            sb1.append(this.getParentVIds().get(i));
            sb2.append(instance.parentVIds.get(i));
            ++i;
        }
        return this.getChildPoint().equals(instance.getChildPoint()) && sb1.toString().equals(sb2.toString());
    }

    public int hashCode() {
        return Objects.hash(this.getChildPoint(), this.getParentVIds());
    }

    public String toString() {
        return "Instance{childPoint=" + this.childPoint + ", parentVIds=" + this.parentVIds + '}';
    }

    public Instance clone() {
        SupportPoint csp = this.getChildPoint();
        Instance cloneInstance = new Instance(new SupportPoint(csp.getTimestamp(), csp.getvId()));
        for (int vId : this.getParentVIds()) {
            cloneInstance.growParent(vId);
        }
        return cloneInstance;
    }
}

