/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import ca.pfv.spmf.algorithms.graph_mining.aerminer.AttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.ParametersSettingAERMiner;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.ReadGraph;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Preprocess {
    private static String[] trends = new String[]{"-", "=", "+"};
    static Map<Integer, String> attrMapping;
    static Map<Integer, String> eventTypeMapping;
    static Map<String, Integer> eventTypeMappingRe;

    public static void main(String[] args) throws IOException {
        Map<Integer, AttributedGraph> trendGraph = Preprocess.convertToTrendGraph();
        System.out.println(trendGraph.size());
    }

    public static Map<Integer, AttributedGraph> convertToTrendGraph() throws IOException {
        System.out.println("Start to convert to trend graph");
        Preprocess.findEventTypeMapping();
        Map<Integer, AttributedGraph> oriDyAG = ReadGraph.readGraph();
        HashMap<Integer, AttributedGraph> trendDyAG = new HashMap<Integer, AttributedGraph>();
        int i = 0;
        while (i < oriDyAG.size() - 1) {
            AttributedGraph aG1 = oriDyAG.get(i);
            AttributedGraph aG2 = oriDyAG.get(i + 1);
            AttributedGraph tmpGraph = new AttributedGraph(i);
            for (int vId : aG1.getAllVerticeId()) {
                tmpGraph.addVertex(vId);
                Map<Integer, Double> attrMap1 = aG1.getVertex(vId).getAttrDouMap();
                Map<Integer, Double> attrMap2 = aG2.getVertex(vId).getAttrDouMap();
                for (Map.Entry<Integer, Double> entry : attrMap1.entrySet()) {
                    Integer attrType = entry.getKey();
                    double val1 = attrMap1.get(attrType);
                    double val2 = attrMap2.get(attrType);
                    int trendFlag = -999;
                    double diff = val2 - val1;
                    if (diff >= 1.0) {
                        trendFlag = 2;
                    } else if (diff <= -1.0) {
                        trendFlag = 0;
                    } else if (val2 > 0.0) {
                        trendFlag = 1;
                    }
                    int mapAttri = 3 * (attrType - 1) + trendFlag + 1;
                    if (mapAttri <= 0 || mapAttri > ParametersSettingAERMiner.TOTAL_NUM_ATTR * 3) continue;
                    tmpGraph.getVertex(vId).addAttrValForV(mapAttri, 0.0);
                }
            }
            for (int v1 : aG1.getEdgesMap().keySet()) {
                for (int v2 : aG1.getEdgesMap().get(v1)) {
                    tmpGraph.addEdge(v1, v2);
                }
            }
            trendDyAG.put(i, tmpGraph);
            ++i;
        }
        System.out.println("preprocessing finish !");
        Preprocess.repeatGraph(trendDyAG);
        return trendDyAG;
    }

    public static Map<Integer, String> findEventTypeMapping() throws IOException {
        attrMapping = Preprocess.readAttrMapping();
        int count = 1;
        for (Map.Entry<Integer, String> entry : attrMapping.entrySet()) {
            Integer attrType = entry.getKey();
            String attrName = attrMapping.get(attrType);
            String[] stringArray = trends;
            int n = trends.length;
            int n2 = 0;
            while (n2 < n) {
                String trend = stringArray[n2];
                String eventName = String.valueOf(attrName) + trend;
                if (eventTypeMapping == null) {
                    eventTypeMapping = new HashMap<Integer, String>();
                }
                if (eventTypeMappingRe == null) {
                    eventTypeMappingRe = new HashMap<String, Integer>();
                }
                eventTypeMapping.put(count, eventName);
                eventTypeMappingRe.put(eventName, count);
                ++count;
                ++n2;
            }
        }
        return eventTypeMapping;
    }

    public static Map<Integer, String> readAttrMapping() throws IOException {
        LinkedHashMap<Integer, String> attrMap = new LinkedHashMap<Integer, String>();
        BufferedReader br = new BufferedReader(new FileReader(ParametersSettingAERMiner.ATTRI_MAPPING_PATH));
        int count = 1;
        String line = br.readLine();
        while (line != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            attrMap.put(count++, line);
            line = br.readLine();
        }
        ParametersSettingAERMiner.TOTAL_NUM_ATTR = attrMap.size();
        br.close();
        return attrMap;
    }

    private static void repeatGraph(Map<Integer, AttributedGraph> tempItemDyAG) {
        int repeatNum = ParametersSettingAERMiner.REPEAT;
        int oriSize = tempItemDyAG.size();
        int timeStamp = 0;
        while (timeStamp < oriSize) {
            AttributedGraph itemAG = tempItemDyAG.get(timeStamp);
            int i = 1;
            while (i < repeatNum) {
                tempItemDyAG.put(oriSize * i + timeStamp, itemAG);
                ++i;
            }
            ++timeStamp;
        }
    }
}

